/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class MavenRepoBuilder {
    private static final String ROOT_PATH = "repository";
    private static final String POM = ".pom";
    private static final String MD5 = ".md5";
    private static final String SHA = ".sha";
    private final Path localMvnRepoPath;
    private final Path targetDirectory;

    public MavenRepoBuilder(Path targetDirectory, Path localMvnRepoPath) {
        this.localMvnRepoPath = localMvnRepoPath;
        this.targetDirectory = targetDirectory;
    }

    public void add(Path artifactLocalPath) {
        this.addArtifact(this.localMvnRepoPath, artifactLocalPath);
        try (Stream<Path> files = Files.list(artifactLocalPath.getParent());){
            files.filter(MavenRepoBuilder::checkAddPath).forEach(new Consumer<Path>(){

                @Override
                public void accept(Path t) {
                    MavenRepoBuilder.this.addArtifact(MavenRepoBuilder.this.localMvnRepoPath, t);
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't retrieve files in " + String.valueOf(artifactLocalPath.getParent()), ex);
        }
    }

    private void addArtifact(Path localMvnRepoPath, Path artifactLocalPath) {
        Path relativized = localMvnRepoPath.relativize(artifactLocalPath);
        Path pathInZipfile = Paths.get(this.targetDirectory.toString(), ROOT_PATH, relativized.toString());
        try {
            Files.createDirectories(pathInZipfile.getParent(), new FileAttribute[0]);
            Files.copy(artifactLocalPath, pathInZipfile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't add " + String.valueOf(artifactLocalPath) + " to directory", ex);
        }
    }

    private static boolean checkAddPath(Path path) {
        String name = path.toString();
        return name.endsWith(POM) || name.endsWith(MD5) || name.endsWith(SHA);
    }
}

