/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.Stability;
import org.jboss.galleon.api.GalleonLayerDependency;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.layout.FeaturePackDescription;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.universe.UniverseResolver;
import org.wildfly.galleon.plugin.doc.generator.Metadata;

class MetadataGenerator {
    private static final String SEPARATOR = "/";
    private static final String ATTRIBUTE_SEPARATOR = "@@@";
    private static final String GLN_UNDEFINED = "GLN_UNDEFINED";
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private final List<RemoteRepository> repositories;
    private final MavenProject project;
    private final boolean addFeaturePacksDependenciesInMetadata;
    private final String copyright;

    MetadataGenerator(MavenProject project, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> repositories, boolean addFeaturePacksDependenciesInMetadata, String copyright) {
        this.project = project;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.repositories = repositories;
        this.addFeaturePacksDependenciesInMetadata = addFeaturePacksDependenciesInMetadata;
        this.copyright = copyright;
    }

    void generateMetadata(Path featurePack, FeaturePackDescription desc, Path metadataTarget) throws Exception {
        MavenArtifactRepositoryManager repo = new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
        UniverseResolver resolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver((RepositoryArtifactResolver)repo)).build();
        ProvisioningLayoutFactory fact = ProvisioningLayoutFactory.getInstance((UniverseResolver)resolver);
        fact.addLocal(featurePack, false);
        ProvisioningLayout pl = fact.newConfigLayout(featurePack, false);
        this.generateMetadata(desc, (ProvisioningLayout<FeaturePackLayout>)pl, metadataTarget);
    }

    private void generateMetadata(FeaturePackDescription desc, ProvisioningLayout<FeaturePackLayout> pl, Path metadataTarget) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        List<String> licenses = this.project.getLicenses().stream().map(License::getName).toList();
        String scmUrl = null;
        if (this.project.getScm() != null) {
            scmUrl = this.project.getScm().getUrl();
        }
        HashMap<String, Object> layerSpecs = new HashMap<String, Object>();
        HashMap<String, List<ConfigLayerSpec>> allLayerSpecs = new HashMap<String, List<ConfigLayerSpec>>();
        for (FeaturePackLayout layout : pl.getOrderedFeaturePacks()) {
            Path p = layout.getDir();
            FeaturePackDescription featurePackDescription = FeaturePackDescriber.describeFeaturePack((Path)p, (String)"UTF-8");
            for (ConfigLayerSpec descLayer : featurePackDescription.getLayers()) {
                ArrayList<ConfigLayerSpec> specs = (ArrayList<ConfigLayerSpec>)layerSpecs.get(descLayer.getId().getName());
                if (specs == null) {
                    specs = new ArrayList<ConfigLayerSpec>();
                    allLayerSpecs.put(descLayer.getId().getName(), specs);
                }
                specs.add(descLayer);
            }
        }
        if (this.addFeaturePacksDependenciesInMetadata) {
            layerSpecs = allLayerSpecs;
        } else {
            for (ConfigLayerSpec spec : desc.getLayers()) {
                ArrayList specs = new ArrayList();
                specs.add(spec);
                layerSpecs.put(spec.getName(), specs);
            }
        }
        Map<String, Stability> stabilities = MetadataGenerator.computeMinimalStability(allLayerSpecs, pl);
        ArrayList<Metadata.Layer> layers = new ArrayList<Metadata.Layer>();
        for (Map.Entry entry : layerSpecs.entrySet()) {
            ArrayList<ResourceOperation> ops = new ArrayList<ResourceOperation>();
            boolean propertiesAdded = false;
            TreeMap<String, AttributeConfiguration> config = new TreeMap<String, AttributeConfiguration>();
            for (ConfigLayerSpec spec : (List)entry.getValue()) {
                Stability stability;
                String layerName = spec.getName();
                List<Object> layerDependencies = Collections.emptyList();
                if (spec.hasLayerDeps()) {
                    layerDependencies = spec.getLayerDeps().stream().map(dep -> new Metadata.LayerDependency(dep.getName(), dep.isOptional())).toList();
                }
                TreeSet<String> packages = new TreeSet<String>();
                MetadataGenerator.generateModelUpdates(spec.getItems(), new ArrayList<ConfigItem>(), pl, ops, config, packages);
                ManagementModel m = new ManagementModel();
                m.populate(ops);
                ObjectNode managementModel = m.export();
                List<Object> properties = new ArrayList();
                if (!spec.getProperties().isEmpty() && !propertiesAdded) {
                    propertiesAdded = true;
                    properties = spec.getProperties().entrySet().stream().map(e -> new Metadata.Property((String)e.getKey(), (String)e.getValue())).toList();
                }
                List<Metadata.AttributeConfiguration> configurations = config.entrySet().stream().map(e -> {
                    String address = (String)e.getKey();
                    String attribute = ((AttributeConfiguration)e.getValue()).attribute;
                    Set<String> envVars = ((AttributeConfiguration)e.getValue()).envVariables;
                    Set<String> sysProps = ((AttributeConfiguration)e.getValue()).systemProperties;
                    return new Metadata.AttributeConfiguration(address, attribute, sysProps, envVars);
                }).toList();
                if (spec.hasPackageDeps()) {
                    List<String> localPackages = spec.getLocalPackageDeps().stream().map(PackageDependencySpec::getName).toList();
                    packages.addAll(localPackages);
                    for (String origin : spec.getPackageOrigins()) {
                        List<String> externalPackages = spec.getExternalPackageDeps(origin).stream().map(PackageDependencySpec::getName).toList();
                        packages.addAll(externalPackages);
                    }
                }
                if ((stability = stabilities.get(layerName)) == null) {
                    throw new Exception("No stability found for layer " + layerName);
                }
                layers.add(new Metadata.Layer(layerName, stability.toString(), layerDependencies, managementModel, properties, configurations, packages));
            }
        }
        Metadata metadata = new Metadata(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.project.getName(), this.project.getDescription(), licenses, this.project.getUrl(), scmUrl, this.copyright, layers);
        mapper.writerWithDefaultPrettyPrinter().writeValue(metadataTarget.toFile(), (Object)metadata);
    }

    private static Map<String, Stability> computeMinimalStability(Map<String, List<ConfigLayerSpec>> layerSpecs, ProvisioningLayout<FeaturePackLayout> pl) throws Exception {
        TreeMap<String, Stability> ret = new TreeMap<String, Stability>();
        for (Map.Entry<String, List<ConfigLayerSpec>> entry : layerSpecs.entrySet()) {
            Stability layerStability = MetadataGenerator.getMinimalStability(layerSpecs, entry.getKey(), entry.getValue(), pl, new HashSet<String>());
            ret.put(entry.getKey(), layerStability);
        }
        return ret;
    }

    private static Stability getMinimalStability(Map<String, List<ConfigLayerSpec>> layerSpecs, String layer, List<ConfigLayerSpec> specs, ProvisioningLayout<FeaturePackLayout> pl, Set<String> seen) throws Exception {
        if (seen.contains(layer)) {
            return null;
        }
        seen.add(layer);
        Stability currentStability = Stability.DEFAULT;
        for (ConfigLayerSpec spec : specs) {
            Stability featuresStability;
            if (spec.hasLayerDeps()) {
                for (GalleonLayerDependency dep : spec.getLayerDeps()) {
                    Stability stabilityDep;
                    List<ConfigLayerSpec> depSpecs = layerSpecs.get(dep.getName());
                    if (depSpecs == null || (stabilityDep = MetadataGenerator.getMinimalStability(layerSpecs, dep.getName(), depSpecs, pl, seen)) == null) continue;
                    if (currentStability == null) {
                        currentStability = stabilityDep;
                        continue;
                    }
                    if (currentStability.enables(stabilityDep)) continue;
                    currentStability = stabilityDep;
                }
            }
            if (!(featuresStability = MetadataGenerator.getFeaturesMinimalStability(spec.getItems(), new ArrayList<ConfigItem>(), pl)).enables(currentStability)) continue;
            currentStability = featuresStability;
        }
        return currentStability;
    }

    private static Stability getFeaturesMinimalStability(List<ConfigItem> items, List<ConfigItem> parents, ProvisioningLayout<FeaturePackLayout> pl) throws ProvisioningDescriptionException, ProvisioningException {
        Stability currentStability = Stability.DEFAULT;
        for (ConfigItem i : items) {
            if (i instanceof FeatureConfig) {
                boolean excluded;
                FeatureConfig fc = (FeatureConfig)i;
                FeatureSpec fp = MetadataGenerator.getFeatureSpec(pl, fc.getSpecId().getName());
                if (fp == null || (excluded = MetadataGenerator.isExcluded(parents, fp, fc))) continue;
                Stability fStability = fp.getStability();
                if (fStability == null) {
                    fStability = Stability.DEFAULT;
                }
                if (!currentStability.enables(fStability)) {
                    currentStability = fStability;
                }
                if (fc.getItems().isEmpty()) continue;
                parents.add((ConfigItem)fc);
                Stability itemsStability = MetadataGenerator.getFeaturesMinimalStability(fc.getItems(), parents, pl);
                parents.remove(parents.size() - 1);
                if (currentStability.enables(itemsStability)) continue;
                currentStability = itemsStability;
                continue;
            }
            if (!(i instanceof FeatureGroup)) continue;
            FeatureGroup fg = (FeatureGroup)i;
            FeatureGroup complete = MetadataGenerator.getFeatureGroup(pl, fg.getName());
            if (!complete.getItems().isEmpty()) {
                parents.add((ConfigItem)fg);
                Stability itemsStability = MetadataGenerator.getFeaturesMinimalStability(complete.getItems(), parents, pl);
                parents.remove(parents.size() - 1);
                if (!currentStability.enables(itemsStability)) {
                    currentStability = itemsStability;
                }
            }
            if (fg.getItems().isEmpty()) continue;
            parents.add((ConfigItem)fg);
            Stability itemsStability = MetadataGenerator.getFeaturesMinimalStability(fg.getItems(), parents, pl);
            parents.remove(parents.size() - 1);
            if (currentStability.enables(itemsStability)) continue;
            currentStability = itemsStability;
        }
        return currentStability;
    }

    private static String retrieveParamValue(List<ConfigItem> parents, String param) {
        for (int i = parents.size() - 1; i >= 0; --i) {
            FeatureConfig pc;
            String value;
            ConfigItem parent = parents.get(i);
            if (!(parent instanceof FeatureConfig) || (value = (pc = (FeatureConfig)parent).getParam(param)) == null) continue;
            return value;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static ResourceOperation buildModel(FeatureSpec spec, List<ConfigItem> parents, FeatureConfig config, Map<String, AttributeConfiguration> configuration) throws ProvisioningDescriptionException {
        FeatureAnnotation annot = spec.getAnnotation("jboss-op");
        if (annot == null) {
            return new ResourceOperation();
        }
        List addr = annot.getElementAsList("addr-params");
        ResourceOperation op = new ResourceOperation();
        HashSet<String> ids = new HashSet<String>();
        for (String string : addr) {
            void var11_18;
            String string2;
            FeatureParameterSpec fps = spec.getParam(string);
            ids.add(string);
            if (fps.hasDefaultValue() && !GLN_UNDEFINED.equals(fps.getDefaultValue())) {
                ResourceAddressItem resourceAddressItem = new ResourceAddressItem();
                resourceAddressItem.type = string;
                resourceAddressItem.name = fps.getDefaultValue();
                op.address.add(resourceAddressItem);
                continue;
            }
            String string3 = config.getParam(string);
            if (string3 == null && (string2 = MetadataGenerator.retrieveParamValue(parents, string)) == null) {
                if (GLN_UNDEFINED.equals(fps.getDefaultValue())) continue;
                throw new RuntimeException("Not correct parent for spec " + spec.getName() + "\nConfig is " + String.valueOf(config) + "\n Parents " + String.valueOf(parents));
            }
            ResourceAddressItem ai = new ResourceAddressItem();
            ai.type = string;
            ai.name = var11_18;
            if (!string.equals("subsystem")) {
                ai.isNamed = true;
            }
            op.address.add(ai);
        }
        if (annot.hasElement("complex-attribute")) {
            String attribute = annot.getElement("complex-attribute");
            StringBuilder stringBuilder = new StringBuilder("{");
            for (Map.Entry entry : config.getParams().entrySet()) {
                if (ids.contains(entry.getKey())) continue;
                stringBuilder.append(" " + (String)entry.getKey() + "=" + (String)entry.getValue() + ",");
                MetadataGenerator.addConfiguration((String)entry.getKey(), (String)entry.getValue(), op, configuration);
            }
            String clean = stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1) + " }";
            Attribute attribute2 = new Attribute();
            attribute2.name = attribute;
            attribute2.value = clean;
            op.params.put(attribute2.name, attribute2);
        } else {
            for (Map.Entry entry : config.getParams().entrySet()) {
                if (ids.contains(entry.getKey())) continue;
                Attribute p = new Attribute();
                p.name = (String)entry.getKey();
                p.value = (String)entry.getValue();
                op.params.put(p.name, p);
                MetadataGenerator.addConfiguration(p.name, p.value, op, configuration);
            }
        }
        return op;
    }

    private static void addConfiguration(String name, String value, ResourceOperation op, Map<String, AttributeConfiguration> configuration) {
        List<Set<String>> found = MetadataGenerator.parseValue(value);
        if (!found.isEmpty()) {
            StringBuilder k = new StringBuilder(SEPARATOR);
            for (ResourceAddressItem a : op.address) {
                k.append(a.type);
                k.append("=");
                k.append(a.isNamed ? "*" : a.name);
                k.append(SEPARATOR);
            }
            String key = k.substring(0, k.toString().length() - 1) + ATTRIBUTE_SEPARATOR + name;
            AttributeConfiguration s = configuration.get(key);
            if (s == null) {
                s = new AttributeConfiguration();
                s.attribute = name;
                configuration.put(key, s);
            }
            s.envVariables.addAll((Collection<String>)found.get(0));
            s.systemProperties.addAll((Collection<String>)found.get(1));
        }
    }

    private static List<Set<String>> parseValue(String value) {
        char[] chars = value.toCharArray();
        ArrayList<Set<String>> lst = new ArrayList<Set<String>>();
        TreeSet<String> envs = new TreeSet<String>();
        TreeSet<String> props = new TreeSet<String>();
        boolean expression = false;
        StringBuilder exp = null;
        boolean envVar = false;
        boolean expressionStart = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == ' ') continue;
            if (expressionStart) {
                exp = new StringBuilder();
                String radical = value.substring(i, i + 4);
                if (radical.equals("env.")) {
                    envVar = true;
                    i += 3;
                } else {
                    exp.append(c);
                }
                expressionStart = false;
                continue;
            }
            if (expression) {
                switch (c) {
                    case ':': 
                    case '}': {
                        expression = false;
                        if (envVar) {
                            envs.add(exp.toString());
                        } else {
                            props.add(exp.toString());
                        }
                        envVar = false;
                        break;
                    }
                    case ',': {
                        expressionStart = true;
                        if (envVar) {
                            envs.add(exp.toString());
                        } else {
                            props.add(exp.toString());
                        }
                        envVar = false;
                        break;
                    }
                    default: {
                        exp.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c != '$' || chars[i + 1] != '{') continue;
            expression = true;
            expressionStart = true;
            ++i;
        }
        if (!envs.isEmpty() || !props.isEmpty()) {
            lst.add(envs);
            lst.add(props);
        }
        return lst;
    }

    private static FeatureSpec getFeatureSpec(ProvisioningLayout<FeaturePackLayout> pl, String name) throws ProvisioningException {
        for (FeaturePackLayout layout : pl.getOrderedFeaturePacks()) {
            if (!layout.hasFeatureSpec(name)) continue;
            return layout.loadFeatureSpec(name);
        }
        return null;
    }

    private static FeatureGroup getFeatureGroup(ProvisioningLayout<FeaturePackLayout> pl, String name) throws ProvisioningException {
        for (FeaturePackLayout layout : pl.getOrderedFeaturePacks()) {
            if (!layout.hasFeatureGroup(name)) continue;
            return layout.loadFeatureGroupSpec(name);
        }
        return null;
    }

    private static void generateModelUpdates(List<ConfigItem> items, List<ConfigItem> parents, ProvisioningLayout<FeaturePackLayout> pl, List<ResourceOperation> ops, Map<String, AttributeConfiguration> config, Set<String> packages) throws ProvisioningDescriptionException, ProvisioningException {
        for (ConfigItem i : items) {
            if (i instanceof FeatureConfig) {
                boolean excluded;
                FeatureConfig fc = (FeatureConfig)i;
                FeatureSpec fp = MetadataGenerator.getFeatureSpec(pl, fc.getSpecId().getName());
                if (fp == null || (excluded = MetadataGenerator.isExcluded(parents, fp, fc))) continue;
                ResourceOperation op = MetadataGenerator.buildModel(fp, parents, fc, config);
                ops.add(op);
                if (!fc.getItems().isEmpty()) {
                    parents.add((ConfigItem)fc);
                    MetadataGenerator.generateModelUpdates(fc.getItems(), parents, pl, ops, config, packages);
                    parents.remove(parents.size() - 1);
                }
                if (!fp.hasLocalPackageDeps()) continue;
                for (PackageDependencySpec d : fp.getLocalPackageDeps()) {
                    packages.add(d.getName());
                }
                continue;
            }
            if (!(i instanceof FeatureGroup)) continue;
            FeatureGroup fg = (FeatureGroup)i;
            FeatureGroup complete = MetadataGenerator.getFeatureGroup(pl, fg.getName());
            if (!complete.getItems().isEmpty()) {
                parents.add((ConfigItem)fg);
                MetadataGenerator.generateModelUpdates(complete.getItems(), parents, pl, ops, config, packages);
                parents.remove(parents.size() - 1);
            }
            if (fg.getItems().isEmpty()) continue;
            parents.add((ConfigItem)fg);
            MetadataGenerator.generateModelUpdates(fg.getItems(), parents, pl, ops, config, packages);
            parents.remove(parents.size() - 1);
        }
    }

    private static boolean isExcluded(List<ConfigItem> parents, FeatureSpec fs, FeatureConfig fc) throws ProvisioningDescriptionException {
        for (int i = parents.size() - 1; i >= 0; --i) {
            ConfigItem p = parents.get(i);
            if (!(p instanceof FeatureGroup)) continue;
            FeatureGroup fg = (FeatureGroup)p;
            if (fg.hasExcludedSpecs() && fg.getExcludedSpecs().contains(fc.getSpecId())) {
                return true;
            }
            if (!fg.hasExcludedFeatures()) continue;
            for (FeatureId id : fg.getExcludedFeatures().keySet()) {
                if (!id.getSpec().getName().equals(fc.getSpecId().getName())) continue;
                HashMap<String, String> idParams = new HashMap<String, String>();
                for (String idParam : id.getParamNames()) {
                    if (fc.getParam(idParam) != null) {
                        idParams.put(idParam, fc.getParam(idParam));
                        continue;
                    }
                    String value = MetadataGenerator.retrieveParamValue(parents, idParam);
                    if (value == null) {
                        FeatureParameterSpec fparamSpec = fs.getParam(idParam);
                        value = fparamSpec.getDefaultValue();
                    }
                    idParams.put(idParam, value);
                }
                FeatureId fid = new FeatureId(fc.getSpecId().getName(), idParams);
                if (!fid.equals((Object)id)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ManagementModel {
        Resource root = new Resource(new ResourceAddressItem());

        ManagementModel() {
        }

        void populate(List<ResourceOperation> ops) {
            for (ResourceOperation op : ops) {
                Resource current = this.root;
                for (ResourceAddressItem item : op.address) {
                    Resource child;
                    Map<String, Resource> map = current.children.get(item.type);
                    if (map == null) {
                        map = new TreeMap<String, Resource>();
                        current.children.put(item.type, map);
                    }
                    if ((child = map.get(item.name)) == null) {
                        child = new Resource(item);
                        map.put(item.name, child);
                        current = child;
                        continue;
                    }
                    current = child;
                }
                current.attributes.putAll(op.params);
            }
        }

        ObjectNode export() {
            if (this.root.children.isEmpty() && this.root.attributes.isEmpty()) {
                ObjectMapper mapper = new ObjectMapper();
                return mapper.createObjectNode();
            }
            ObjectNode model = this.export("", this.root);
            return model;
        }

        ObjectNode export(String radical, Resource item) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode model = mapper.createObjectNode();
            String currentAddress = radical + (radical.endsWith(MetadataGenerator.SEPARATOR) ? "" : MetadataGenerator.SEPARATOR) + String.valueOf(item.address);
            if (!currentAddress.equals(MetadataGenerator.SEPARATOR)) {
                model.put("_address", currentAddress);
            }
            if (!item.attributes.isEmpty()) {
                ArrayNode attributesNode = mapper.createArrayNode();
                model.putIfAbsent("attributes", (JsonNode)attributesNode);
                for (Map.Entry<String, Attribute> entry : item.attributes.entrySet()) {
                    Attribute p = entry.getValue();
                    ObjectNode pNode = mapper.createObjectNode();
                    pNode.put("name", p.name);
                    pNode.put("value", p.value);
                    pNode.put("_address", currentAddress + MetadataGenerator.ATTRIBUTE_SEPARATOR + p.name);
                    attributesNode.add((JsonNode)pNode);
                }
            }
            if (!item.children.isEmpty()) {
                for (String k : item.children.keySet()) {
                    ObjectNode typeNode = mapper.createObjectNode();
                    model.putIfAbsent(k, (JsonNode)typeNode);
                    Map<String, Resource> childs = item.children.get(k);
                    for (Map.Entry<String, Resource> c : childs.entrySet()) {
                        typeNode.putIfAbsent(c.getKey(), (JsonNode)this.export(currentAddress, c.getValue()));
                    }
                }
            }
            return model;
        }
    }

    private static class ResourceOperation {
        List<ResourceAddressItem> address = new ArrayList<ResourceAddressItem>();
        Map<String, Attribute> params = new HashMap<String, Attribute>();

        private ResourceOperation() {
        }
    }

    private static class ResourceAddressItem {
        String type;
        String name;
        boolean isNamed;

        private ResourceAddressItem() {
        }

        public String toString() {
            if (this.type == null) {
                return "";
            }
            if (this.isNamed) {
                return this.type + "=*";
            }
            return this.type + "=" + this.name;
        }
    }

    private static class Attribute {
        String name;
        String value;

        private Attribute() {
        }
    }

    static class AttributeConfiguration
    implements Comparable<AttributeConfiguration> {
        String address;
        String attribute;
        Set<String> systemProperties = new TreeSet<String>();
        Set<String> envVariables = new TreeSet<String>();

        AttributeConfiguration() {
        }

        @Override
        public int compareTo(AttributeConfiguration t) {
            return this.address.compareTo(t.address);
        }
    }

    private static class Resource {
        ResourceAddressItem address;
        Map<String, Map<String, Resource>> children = new TreeMap<String, Map<String, Resource>>();
        Map<String, Attribute> attributes = new TreeMap<String, Attribute>();

        Resource(ResourceAddressItem address) {
            this.address = address;
        }
    }
}

