/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.util.CollectionUtils;

public class ExampleFpConfigs {
    private final String origin;
    private Map<ConfigId, ConfigModel> configs;

    public static Builder builder() {
        return ExampleFpConfigs.builder(null);
    }

    public static Builder builder(String origin) {
        return new Builder(origin);
    }

    private ExampleFpConfigs(Builder builder) {
        this.origin = builder.origin;
        this.configs = builder.configs;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Map<ConfigId, ConfigModel> getConfigs() {
        return this.configs;
    }

    public void addAll(ExampleFpConfigs exampleConfigs) {
        for (Map.Entry<ConfigId, ConfigModel> config : exampleConfigs.configs.entrySet()) {
            this.configs = CollectionUtils.put(this.configs, (Object)config.getKey(), (Object)config.getValue());
        }
    }

    public static class Builder {
        private final String origin;
        private Map<ConfigId, ConfigModel> configs = Collections.emptyMap();

        private Builder(String origin) {
            this.origin = origin;
        }

        public Builder addConfig(ConfigModel config) {
            this.configs = CollectionUtils.put(this.configs, (Object)config.getId(), (Object)config);
            return this;
        }

        public ExampleFpConfigs build() {
            return new ExampleFpConfigs(this);
        }
    }
}

