/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.galleon.plugin.config.CopyArtifact;
import org.wildfly.galleon.plugin.config.CopyPath;
import org.wildfly.galleon.plugin.config.DeletePath;
import org.wildfly.galleon.plugin.config.ExampleFpConfigs;
import org.wildfly.galleon.plugin.config.FileFilter;
import org.wildfly.galleon.plugin.config.FilePermission;
import org.wildfly.galleon.plugin.config.WildFlyPackageTasks;
import org.wildfly.galleon.plugin.config.XslTransform;

class WildFlyPackageTasksParser20
implements XMLElementReader<WildFlyPackageTasks.Builder> {
    WildFlyPackageTasksParser20() {
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int count = reader.getAttributeCount();
        if (count != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY_ARTIFACTS: {
                            this.parseCopyArtifacts(reader, builder);
                            continue block14;
                        }
                        case COPY_PATHS: {
                            this.parseCopyPaths(reader, builder);
                            continue block14;
                        }
                        case DELETE_PATHS: {
                            this.parseDeletePaths(reader, builder);
                            continue block14;
                        }
                        case EXAMPLE_CONFIGS: {
                            this.parseExampleConfigs(reader, builder);
                            continue block14;
                        }
                        case XSL: {
                            this.parseXsl(reader, builder);
                            continue block14;
                        }
                        case FILE_PERMISSIONS: {
                            this.parseFilePermissions(reader, builder);
                            continue block14;
                        }
                        case MKDIRS: {
                            this.parseMkdirs(reader, builder);
                            continue block14;
                        }
                        case LINE_ENDINGS: {
                            this.parseLineEndings(reader, builder);
                            continue block14;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseExampleConfigs(XMLExtendedStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        String origin = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case ORIGIN: {
                    origin = reader.getAttributeValue(i);
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        ExampleFpConfigs.Builder exampleConfigs = ExampleFpConfigs.builder(origin);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    builder.addExampleConfigs(exampleConfigs.build());
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CONFIG: {
                            this.parseExampleConfigs(reader, exampleConfigs);
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseExampleConfigs(XMLExtendedStreamReader reader, ExampleFpConfigs.Builder builder) throws XMLStreamException {
        ConfigModel.Builder configBuilder = ConfigModel.builder();
        ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)configBuilder);
        try {
            builder.addConfig(configBuilder.build());
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to instantiate config model", e);
        }
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return name;
    }

    private void parseMkdirs(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DIR: {
                            builder.addMkDirs(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseLineEndings(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case WINDOWS: {
                            this.parseLineEnding(reader, builder, true);
                            continue block8;
                        }
                        case UNIX: {
                            this.parseLineEnding(reader, builder, true);
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseLineEnding(XMLStreamReader reader, WildFlyPackageTasks.Builder builder, boolean windows) throws XMLStreamException {
        if (reader.getAttributeCount() != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            FileFilter.Builder filterBuilder = FileFilter.builder();
                            this.parseFilter(reader, filterBuilder);
                            if (windows) {
                                builder.addWindowsLineEndFilter(filterBuilder.build());
                                continue block7;
                            }
                            builder.addUnixLineEndFilter(filterBuilder.build());
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    public void parseFilter(XMLStreamReader reader, FileFilter.Builder builder) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN, Attribute.INCLUDE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    builder.setPatternString(reader.getAttributeValue(i));
                    continue block4;
                }
                case INCLUDE: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block4;
                    builder.setInclude();
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
    }

    private void parseCopyArtifacts(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY_ARTIFACT: {
                            CopyArtifact.Builder cpBuilder = CopyArtifact.builder();
                            this.parseCopyArtifact(reader, cpBuilder);
                            builder.addCopyArtifact(cpBuilder.build());
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseCopyArtifact(XMLStreamReader reader, CopyArtifact.Builder builder) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.ARTIFACT, Attribute.TO_LOCATION);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case ARTIFACT: {
                    builder.setArtifact(reader.getAttributeValue(i));
                    continue block12;
                }
                case TO_LOCATION: {
                    builder.setToLocation(reader.getAttributeValue(i));
                    continue block12;
                }
                case EXTRACT: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block12;
                    builder.setExtract();
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            FileFilter.Builder filterBuilder = FileFilter.builder();
                            this.parseFilter(reader, filterBuilder);
                            builder.addFilter(filterBuilder.build());
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseCopyPaths(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PATH: {
                            this.parseCopyPath(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseCopyPath(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        CopyPath.Builder cpBuilder = CopyPath.builder();
        boolean src = false;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case SRC: {
                    cpBuilder.setSrc(reader.getAttributeValue(i));
                    src = true;
                    continue block5;
                }
                case TARGET: {
                    cpBuilder.setTarget(reader.getAttributeValue(i));
                    continue block5;
                }
                case REPLACE_PROPERTIES: {
                    cpBuilder.setReplaceProperties(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block5;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!src) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.SRC));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        builder.addCopyPath(cpBuilder.build());
    }

    private void parseFilePermissions(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PERMISSION: {
                            builder.addFilePermissions(this.parsePermission(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    protected FilePermission parsePermission(XMLStreamReader reader) throws XMLStreamException {
        FilePermission.Builder permissionBuilder = FilePermission.builder();
        EnumSet<Attribute> required = EnumSet.of(Attribute.VALUE);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case VALUE: {
                    permissionBuilder.setValue(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return permissionBuilder.build();
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FILTER: {
                            FileFilter.Builder filterBuilder = FileFilter.builder();
                            this.parseFilter(reader, filterBuilder);
                            permissionBuilder.addFilter(filterBuilder.build());
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    public void parseDeletePaths(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DELETE: {
                            this.parseDeletePath(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseDeletePath(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String path = null;
        boolean recursive = false;
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block4;
                }
                case RECURSIVE: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block4;
                    recursive = true;
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (path == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PATH));
        }
        builder.addDeletePath(new DeletePath(path, recursive));
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
    }

    public void parseXsl(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case TRANSFORM: {
                            this.parseTransform(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseTransform(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        XslTransform.Builder tBuilder = XslTransform.builder();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case SRC: {
                    tBuilder.setSrc(reader.getAttributeValue(i));
                    continue block12;
                }
                case OUTPUT: {
                    tBuilder.setOutput(reader.getAttributeValue(i));
                    continue block12;
                }
                case STYLESHEET: {
                    tBuilder.setStylesheet(reader.getAttributeValue(i));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    XslTransform result = tBuilder.build();
                    if (result.getSrc() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.SRC));
                    }
                    if (result.getOutput() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.OUTPUT));
                    }
                    if (result.getStylesheet() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.STYLESHEET));
                    }
                    builder.addXslTransform(result);
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PARAMS: {
                            this.parseParams(reader, tBuilder);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseParams(XMLStreamReader reader, XslTransform.Builder result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PARAM: {
                            this.parseParam(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseParam(XMLStreamReader reader, XslTransform.Builder result) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        result.setParam(name, value);
    }

    static enum Attribute implements XmlNameProvider
    {
        ARTIFACT("artifact"),
        EXTRACT("extract"),
        GROUP("group"),
        INCLUDE("include"),
        MODEL("model"),
        NAME("name"),
        ORIGIN("origin"),
        OUTPUT("output"),
        PATH("path"),
        PATTERN("pattern"),
        RECURSIVE("recursive"),
        REPLACE_PROPERTIES("replace-props"),
        SRC("src"),
        STYLESHEET("stylesheet"),
        TARGET("target"),
        TO_LOCATION("to-location"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName(ARTIFACT.getLocalName()), ARTIFACT);
            attributesMap.put(new QName(EXTRACT.getLocalName()), EXTRACT);
            attributesMap.put(new QName(GROUP.getLocalName()), GROUP);
            attributesMap.put(new QName(INCLUDE.getLocalName()), INCLUDE);
            attributesMap.put(new QName(MODEL.getLocalName()), MODEL);
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributesMap.put(new QName(ORIGIN.getLocalName()), ORIGIN);
            attributesMap.put(new QName(OUTPUT.getLocalName()), OUTPUT);
            attributesMap.put(new QName(PATH.getLocalName()), PATH);
            attributesMap.put(new QName(PATTERN.getLocalName()), PATTERN);
            attributesMap.put(new QName(RECURSIVE.getLocalName()), RECURSIVE);
            attributesMap.put(new QName(REPLACE_PROPERTIES.getLocalName()), REPLACE_PROPERTIES);
            attributesMap.put(new QName(SRC.getLocalName()), SRC);
            attributesMap.put(new QName(STYLESHEET.getLocalName()), STYLESHEET);
            attributesMap.put(new QName(TARGET.getLocalName()), TARGET);
            attributesMap.put(new QName(TO_LOCATION.getLocalName()), TO_LOCATION);
            attributesMap.put(new QName(VALUE.getLocalName()), VALUE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        CONFIG("config"),
        COPY_ARTIFACT("copy-artifact"),
        COPY_ARTIFACTS("copy-artifacts"),
        COPY_PATHS("copy-paths"),
        DELETE("delete"),
        DELETE_PATHS("delete-paths"),
        DIR("dir"),
        EXAMPLE_CONFIGS("example-configs"),
        FILE_PERMISSIONS("file-permissions"),
        FILTER("filter"),
        LINE_ENDINGS("line-endings"),
        MKDIRS("mkdirs"),
        PARAM("param"),
        PARAMS("params"),
        PATH("path"),
        PERMISSION("permission"),
        TASKS("tasks"),
        TRANSFORM("transform"),
        UNIX("unix"),
        WINDOWS("windows"),
        XSL("xsl"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", COPY_ARTIFACT.getLocalName()), COPY_ARTIFACT);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", COPY_ARTIFACTS.getLocalName()), COPY_ARTIFACTS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", COPY_PATHS.getLocalName()), COPY_PATHS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", DELETE.getLocalName()), DELETE);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", DELETE_PATHS.getLocalName()), DELETE_PATHS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", DIR.getLocalName()), DIR);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", EXAMPLE_CONFIGS.getLocalName()), EXAMPLE_CONFIGS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", FILE_PERMISSIONS.getLocalName()), FILE_PERMISSIONS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", FILTER.getLocalName()), FILTER);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", LINE_ENDINGS.getLocalName()), LINE_ENDINGS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", MKDIRS.getLocalName()), MKDIRS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", PARAM.getLocalName()), PARAM);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", PARAMS.getLocalName()), PARAMS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", PATH.getLocalName()), PATH);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", PERMISSION.getLocalName()), PERMISSION);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", TASKS.getLocalName()), TASKS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", TRANSFORM.getLocalName()), TRANSFORM);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", UNIX.getLocalName()), UNIX);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", WINDOWS.getLocalName()), WINDOWS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:2.0", XSL.getLocalName()), XSL);
            elements = elementsMap;
        }
    }
}

