/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.diff.FileSystemMerge;
import org.jboss.galleon.diff.Strategy;
import org.jboss.galleon.plugin.UpgradePlugin;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.wildfly.galleon.plugin.WfDiffResult;
import org.wildfly.galleon.plugin.server.EmbeddedServerInvoker;

public class WfUpgradePlugin
implements UpgradePlugin {
    public void upgrade(ProvisioningRuntime runtime, Path customizedInstallation) throws ProvisioningException {
        try {
            FileSystemMerge fsMerge = FileSystemMerge.Factory.getInstance((Strategy)Strategy.OURS, (MessageWriter)runtime.getMessageWriter(), (Path)runtime.getInstallDir(), (Path)customizedInstallation);
            fsMerge.executeUpdate(runtime.getDiff());
            EmbeddedServerInvoker embeddedServer = new EmbeddedServerInvoker(runtime.getMessageWriter(), runtime.getInstallDir().toAbsolutePath(), null);
            for (Path script : ((WfDiffResult)runtime.getDiff()).getScripts()) {
                List<String> lines = Files.readAllLines(script);
                embeddedServer.execute(lines);
            }
        }
        catch (IOException ex) {
            runtime.getMessageWriter().error((Throwable)ex, (CharSequence)"Error upgrading");
            throw new ProvisioningException(ex.getMessage(), (Throwable)ex);
        }
    }
}

