/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.plugin.ProvisioningPluginWithOptions;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PropertyUtils;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.galleon.plugin.JandexIndexer;
import org.wildfly.galleon.plugin.MapPropertyResolver;
import org.wildfly.galleon.plugin.PropertyReplacer;
import org.wildfly.galleon.plugin.PropertyResolver;
import org.wildfly.galleon.plugin.config.CopyArtifact;
import org.wildfly.galleon.plugin.config.CopyPath;
import org.wildfly.galleon.plugin.config.DeletePath;
import org.wildfly.galleon.plugin.config.FilePermission;
import org.wildfly.galleon.plugin.config.WildFlyPackageTasks;
import org.wildfly.galleon.plugin.config.XslTransform;
import org.wildfly.galleon.plugin.server.CliScriptRunner;

public class WfInstallPlugin
extends ProvisioningPluginWithOptions
implements InstallPlugin {
    private static final String CONFIG_GEN_METHOD = "generate";
    private static final String CONFIG_GEN_PATH = "wildfly/wildfly-config-gen.jar";
    private static final String CONFIG_GEN_CLASS = "org.wildfly.galleon.plugin.config.generator.WfConfigGenerator";
    private ProvisioningRuntime runtime;
    private PropertyResolver versionResolver;
    private List<Path> installationClassPath = new ArrayList<Path>();
    private Map<ArtifactCoords.Gav, Properties> fpTasksProps = Collections.emptyMap();
    private Properties mergedTaskProps = new Properties();
    private PropertyResolver mergedTaskPropsResolver;
    private boolean thinServer;
    private Set<String> schemaGroups = Collections.emptySet();
    private final PluginOption mavenDistOption = PluginOption.builder((String)"jboss-maven-dist").hasNoValue().build();
    private List<DeletePath> pathsToDelete = Collections.emptyList();
    private DocumentBuilderFactory docBuilderFactory;
    private TransformerFactory xsltFactory;
    private Map<String, Transformer> xslTransformers = Collections.emptyMap();

    protected List<PluginOption> initPluginOptions() {
        return Collections.singletonList(this.mavenDistOption);
    }

    public void postInstall(ProvisioningRuntime runtime) throws ProvisioningException {
        MessageWriter messageWriter = runtime.getMessageWriter();
        messageWriter.verbose((CharSequence)"WildFly Galleon install plugin");
        this.runtime = runtime;
        this.thinServer = runtime.isOptionSet(this.mavenDistOption);
        HashMap<String, String> artifactVersions = new HashMap<String, String>();
        for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
            Throwable throwable;
            Path tasksPropsPath;
            Path wfRes = fp.getResource(new String[]{"wildfly"});
            if (!Files.exists(wfRes, new LinkOption[0])) continue;
            Path artifactProps = wfRes.resolve("artifact-versions.properties");
            if (Files.exists(artifactProps, new LinkOption[0])) {
                try (Stream<String> lines = Files.lines(artifactProps);){
                    Iterator iterator = lines.iterator();
                    while (iterator.hasNext()) {
                        String line = (String)iterator.next();
                        int i = line.indexOf(61);
                        if (i < 0) {
                            throw new ProvisioningException("Failed to locate '=' character in " + line);
                        }
                        artifactVersions.put(line.substring(0, i), line.substring(i + 1));
                    }
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.readFile((Path)artifactProps), (Throwable)e);
                }
            }
            if (Files.exists(tasksPropsPath = wfRes.resolve("wildfly-tasks.properties"), new LinkOption[0])) {
                Properties fpProps = new Properties();
                try {
                    throwable = null;
                    try (InputStream in = Files.newInputStream(tasksPropsPath, new OpenOption[0]);){
                        fpProps.load(in);
                    }
                    catch (Throwable i) {
                        throwable = i;
                        throw i;
                    }
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.readFile((Path)tasksPropsPath), (Throwable)e);
                }
                this.fpTasksProps = CollectionUtils.put(this.fpTasksProps, (Object)fp.getGav(), (Object)fpProps);
                this.mergedTaskProps.putAll((Map<?, ?>)fpProps);
            }
            if (!fp.containsPackage("docs.schema")) continue;
            Path schemaGroupsTxt = fp.getPackage("docs.schema").getResource(new String[]{"pm", "wildfly", "schema-groups.txt"});
            try {
                BufferedReader reader = Files.newBufferedReader(schemaGroupsTxt);
                throwable = null;
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        this.schemaGroups = CollectionUtils.add(this.schemaGroups, (Object)line);
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile((Path)schemaGroupsTxt), (Throwable)e);
            }
        }
        this.mergedTaskPropsResolver = new MapPropertyResolver(this.mergedTaskProps);
        this.versionResolver = new MapPropertyResolver(artifactVersions);
        for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
            this.processPackages(fp);
        }
        this.generateConfigs(runtime, messageWriter);
        for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
            Path finalizeCli = fp.getResource(new String[]{"wildfly", "scripts", "finalize.cli"});
            if (!Files.exists(finalizeCli, new LinkOption[0])) continue;
            CliScriptRunner.runCliScript(runtime.getStagedDir(), finalizeCli, messageWriter);
        }
        if (!this.pathsToDelete.isEmpty()) {
            this.deletePaths();
        }
    }

    private void generateConfigs(ProvisioningRuntime runtime, MessageWriter messageWriter) throws ProvisioningException {
        if (!runtime.hasConfigs()) {
            return;
        }
        Path configGenJar = runtime.getResource(new String[]{CONFIG_GEN_PATH});
        if (!Files.exists(configGenJar, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)configGenJar));
        }
        ArrayList<URL> cp = new ArrayList<URL>();
        try {
            cp.add(configGenJar.toUri().toURL());
            for (Path p : this.installationClassPath) {
                cp.add(p.toUri().toURL());
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to init classpath for " + runtime.getStagedDir(), (Throwable)e);
        }
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        URLClassLoader configGenCl = new URLClassLoader(cp.toArray(new URL[cp.size()]), originalCl);
        Thread.currentThread().setContextClassLoader(configGenCl);
        try {
            Class<?> configHandlerCls = configGenCl.loadClass(CONFIG_GEN_CLASS);
            Constructor<?> ctor = configHandlerCls.getConstructor(new Class[0]);
            Method m = configHandlerCls.getMethod(CONFIG_GEN_METHOD, ProvisioningRuntime.class);
            Object generator = ctor.newInstance(new Object[0]);
            m.invoke(generator, runtime);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProvisioningException) {
                throw (ProvisioningException)cause;
            }
            throw new ProvisioningException("Failed to invoke config generator org.wildfly.galleon.plugin.config.generator.WfConfigGenerator", cause);
        }
        catch (Throwable e) {
            throw new ProvisioningException("Failed to initialize config generator org.wildfly.galleon.plugin.config.generator.WfConfigGenerator", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
            try {
                configGenCl.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void processPackages(FeaturePackRuntime fp) throws ProvisioningException {
        for (PackageRuntime pkg : fp.getPackages()) {
            Path tasksXml;
            Path pmWfDir = pkg.getResource(new String[]{"pm", "wildfly"});
            if (!Files.exists(pmWfDir, new LinkOption[0])) continue;
            Path moduleDir = pmWfDir.resolve("module");
            if (Files.exists(moduleDir, new LinkOption[0])) {
                this.processModules(fp.getGav(), pkg.getName(), moduleDir);
            }
            if (!Files.exists(tasksXml = pmWfDir.resolve("tasks.xml"), new LinkOption[0])) continue;
            WildFlyPackageTasks pkgTasks = WildFlyPackageTasks.load(tasksXml);
            if (pkgTasks.hasCopyArtifacts()) {
                this.copyArtifacts(pkgTasks);
            }
            if (pkgTasks.hasCopyPaths()) {
                this.copyPaths(pkgTasks, pmWfDir);
            }
            if (pkgTasks.hasXslTransform()) {
                this.xslTransform(fp, pkgTasks, pmWfDir);
            }
            if (pkgTasks.hasMkDirs()) {
                WfInstallPlugin.mkdirs(pkgTasks, this.runtime.getStagedDir());
            }
            if (pkgTasks.hasFilePermissions() && !PropertyUtils.isWindows()) {
                WfInstallPlugin.processFeaturePackFilePermissions(pkgTasks, this.runtime.getStagedDir());
            }
            if (!pkgTasks.hasDeletePaths()) continue;
            if (this.pathsToDelete.isEmpty()) {
                this.pathsToDelete = new ArrayList<DeletePath>(pkgTasks.getDeletePaths());
                continue;
            }
            this.pathsToDelete.addAll(pkgTasks.getDeletePaths());
        }
    }

    private void xslTransform(FeaturePackRuntime fp, WildFlyPackageTasks pkgTasks, Path pmWfDir) throws ProvisioningException {
        if (this.docBuilderFactory == null) {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        for (XslTransform xslt : pkgTasks.getXslTransform()) {
            Path src = this.runtime.getStagedDir().resolve(xslt.getSrc());
            if (!Files.exists(src, new LinkOption[0])) {
                throw new ProvisioningException(Errors.pathDoesNotExist((Path)src));
            }
            Path output = this.runtime.getStagedDir().resolve(xslt.getOutput());
            if (Files.exists(output, new LinkOption[0])) {
                throw new ProvisioningException(Errors.pathAlreadyExists((Path)output));
            }
            try {
                InputStream srcInput = Files.newInputStream(src, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    OutputStream outStream = Files.newOutputStream(output, new OpenOption[0]);
                    Throwable throwable2 = null;
                    try {
                        Properties taskProps;
                        DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
                        org.w3c.dom.Document document = builder.parse(srcInput);
                        Transformer transformer = this.getXslTransformer(xslt.getStylesheet());
                        if (xslt.hasParams()) {
                            for (Map.Entry<String, String> entry : xslt.getParams().entrySet()) {
                                transformer.setParameter(entry.getKey(), entry.getValue());
                            }
                        }
                        if ((taskProps = this.fpTasksProps.get(fp.getGav())) != null) {
                            for (Map.Entry<Object, Object> prop : taskProps.entrySet()) {
                                transformer.setParameter(prop.getKey().toString(), prop.getValue());
                            }
                        }
                        DOMSource dOMSource = new DOMSource(document);
                        StreamResult result = new StreamResult(outStream);
                        transformer.transform(dOMSource, result);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                outStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        outStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (srcInput == null) continue;
                    if (throwable != null) {
                        try {
                            srcInput.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    srcInput.close();
                }
            }
            catch (ProvisioningException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProvisioningException("Failed to transform " + xslt.getSrc() + " with " + xslt.getStylesheet() + " to " + xslt.getOutput(), (Throwable)e);
            }
        }
    }

    private Transformer getXslTransformer(String stylesheet) throws ProvisioningException {
        Transformer transformer = this.xslTransformers.get(stylesheet);
        if (transformer != null) {
            return transformer;
        }
        Path p = this.runtime.getStagedDir().resolve(stylesheet);
        if (!Files.exists(p, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)p));
        }
        try (InputStream styleInput = Files.newInputStream(p, new OpenOption[0]);){
            StreamSource stylesource = new StreamSource(styleInput);
            if (this.xsltFactory == null) {
                this.xsltFactory = TransformerFactory.newInstance();
            }
            transformer = this.xsltFactory.newTransformer(stylesource);
        }
        catch (Exception e) {
            throw new ProvisioningException("Failed to initialize a transformer for " + stylesheet, (Throwable)e);
        }
        this.xslTransformers = CollectionUtils.put(this.xslTransformers, (Object)stylesheet, (Object)transformer);
        return transformer;
    }

    private void processModules(ArtifactCoords.Gav fp, String pkgName, final Path fpModuleDir) throws ProvisioningException {
        try {
            final Path installDir = this.runtime.getStagedDir();
            Files.walkFileTree(fpModuleDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    block2: {
                        Path targetDir = installDir.resolve(fpModuleDir.relativize(dir));
                        try {
                            Files.copy(dir, targetDir, new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException e) {
                            if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                            throw e;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().equals("module.xml")) {
                        WfInstallPlugin.this.processModuleTemplate(fpModuleDir, installDir, file);
                    } else {
                        Files.copy(file, installDir.resolve(fpModuleDir.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to process modules from package " + pkgName + " from feature-pack " + fp, (Throwable)e);
        }
    }

    private void processModuleTemplate(Path fpModuleDir, Path installDir, Path moduleTemplate) throws IOException {
        Element resourcesElement;
        String exprBody;
        int optionsIndex;
        String artifactName;
        String resolved;
        String versionExpr;
        Document document;
        Builder builder = new Builder(false);
        try (BufferedReader reader = Files.newBufferedReader(moduleTemplate, StandardCharsets.UTF_8);){
            document = builder.build(reader);
        }
        catch (ParsingException e) {
            throw new IOException("Failed to parse document", e);
        }
        Path targetPath = installDir.resolve(fpModuleDir.relativize(moduleTemplate));
        Element rootElement = document.getRootElement();
        if (!rootElement.getLocalName().equals("module")) {
            Files.copy(moduleTemplate, targetPath, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        Attribute versionAttribute = rootElement.getAttribute("version");
        if (versionAttribute != null && (versionExpr = versionAttribute.getValue()).startsWith("${") && versionExpr.endsWith("}") && (resolved = this.versionResolver.resolveProperty(artifactName = (optionsIndex = (exprBody = versionExpr.substring(2, versionExpr.length() - 1)).indexOf(63)) > 0 ? exprBody.substring(0, optionsIndex) : exprBody)) != null) {
            ArtifactCoords coords = WfInstallPlugin.fromJBossModules(resolved, "jar");
            versionAttribute.setValue(coords.getVersion());
        }
        if ((resourcesElement = rootElement.getFirstChildElement("resources", rootElement.getNamespaceURI())) != null) {
            Elements artifacts = resourcesElement.getChildElements("artifact", rootElement.getNamespaceURI());
            int artifactCount = artifacts.size();
            for (int i = 0; i < artifactCount; ++i) {
                Path moduleArtifact;
                Element element = artifacts.get(i);
                assert (element.getLocalName().equals("artifact"));
                Attribute attribute = element.getAttribute("name");
                String coordsStr = attribute.getValue();
                boolean jandex = false;
                if (coordsStr.startsWith("${") && coordsStr.endsWith("}")) {
                    int optionsIndex2 = (coordsStr = coordsStr.substring(2, coordsStr.length() - 1)).indexOf(63);
                    if (optionsIndex2 >= 0) {
                        jandex = coordsStr.indexOf("jandex", optionsIndex2) >= 0;
                        coordsStr = coordsStr.substring(0, optionsIndex2);
                    }
                    coordsStr = this.versionResolver.resolveProperty(coordsStr);
                }
                if (coordsStr == null) continue;
                ArtifactCoords coords = WfInstallPlugin.fromJBossModules(coordsStr, "jar");
                try {
                    moduleArtifact = this.runtime.resolveArtifact(coords);
                }
                catch (ProvisioningException e) {
                    throw new IOException(e);
                }
                if (this.thinServer) {
                    attribute.setValue(coordsStr);
                    this.addToInstallationCp(moduleArtifact);
                } else {
                    String finalFileName;
                    Path targetDir = installDir.resolve(fpModuleDir.relativize(moduleTemplate.getParent()));
                    String artifactFileName = moduleArtifact.getFileName().toString();
                    if (jandex) {
                        int lastDot = artifactFileName.lastIndexOf(".");
                        File target = new File(targetDir.toFile(), artifactFileName.substring(0, lastDot) + "-jandex" + artifactFileName.substring(lastDot));
                        JandexIndexer.createIndex(moduleArtifact.toFile(), new FileOutputStream(target), this.runtime.getMessageWriter());
                        finalFileName = target.getName();
                    } else {
                        finalFileName = artifactFileName;
                        Path targetModulePath = targetDir.resolve(artifactFileName);
                        Files.copy(moduleArtifact, targetModulePath, StandardCopyOption.REPLACE_EXISTING);
                        this.addToInstallationCp(targetModulePath);
                    }
                    element.setLocalName("resource-root");
                    attribute.setLocalName("path");
                    attribute.setValue(finalFileName);
                }
                if (!this.schemaGroups.contains(coords.getGroupId())) continue;
                this.extractSchemas(moduleArtifact);
            }
        }
        try (OutputStream outputStream = Files.newOutputStream(targetPath, new OpenOption[0]);){
            new Serializer(outputStream).write(document);
        }
        catch (Throwable t) {
            try {
                Files.deleteIfExists(targetPath);
            }
            catch (Throwable t2) {
                t2.addSuppressed(t);
                throw t2;
            }
            throw t;
        }
    }

    private void extractSchemas(Path moduleArtifact) throws IOException {
        Path targetSchemasDir = this.runtime.getStagedDir().resolve("docs").resolve("schema");
        Files.createDirectories(targetSchemasDir, new FileAttribute[0]);
        try (FileSystem jarFS = FileSystems.newFileSystem(moduleArtifact, null);){
            Path schemaSrc = jarFS.getPath("schema", new String[0]);
            if (Files.exists(schemaSrc, new LinkOption[0])) {
                ZipUtils.copyFromZip((Path)schemaSrc.toAbsolutePath(), (Path)targetSchemasDir);
            }
        }
    }

    private void copyArtifacts(WildFlyPackageTasks tasks) throws ProvisioningException {
        for (CopyArtifact copyArtifact : tasks.getCopyArtifacts()) {
            String gavString = this.versionResolver.resolveProperty(copyArtifact.getArtifact());
            if (gavString == null) {
                throw new ProvisioningException("Failed to resolve the version of " + copyArtifact.getArtifact());
            }
            try {
                ArtifactCoords coords = WfInstallPlugin.fromJBossModules(gavString, "jar");
                Path jarSrc = this.runtime.resolveArtifact(coords);
                String location = copyArtifact.getToLocation();
                if (!location.isEmpty() && location.charAt(location.length() - 1) == '/') {
                    location = location + jarSrc.getFileName();
                }
                Path jarTarget = this.runtime.getStagedDir().resolve(location);
                Files.createDirectories(jarTarget.getParent(), new FileAttribute[0]);
                if (copyArtifact.isExtract()) {
                    this.extractArtifact(jarSrc, jarTarget, copyArtifact);
                } else {
                    IoUtils.copy((Path)jarSrc, (Path)jarTarget);
                    this.addToInstallationCp(jarTarget);
                }
                this.runtime.getMessageWriter().verbose("    Copying artifact %s to %s", new Object[]{jarSrc, jarTarget});
                if (!this.schemaGroups.contains(coords.getGroupId())) continue;
                this.extractSchemas(jarSrc);
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to copy artifact " + gavString, (Throwable)e);
            }
        }
    }

    private void copyPaths(WildFlyPackageTasks tasks, Path pmWfDir) throws ProvisioningException {
        for (CopyPath copyPath : tasks.getCopyPaths()) {
            Path target;
            final Path src = pmWfDir.resolve(copyPath.getSrc());
            if (!Files.exists(src, new LinkOption[0])) {
                throw new ProvisioningException(Errors.pathDoesNotExist((Path)src));
            }
            Path path = target = copyPath.getTarget() == null ? this.runtime.getStagedDir() : this.runtime.getStagedDir().resolve(copyPath.getTarget());
            if (copyPath.isReplaceProperties()) {
                if (!Files.exists(target.getParent(), new LinkOption[0])) {
                    try {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new ProvisioningException(Errors.mkdirs((Path)target.getParent()), (Throwable)e);
                    }
                }
                try {
                    Files.walkFileTree(src, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            block2: {
                                Path targetDir = target.resolve(src.relativize(dir));
                                try {
                                    Files.copy(dir, targetDir, new CopyOption[0]);
                                }
                                catch (FileAlreadyExistsException e) {
                                    if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                                    throw e;
                                }
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            PropertyReplacer.copy(file, target.resolve(src.relativize(file)), WfInstallPlugin.this.mergedTaskPropsResolver);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    continue;
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.copyFile((Path)src, (Path)target), (Throwable)e);
                }
            }
            try {
                IoUtils.copy((Path)src, (Path)target);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.copyFile((Path)src, (Path)target));
            }
        }
    }

    private void deletePaths() throws ProvisioningException {
        for (DeletePath deletePath : this.pathsToDelete) {
            Path path = this.runtime.getStagedDir().resolve(deletePath.getPath());
            if (!Files.exists(path, new LinkOption[0])) continue;
            if (deletePath.isRecursive()) {
                IoUtils.recursiveDelete((Path)path);
                continue;
            }
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.deletePath((Path)path), (Throwable)e);
            }
        }
    }

    private void extractArtifact(Path artifact, final Path target, final CopyArtifact copy) throws IOException {
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        try (FileSystem zipFS = FileSystems.newFileSystem(artifact, null);){
            for (final Path zipRoot : zipFS.getRootDirectories()) {
                Files.walkFileTree(zipRoot, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        block5: {
                            String entry = dir.toString().substring(1);
                            if (entry.isEmpty()) {
                                return FileVisitResult.CONTINUE;
                            }
                            if (!entry.endsWith("/")) {
                                entry = entry + '/';
                            }
                            if (!copy.includeFile(entry)) {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            Path targetDir = target.resolve(zipRoot.relativize(dir).toString());
                            try {
                                Files.copy(dir, targetDir, new CopyOption[0]);
                            }
                            catch (FileAlreadyExistsException e) {
                                if (Files.isDirectory(targetDir, new LinkOption[0])) break block5;
                                throw e;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (copy.includeFile(file.toString().substring(1))) {
                            Path targetPath = target.resolve(zipRoot.relativize(file).toString());
                            Files.copy(file, targetPath, new CopyOption[0]);
                            if (targetPath.getFileName().endsWith(".jar")) {
                                WfInstallPlugin.this.addToInstallationCp(targetPath);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    private void addToInstallationCp(Path p) {
        this.installationClassPath.add(p);
    }

    private static void mkdirs(WildFlyPackageTasks tasks, Path installDir) throws ProvisioningException {
        for (String dirName : tasks.getMkDirs()) {
            Path dir = installDir.resolve(dirName);
            if (Files.exists(dir, new LinkOption[0])) continue;
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.mkdirs((Path)dir));
            }
        }
    }

    private static void processFeaturePackFilePermissions(WildFlyPackageTasks tasks, final Path installDir) throws ProvisioningException {
        final List<FilePermission> filePermissions = tasks.getFilePermissions();
        try {
            Files.walkFileTree(installDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String relative = installDir.relativize(dir).toString();
                    for (FilePermission perm : filePermissions) {
                        if (!perm.includeFile(relative)) continue;
                        Files.setPosixFilePermissions(dir, perm.getPermission());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String relative = installDir.relativize(file).toString();
                    for (FilePermission perm : filePermissions) {
                        if (!perm.includeFile(relative)) continue;
                        Files.setPosixFilePermissions(file, perm.getPermission());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to set file permissions", (Throwable)e);
        }
    }

    private static ArtifactCoords fromJBossModules(String str, String extension) {
        String[] parts = str.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Unexpected artifact coordinates format: " + str);
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = null;
        String classifier = null;
        if (parts.length > 2) {
            if (!parts[2].isEmpty()) {
                version = parts[2];
            }
            if (parts.length > 3 && !parts[3].isEmpty()) {
                classifier = parts[3];
                if (parts.length > 4) {
                    throw new IllegalArgumentException("Unexpected artifact coordinates format: " + str);
                }
            }
        }
        return new ArtifactCoords(groupId, artifactId, version, classifier, extension);
    }
}

