/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.util.CollectionUtils;

public class XslTransform {
    private final String src;
    private final String stylesheet;
    private final String output;
    private final Map<String, String> params;

    public static Builder builder() {
        return new Builder();
    }

    private XslTransform(Builder builder) {
        this.src = builder.src;
        this.stylesheet = builder.stylesheet;
        this.output = builder.output;
        this.params = CollectionUtils.unmodifiable((Map)builder.params);
    }

    public String getSrc() {
        return this.src;
    }

    public String getStylesheet() {
        return this.stylesheet;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean hasParams() {
        return !this.params.isEmpty();
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public static class Builder {
        private String stylesheet;
        private String src;
        private String output;
        private Map<String, String> params = Collections.emptyMap();

        private Builder() {
        }

        public Builder setSrc(String src) {
            this.src = src;
            return this;
        }

        public Builder setOutput(String output) {
            this.output = output;
            return this;
        }

        public Builder setStylesheet(String stylesheet) {
            this.stylesheet = stylesheet;
            return this;
        }

        public void setParam(String name, String value) {
            this.params = CollectionUtils.put(this.params, (Object)name, (Object)value);
        }

        public XslTransform build() {
            return new XslTransform(this);
        }
    }
}

