/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.XmlNameProvider;
import org.wildfly.galleon.plugin.config.XslTransform;

public class XslTransformModelParser20 {
    public static final String ELEMENT_LOCAL_NAME = "xsl";

    public List<XslTransform> parseCopyPaths(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<XslTransform> list = new ArrayList<XslTransform>();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return list;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case TRANSFORM: {
                            this.parseTransform(reader, list);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseTransform(XMLStreamReader reader, List<XslTransform> list) throws XMLStreamException {
        XslTransform.Builder builder = XslTransform.builder();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case SRC: {
                    builder.setSrc(reader.getAttributeValue(i));
                    continue block12;
                }
                case OUTPUT: {
                    builder.setOutput(reader.getAttributeValue(i));
                    continue block12;
                }
                case STYLESHEET: {
                    builder.setStylesheet(reader.getAttributeValue(i));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    XslTransform result = builder.build();
                    if (result.getSrc() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.SRC));
                    }
                    if (result.getOutput() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.OUTPUT));
                    }
                    if (result.getStylesheet() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.STYLESHEET));
                    }
                    list.add(result);
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PARAMS: {
                            this.parseParams(reader, builder);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseParams(XMLStreamReader reader, XslTransform.Builder result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PARAM: {
                            this.parseParam(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseParam(XMLStreamReader reader, XslTransform.Builder result) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        result.setParam(name, value);
    }

    static enum Attribute implements XmlNameProvider
    {
        NAME("name"),
        OUTPUT("output"),
        SRC("src"),
        STYLESHEET("stylesheet"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName.getLocalPart());
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<String, Attribute> attributesMap = new HashMap<String, Attribute>(5);
            attributesMap.put(NAME.getLocalName(), NAME);
            attributesMap.put(OUTPUT.getLocalName(), OUTPUT);
            attributesMap.put(SRC.getLocalName(), SRC);
            attributesMap.put(STYLESHEET.getLocalName(), STYLESHEET);
            attributesMap.put(VALUE.getLocalName(), VALUE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        PARAM("param"),
        PARAMS("params"),
        TRANSFORM("transform"),
        UNKNOWN(null);

        private static final Map<String, Element> elements;
        private final String name;

        static Element of(QName qName) {
            Element element = elements.get(qName.getLocalPart());
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            elements = new HashMap<String, Element>(3);
            elements.put(PARAM.getLocalName(), PARAM);
            elements.put(PARAMS.getLocalName(), PARAMS);
            elements.put(TRANSFORM.getLocalName(), TRANSFORM);
        }
    }
}

