/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.diff.FileSystemDiff;
import org.jboss.galleon.diff.ProvisioningDiffResult;
import org.jboss.galleon.plugin.DiffPlugin;
import org.jboss.galleon.plugin.ProvisioningPluginWithOptions;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.PathFilter;
import org.wildfly.galleon.plugin.Utils;
import org.wildfly.galleon.plugin.WfDiffResult;

public class WfDiffPlugin
extends ProvisioningPluginWithOptions
implements DiffPlugin {
    private static final String WF_DIFF_CONFIG_GENERATOR = "org.wildfly.galleon.plugin.config.generator.WfConfigsReader";
    private static final PathFilter FILTER_FP = PathFilter.Builder.instance().addDirectories(new String[]{"*" + File.separatorChar + "tmp", "*" + File.separatorChar + "log", "*_xml_history", "model_diff"}).addFiles(new String[]{"standalone.xml", "process-uuid", "logging.properties"}).build();
    private static final PathFilter FILTER = PathFilter.Builder.instance().addDirectories(new String[]{"*" + File.separatorChar + "tmp", "model_diff"}).addFiles(new String[]{"standalone.xml", "logging.properties"}).build();
    public static final ProvisioningOption HOST = ProvisioningOption.builder((String)"host").setDefaultValue("127.0.0.1").build();
    public static final ProvisioningOption PORT = ProvisioningOption.builder((String)"port").setDefaultValue("9990").build();
    public static final ProvisioningOption PROTOCOL = ProvisioningOption.builder((String)"protocol").setDefaultValue("remote+http").build();
    public static final ProvisioningOption USERNAME = ProvisioningOption.builder((String)"username").setDefaultValue("galleon").build();
    public static final ProvisioningOption PASSWORD = ProvisioningOption.builder((String)"password").setDefaultValue("galleon").build();
    public static final ProvisioningOption SERVER_CONFIG = ProvisioningOption.builder((String)"server-config").setDefaultValue("standalone.xml").build();
    private MavenRepoManager maven;

    protected List<ProvisioningOption> initPluginOptions() {
        return Arrays.asList(HOST, PORT, PROTOCOL, USERNAME, PASSWORD, SERVER_CONFIG);
    }

    public ProvisioningDiffResult computeDiff(ProvisioningRuntime runtime, Path customizedInstallation, Path target) throws ProvisioningException {
        List configs;
        MessageWriter log = runtime.getMessageWriter();
        log.verbose((CharSequence)"WildFly diff plug-in");
        FileSystemDiff diff = new FileSystemDiff(log, runtime.getStagedDir(), customizedInstallation);
        Path configGenJar = runtime.getResource(new String[]{"wildfly/wildfly-config-gen.jar"});
        if (!Files.exists(configGenJar, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)configGenJar));
        }
        this.maven = (MavenRepoManager)runtime.getArtifactResolver("repository.maven");
        Map<String, String> artifactVersions = this.getArtifactVersions(runtime);
        URL[] cp = new URL[4];
        try {
            cp[0] = configGenJar.toUri().toURL();
            MavenArtifact artifact = Utils.toArtifactCoords(artifactVersions, "org.jboss.modules:jboss-modules", false);
            this.maven.resolve(artifact);
            cp[1] = artifact.getPath().toUri().toURL();
            artifact = Utils.toArtifactCoords(artifactVersions, "org.wildfly.core:wildfly-cli::client", false);
            this.maven.resolve(artifact);
            cp[2] = artifact.getPath().toUri().toURL();
            artifact = Utils.toArtifactCoords(artifactVersions, "org.jboss.core:wildfly-launcher", false);
            this.maven.resolve(artifact);
            cp[3] = artifact.getPath().toUri().toURL();
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to init classpath for " + runtime.getStagedDir(), (Throwable)e);
        }
        if (log.isVerboseEnabled()) {
            log.verbose((CharSequence)"Config diff generator classpath:");
            for (int i = 0; i < cp.length; ++i) {
                log.verbose((CharSequence)(i + 1 + ". " + cp[i]));
            }
        }
        HashMap<FeaturePackLocation.FPID, ConfigId> includedConfigs = new HashMap<FeaturePackLocation.FPID, ConfigId>();
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        URLClassLoader configGenCl = new URLClassLoader(cp, originalCl);
        Thread.currentThread().setContextClassLoader(configGenCl);
        try {
            Class<?> wfDiffGenerator = configGenCl.loadClass(WF_DIFF_CONFIG_GENERATOR);
            Method exportDiff = wfDiffGenerator.getMethod("exportDiff", ProvisioningRuntime.class, Map.class, Path.class, Path.class);
            configs = (List)exportDiff.invoke(null, runtime, includedConfigs, customizedInstallation, target);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProvisioningException) {
                throw (ProvisioningException)cause;
            }
            throw new ProvisioningException("Failed to invoke config diff generator org.wildfly.galleon.plugin.config.generator.WfConfigsReader", cause);
        }
        catch (Throwable e) {
            throw new ProvisioningException("Failed to initialize config diff generator org.wildfly.galleon.plugin.config.generator.WfConfigsReader", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
            try {
                configGenCl.close();
            }
            catch (IOException iOException) {}
        }
        return new WfDiffResult(includedConfigs, configs, Collections.emptyList(), diff.diff(this.getFilter(runtime)));
    }

    private PathFilter getFilter(ProvisioningRuntime runtime) {
        return FILTER;
    }

    private Map<String, String> getArtifactVersions(ProvisioningRuntime runtime) throws ProvisioningException {
        HashMap<String, String> artifactVersions = new HashMap<String, String>();
        for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
            Path artifactProps;
            Path wfRes = fp.getResource(new String[]{"wildfly"});
            if (!Files.exists(wfRes, new LinkOption[0]) || !Files.exists(artifactProps = wfRes.resolve("artifact-versions.properties"), new LinkOption[0])) continue;
            Utils.readProperties(artifactProps, artifactVersions);
        }
        return artifactVersions;
    }
}

