/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.plugin.UserConfigDiffPlugin;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.state.ProvisionedState;
import org.wildfly.galleon.plugin.MapPropertyResolver;
import org.wildfly.galleon.plugin.PropertyResolver;

public class WfUserConfigDiffPlugin
implements UserConfigDiffPlugin {
    private static final String WF_DIFF_CONFIG_GENERATOR = "org.wildfly.galleon.plugin.config.generator.WfConfigsReader";

    public void userConfigDiff(ProvisionedState provisionedState, ProvisioningLayout<?> layout, Path currentState, MessageWriter log) throws ProvisioningException {
        log.verbose((CharSequence)"WildFly User Config Diff Plugin");
        Path configGenJar = layout.getResource(new String[]{"wildfly/wildfly-config-gen.jar"});
        if (!Files.exists(configGenJar, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)configGenJar));
        }
        PropertyResolver propertyResolver = this.getPropertyResolver(layout);
        URL[] cp = new URL[4];
        try {
            cp[0] = configGenJar.toUri().toURL();
            cp[1] = this.resolve(currentState, "jboss-modules.jar").toUri().toURL();
            RepositoryArtifactResolver maven = layout.getFactory().getUniverseResolver().getArtifactResolver("repository.maven");
            cp[2] = maven.resolve(this.toArtifactCoords("org.wildfly.core:wildfly-cli::client", propertyResolver)).toUri().toURL();
            cp[3] = maven.resolve(this.toArtifactCoords("org.wildfly.core:wildfly-launcher", propertyResolver)).toUri().toURL();
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to init classpath", (Throwable)e);
        }
        if (log.isVerboseEnabled()) {
            log.verbose((CharSequence)"Config diff generator classpath:");
            for (int i = 0; i < cp.length; ++i) {
                log.verbose((CharSequence)(i + 1 + ". " + cp[i]));
            }
        }
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        URLClassLoader configGenCl = new URLClassLoader(cp, originalCl);
        Thread.currentThread().setContextClassLoader(configGenCl);
        try {
            Class<?> wfDiffGenerator = configGenCl.loadClass(WF_DIFF_CONFIG_GENERATOR);
            Method exportDiff = wfDiffGenerator.getMethod("exportDiff", ProvisioningLayout.class, ProvisionedState.class, MessageWriter.class, Path.class);
            List configs = (List)exportDiff.invoke(null, layout, provisionedState, log, currentState);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProvisioningException) {
                throw (ProvisioningException)cause;
            }
            throw new ProvisioningException("Failed to invoke config diff generator org.wildfly.galleon.plugin.config.generator.WfConfigsReader", cause);
        }
        catch (Throwable e) {
            throw new ProvisioningException("Failed to initialize config diff generator org.wildfly.galleon.plugin.config.generator.WfConfigsReader", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
            try {
                configGenCl.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Path resolve(Path currentState, String ... path) throws ProvisioningException {
        Path p = currentState;
        for (String s : path) {
            p = p.resolve(s);
        }
        if (!Files.exists(p, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)p));
        }
        return p;
    }

    private PropertyResolver getPropertyResolver(ProvisioningLayout<?> layout) throws ProvisioningException {
        HashMap<String, String> artifactVersions = new HashMap<String, String>();
        for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
            Path artifactProps;
            Path wfRes = fp.getResource(new String[]{"wildfly"});
            if (!Files.exists(wfRes, new LinkOption[0]) || !Files.exists(artifactProps = wfRes.resolve("artifact-versions.properties"), new LinkOption[0])) continue;
            try {
                Stream<String> lines = Files.lines(artifactProps);
                Throwable throwable = null;
                try {
                    Iterator iterator = lines.iterator();
                    while (iterator.hasNext()) {
                        String line = (String)iterator.next();
                        int i = line.indexOf(61);
                        if (i < 0) {
                            throw new ProvisioningException("Failed to locate '=' character in " + line);
                        }
                        artifactVersions.put(line.substring(0, i), line.substring(i + 1));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lines == null) continue;
                    if (throwable != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    lines.close();
                }
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile((Path)artifactProps), (Throwable)e);
            }
        }
        return new MapPropertyResolver(artifactVersions);
    }

    private String toArtifactCoords(String str, PropertyResolver versionResolver) throws ProvisioningException {
        String[] parts = str.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Unexpected artifact coordinates format: " + str);
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = null;
        String classifier = "";
        String ext = "jar";
        if (parts.length > 2) {
            if (!parts[2].isEmpty()) {
                version = parts[2];
            }
            if (parts.length > 3) {
                classifier = parts[3];
                if (parts.length > 4 && !parts[4].isEmpty()) {
                    ext = parts[4];
                    if (parts.length > 5) {
                        throw new IllegalArgumentException("Unexpected artifact coordinates format: " + str);
                    }
                }
            }
        }
        if (version != null) {
            return groupId + ':' + artifactId + ':' + ext + ':' + classifier + ':' + version;
        }
        String resolvedStr = versionResolver.resolveProperty(groupId + ':' + artifactId);
        if (resolvedStr == null) {
            throw new ProvisioningException("Failed to resolve the version of " + str);
        }
        parts = resolvedStr.split(":");
        if (parts.length < 3) {
            throw new ProvisioningException("Failed to resolve version for artifact: " + resolvedStr);
        }
        return groupId + ':' + artifactId + ':' + ext + ':' + classifier + ':' + parts[2];
    }
}

