/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;

public class ForkedEmbeddedUtil {
    public static final String FORKED_EMBEDDED_ERROR_START = "Forked embedded process has failed with the following error:";
    private static int javaVersion = -1;
    private static String javaHome;
    private static String javaCmd;

    private static int getJavaVersion() {
        if (javaVersion < 0) {
            try {
                String vmVersionStr = System.getProperty("java.specification.version", null);
                Matcher matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(vmVersionStr);
                if (!matcher.find()) {
                    throw new RuntimeException("Unknown version of jvm " + vmVersionStr);
                }
                javaVersion = Integer.valueOf(matcher.group(1));
            }
            catch (Exception e) {
                javaVersion = 8;
            }
        }
        return javaVersion;
    }

    private static String getJavaHome() {
        return javaHome == null ? (javaHome = System.getProperty("java.home")) : javaHome;
    }

    private static String getJavaCmd() {
        return javaCmd == null ? (javaCmd = Paths.get(ForkedEmbeddedUtil.getJavaHome(), new String[0]).resolve("bin").resolve("java").toString()) : javaCmd;
    }

    public static void fork(ForkCallback callback, String ... args) throws ProvisioningException {
        Path props = ForkedEmbeddedUtil.storeSystemProps();
        try {
            ForkedEmbeddedUtil.fork(callback, props, args);
            callback.forkedEmbeddedDone(args);
        }
        finally {
            IoUtils.recursiveDelete((Path)props);
        }
    }

    public static void fork(ForkCallback callback, Path props, String ... args) throws ProvisioningException {
        Process p;
        StringBuilder cp = new StringBuilder();
        ForkedEmbeddedUtil.collectCpUrls(ForkedEmbeddedUtil.getJavaHome(), Thread.currentThread().getContextClassLoader(), cp);
        ArrayList<String> argsList = new ArrayList<String>(8 + args.length);
        argsList.add(ForkedEmbeddedUtil.getJavaCmd());
        argsList.add("-server");
        if (ForkedEmbeddedUtil.getJavaVersion() >= 11) {
            argsList.add("--add-modules=java.se");
        }
        argsList.add("-cp");
        argsList.add(cp.toString());
        argsList.add(ForkedEmbeddedUtil.class.getName());
        argsList.add(props.toString());
        argsList.add(callback.getClass().getName());
        for (String arg : args) {
            argsList.add(arg);
        }
        try {
            p = new ProcessBuilder(argsList).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to start a feature spec reading process", (Throwable)e);
        }
        ArrayList<String> trace = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
            int exitCode;
            String line = reader.readLine();
            while (line != null) {
                callback.forkedEmbeddedMessage(line);
                if (trace != null) {
                    trace.add(line);
                } else if (FORKED_EMBEDDED_ERROR_START.equals(line)) {
                    trace = new ArrayList<String>();
                }
                line = reader.readLine();
            }
            if (p.isAlive()) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if ((exitCode = p.exitValue()) != 0) {
                Throwable t = null;
                if (trace != null && (t = ForkedEmbeddedUtil.parseException(trace, 0)) == null) {
                    System.out.println(FORKED_EMBEDDED_ERROR_START);
                    for (String l : trace) {
                        System.out.println(l);
                    }
                }
                throw new ProvisioningException("Forked embedded process has failed", t);
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Forked embedded process has failed", (Throwable)e);
        }
    }

    public static Path storeSystemProps() throws ProvisioningException {
        Path props;
        try {
            props = Files.createTempFile("wfgp", "sysprops", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to create a tmp file", (Throwable)e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(props, new OpenOption[0]);){
            System.getProperties().store(writer, "");
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.writeFile((Path)props), (Throwable)e);
        }
        return props;
    }

    public static void main(String ... args) {
        try {
            Object o;
            Class<?> cls;
            if (args.length < 2) {
                throw new IllegalStateException("Expected at least two arguments but got " + Arrays.asList(args));
            }
            ForkedEmbeddedUtil.setSystemProps(args[0]);
            try {
                cls = Thread.currentThread().getContextClassLoader().loadClass(args[1]);
            }
            catch (ClassNotFoundException e) {
                throw new ProvisioningException("Failed to locate the target class " + args[1], (Throwable)e);
            }
            try {
                o = cls.newInstance();
            }
            catch (Exception e) {
                throw new ProvisioningException("Failed to instantiate " + args[1], (Throwable)e);
            }
            ((ForkCallback)o).forkedForEmbedded(args.length == 2 ? new String[]{} : Arrays.copyOfRange(args, 2, args.length));
        }
        catch (Throwable t) {
            System.err.println(FORKED_EMBEDDED_ERROR_START);
            StringBuilder buf = new StringBuilder();
            while (t != null) {
                buf.setLength(0);
                buf.append(t.getClass().getName());
                if (t.getMessage() != null) {
                    buf.append(": ").append(t.getMessage());
                }
                System.err.println(buf.toString());
                for (StackTraceElement e : t.getStackTrace()) {
                    buf.setLength(0);
                    buf.append("\tat ").append(e.toString());
                    System.err.println(buf.toString());
                }
                t = t.getCause();
            }
            System.exit(1);
        }
    }

    private static void setSystemProps(String path) throws ProvisioningException {
        Path props = Paths.get(path, new String[0]);
        if (!Files.exists(props, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)props));
        }
        Properties tmp = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(props);){
            tmp.load(reader);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile((Path)props));
        }
        for (Map.Entry<Object, Object> prop : tmp.entrySet()) {
            String current = System.getProperty(prop.getKey().toString());
            if (current != null) continue;
            System.setProperty(prop.getKey().toString(), prop.getValue().toString());
        }
    }

    private static void collectCpUrls(String javaHome, ClassLoader cl, StringBuilder buf) {
        ClassLoader parentCl = cl.getParent();
        if (parentCl != null) {
            ForkedEmbeddedUtil.collectCpUrls(javaHome, cl.getParent(), buf);
        }
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                String file = url.getFile();
                if (file.startsWith(javaHome)) continue;
                if (buf.length() > 0) {
                    buf.append(File.pathSeparatorChar);
                }
                buf.append(file);
            }
        }
    }

    private static Throwable parseException(List<String> trace, int offset) {
        Throwable t;
        String classAndMsg = trace.get(offset);
        String className = null;
        List ctorArgTypes = Collections.emptyList();
        List ctorArgs = Collections.emptyList();
        int i = classAndMsg.indexOf(58);
        if (i < 0) {
            className = classAndMsg;
        } else {
            className = classAndMsg.substring(0, i);
            ctorArgTypes = CollectionUtils.add(ctorArgTypes, String.class);
            ctorArgs = CollectionUtils.add(ctorArgs, (Object)classAndMsg.substring(i + 1).trim());
        }
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(trace.size() - offset - 1);
        for (i = offset + 1; i < trace.size(); ++i) {
            StackTraceElement ste = ForkedEmbeddedUtil.stackTraceElementFromString(trace.get(i));
            if (ste == null) {
                Throwable cause = ForkedEmbeddedUtil.parseException(trace, i);
                if (cause == null) {
                    return null;
                }
                ctorArgTypes = CollectionUtils.add((List)ctorArgTypes, Throwable.class);
                ctorArgs = CollectionUtils.add((List)ctorArgs, (Object)cause);
                break;
            }
            stack.add(ste);
        }
        try {
            Class<?> excClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            t = ctorArgTypes.isEmpty() ? (Throwable)excClass.newInstance() : (Throwable)excClass.getConstructor(ctorArgTypes.toArray(new Class[ctorArgTypes.size()])).newInstance(ctorArgs.toArray(new Object[ctorArgs.size()]));
        }
        catch (Throwable e) {
            return null;
        }
        t.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
        return t;
    }

    private static StackTraceElement stackTraceElementFromString(String line) {
        int i = line.length() - 1;
        if (i < 0) {
            return null;
        }
        if (line.charAt(i) != ')') {
            return null;
        }
        int pos = line.lastIndexOf(58);
        if (pos < 0) {
            return null;
        }
        int lineNumber = Integer.parseInt(line.substring(pos + 1, i));
        i = pos;
        pos = line.lastIndexOf(40);
        if (pos < 0) {
            return null;
        }
        String file = line.substring(pos + 1, i);
        i = pos;
        while (--pos >= 0 && line.charAt(pos) != '.') {
        }
        if (pos < 0) {
            return null;
        }
        String method = line.substring(pos + 1, i);
        i = pos;
        while (--pos >= 0 && !Character.isWhitespace(line.charAt(pos))) {
        }
        if (pos < 0) {
            return null;
        }
        return new StackTraceElement(line.substring(pos + 1, i), method, file, lineNumber);
    }

    public static interface ForkCallback {
        public void forkedForEmbedded(String ... var1) throws ProvisioningException;

        default public void forkedEmbeddedMessage(String msg) {
        }

        default public void forkedEmbeddedDone(String ... args) throws ProvisioningException {
        }
    }
}

