/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.util.StringUtils;
import org.wildfly.galleon.plugin.config.CopyArtifact;

public class Utils {
    public static void readProperties(Path propsFile, Map<String, String> propsMap) throws ProvisioningException {
        try (BufferedReader reader = Files.newBufferedReader(propsFile);){
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).charAt(0) != '#' && !line.isEmpty()) {
                    int i = line.indexOf(61);
                    if (i < 0) {
                        throw new ProvisioningException("Failed to parse property " + line + " from " + propsFile);
                    }
                    propsMap.put(line.substring(0, i), line.substring(i + 1));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile((Path)propsFile), (Throwable)e);
        }
    }

    public static Map<String, String> readProperties(Path propsFile) throws ProvisioningException {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        Utils.readProperties(propsFile, propsMap);
        return propsMap;
    }

    public static MavenArtifact toArtifactCoords(Map<String, String> versionProps, String str, boolean optional) throws ProvisioningException {
        String[] parts = str.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Unexpected artifact coordinates format: " + str);
        }
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(parts[0]);
        artifact.setArtifactId(parts[1]);
        artifact.setExtension("jar");
        if (parts.length > 2) {
            if (!parts[2].isEmpty()) {
                artifact.setVersion(parts[2]);
            }
            if (parts.length > 3) {
                artifact.setClassifier(parts[3]);
                if (parts.length > 4 && !parts[4].isEmpty()) {
                    artifact.setExtension(parts[4]);
                    if (parts.length > 5) {
                        throw new IllegalArgumentException("Unexpected artifact coordinates format: " + str);
                    }
                }
            }
        }
        if (!artifact.hasVersion()) {
            String resolvedStr = versionProps.get(artifact.getGroupId() + ':' + artifact.getArtifactId());
            if (resolvedStr == null) {
                if (optional) {
                    return null;
                }
                throw new ProvisioningException("Failed to resolve the version of " + artifact.getGroupId() + ':' + artifact.getArtifactId());
            }
            parts = resolvedStr.split(":");
            if (parts.length < 3) {
                throw new ProvisioningException("Failed to resolve the version for artifact: " + resolvedStr);
            }
            artifact.setVersion(parts[2]);
        }
        return artifact;
    }

    public static List<Path> collectLayersConf(ProvisioningLayout<?> layout) throws ProvisioningException {
        List layersConfs = Collections.emptyList();
        for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
            Path p = LayoutUtils.getPackageContentDir((Path)fp.getDir(), (String)"layers.conf");
            if (!Files.exists(p, new LinkOption[0])) continue;
            if (!Files.exists(p = p.resolve("modules").resolve("layers.conf"), new LinkOption[0])) {
                throw new ProvisioningException("Feature-pack " + fp.getFPID() + " package " + "layers.conf" + " is expected to contain " + "modules" + "/" + "layers.conf" + " but it does not");
            }
            layersConfs = CollectionUtils.add(layersConfs, (Object)p);
        }
        return layersConfs;
    }

    public static void mergeLayersConfs(List<Path> layersConfs, Path distHome) throws ProvisioningException {
        if (layersConfs.isEmpty()) {
            return;
        }
        if (layersConfs.size() == 1) {
            try {
                IoUtils.copy((Path)layersConfs.get(0), (Path)distHome.resolve("modules").resolve("layers.conf"));
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to install layes.conf to " + distHome, (Throwable)e);
            }
            return;
        }
        Properties props = new Properties();
        LinkedHashSet<String> layers = new LinkedHashSet<String>(layersConfs.size());
        for (Path p : layersConfs) {
            String[] layerNames;
            try (BufferedReader reader = Files.newBufferedReader(p);){
                props.load(reader);
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to generate layer.conf", (Throwable)e);
            }
            String layersProp = props.getProperty("layers");
            if (layersProp == null || (layersProp = layersProp.trim()).length() == 0) continue;
            for (String layerName : layerNames = layersProp.split(",")) {
                layers.add(layerName);
            }
        }
        if (!layers.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            StringUtils.append((StringBuilder)buf, layers);
            props.setProperty("layers", buf.toString());
        }
        try (BufferedWriter writer = Files.newBufferedWriter(distHome.resolve("modules").resolve("layers.conf"), new OpenOption[0]);){
            props.store(writer, "Generated by WildFly Galleon provisioning plugin");
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to persist generated layers.conf", (Throwable)e);
        }
    }

    public static void extractArtifact(Path artifact, final Path target, final CopyArtifact copy) throws IOException {
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        try (FileSystem zipFS = FileSystems.newFileSystem(artifact, null);){
            for (final Path zipRoot : zipFS.getRootDirectories()) {
                Files.walkFileTree(zipRoot, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        block5: {
                            String entry = dir.toString().substring(1);
                            if (entry.isEmpty()) {
                                return FileVisitResult.CONTINUE;
                            }
                            if (!entry.endsWith("/")) {
                                entry = entry + '/';
                            }
                            if (!copy.includeFile(entry)) {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            Path targetDir = target.resolve(zipRoot.relativize(dir).toString());
                            try {
                                Files.copy(dir, targetDir, new CopyOption[0]);
                            }
                            catch (FileAlreadyExistsException e) {
                                if (Files.isDirectory(targetDir, new LinkOption[0])) break block5;
                                throw e;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (copy.includeFile(file.toString().substring(1))) {
                            Path targetPath = target.resolve(zipRoot.relativize(file).toString());
                            Files.copy(file, targetPath, new CopyOption[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }
}

