/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.transformer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.transformer.Transformer;
import org.eclipse.transformer.action.Changes;
import org.wildfly.galleon.plugin.transformer.JakartaTransformer;
import org.wildfly.galleon.plugin.transformer.JarUtils;
import org.wildfly.galleon.plugin.transformer.TransformedArtifact;

public class EclipseTransformer {
    public static final String DEFAULT_RENAMES_REFERENCE = "jakarta-renames.properties";
    public static final String DEFAULT_MASTER_TXT_REFERENCE = "jakarta-txt-master.properties";
    public static final String DEFAULT_PER_CLASS_DIRECT_REFERENCE = "jakarta-per-class.properties";
    public static final String DEFAULT_DIRECT_REFERENCE = "jakarta-direct.properties";

    private static Map<Transformer.AppOption, String> getOptionDefaults() {
        HashMap<Transformer.AppOption, String> optionDefaults = new HashMap<Transformer.AppOption, String>();
        optionDefaults.put(Transformer.AppOption.RULES_RENAMES, DEFAULT_RENAMES_REFERENCE);
        optionDefaults.put(Transformer.AppOption.RULES_MASTER_TEXT, DEFAULT_MASTER_TXT_REFERENCE);
        optionDefaults.put(Transformer.AppOption.RULES_PER_CLASS_CONSTANT, DEFAULT_PER_CLASS_DIRECT_REFERENCE);
        optionDefaults.put(Transformer.AppOption.RULES_DIRECT, DEFAULT_DIRECT_REFERENCE);
        return optionDefaults;
    }

    static TransformedArtifact transform(Path src, Path target, boolean verbose, JakartaTransformer.LogHandler log) throws IOException {
        boolean transformed = false;
        boolean signed = false;
        boolean unsigned = false;
        try {
            if (!verbose) {
                System.setProperty("org.slf4j.simpleLogger.log.Transformer", "error");
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(src.toString());
            args.add(target.toString());
            if (verbose) {
                args.add("-v");
            } else {
                args.add("--quiet");
            }
            String[] array = new String[args.size()];
            transformed = EclipseTransformer.transform(args.toArray(array), true);
            if (src.getFileName().toString().endsWith(".jar")) {
                signed = JarUtils.isSignedJar(src);
            }
            if (transformed) {
                log.print("EE9: transformed %s", target.getFileName().toString());
            }
            if (signed && transformed) {
                log.print("WARNING: EE9: unsigning transformed %s ", target.getFileName().toString());
                JarUtils.unsign(target);
                unsigned = true;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return new TransformedArtifact(src, target, transformed, signed, unsigned);
    }

    static boolean transform(String[] args, boolean silent) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Transformer jTrans = null;
        jTrans = silent ? new Transformer(new PrintStream(out), new PrintStream(out)) : new Transformer(System.out, System.err);
        jTrans.setOptionDefaults(EclipseTransformer.class, EclipseTransformer.getOptionDefaults());
        jTrans.setArgs(args);
        int rc = jTrans.run();
        if (rc != 0) {
            throw new Exception("Eror occured during transformation. Error code " + rc);
        }
        Changes changes = jTrans.getLastActiveChanges();
        if (changes != null) {
            return changes.hasChanges();
        }
        return false;
    }
}

