/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.plugin.CliPlugin;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.spec.PackageSpec;

public class WfCliPlugin
implements CliPlugin {
    private static final String MODULE_PATH = "pm/wildfly/module";
    private static final String MODULE_XML = "module.xml";
    private static final String VERSIONS_PATH = "wildfly/artifact-versions.properties";

    public CliPlugin.CustomPackageContent handlePackageContent(PackageRuntime pkg) throws ProvisioningException, ProvisioningDescriptionException, IOException {
        Path modulePath = pkg.getContentDir().getParent().resolve(MODULE_PATH);
        if (Files.exists(modulePath, new LinkOption[0])) {
            String moduleVersion;
            Path props = pkg.getFeaturePackRuntime().getResource(new String[]{VERSIONS_PATH});
            Map<String, String> variables = WfCliPlugin.getVariables(props);
            ArrayList<String> artifacts = new ArrayList<String>();
            try {
                moduleVersion = WfCliPlugin.parseModuleDescriptor(variables, pkg.getContentDir(), pkg.getSpec(), artifacts);
            }
            catch (ParsingException ex) {
                throw new ProvisioningException((Throwable)ex);
            }
            return new ModuleContent(WfCliPlugin.buildInfo(artifacts, moduleVersion));
        }
        return null;
    }

    private static String parseModuleDescriptor(Map<String, String> variables, Path contentDir, PackageSpec spec, List<String> artifacts) throws IOException, ProvisioningException, ParsingException {
        Element resourcesElement;
        String exprBody;
        int optionsIndex;
        String artifactName;
        String vers;
        String versionExpr;
        Document document;
        Path modulePath = contentDir.getParent().resolve(MODULE_PATH);
        final ArrayList moduleHolder = new ArrayList();
        String moduleVersion = null;
        Files.walkFileTree(modulePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
                if (file.getFileName().toString().equals(WfCliPlugin.MODULE_XML)) {
                    moduleHolder.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        if (moduleHolder.isEmpty()) {
            throw new ProvisioningException("No module descriptor for " + spec.getName());
        }
        Path p = (Path)moduleHolder.get(0);
        Builder builder = new Builder(false);
        try (BufferedReader reader = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
            document = builder.build(reader);
        }
        Element rootElement = document.getRootElement();
        Attribute versionAttribute = rootElement.getAttribute("version");
        if (versionAttribute != null && (versionExpr = versionAttribute.getValue()).startsWith("${") && versionExpr.endsWith("}") && (vers = variables.get(artifactName = (optionsIndex = (exprBody = versionExpr.substring(2, versionExpr.length() - 1)).indexOf(63)) > 0 ? exprBody.substring(0, optionsIndex) : exprBody)) != null) {
            int i = vers.lastIndexOf(":");
            if (i > 0) {
                vers = vers.substring(i + 1);
            }
            moduleVersion = vers;
        }
        if ((resourcesElement = rootElement.getFirstChildElement("resources", rootElement.getNamespaceURI())) != null) {
            Elements artfs = resourcesElement.getChildElements("artifact", rootElement.getNamespaceURI());
            int artifactCount = artfs.size();
            for (int i = 0; i < artifactCount; ++i) {
                Element element = artfs.get(i);
                assert (element.getLocalName().equals("artifact"));
                Attribute attribute = element.getAttribute("name");
                String nameExpr = attribute.getValue();
                if (!nameExpr.startsWith("${") || !nameExpr.endsWith("}")) continue;
                String exprBody2 = nameExpr.substring(2, nameExpr.length() - 1);
                int optionsIndex2 = exprBody2.indexOf(63);
                String artifactName2 = optionsIndex2 >= 0 ? exprBody2.substring(0, optionsIndex2) : exprBody2;
                String resolved = variables.get(artifactName2);
                artifacts.add(resolved);
            }
        }
        return moduleVersion;
    }

    private static String buildInfo(List<String> artifacts, String moduleVersion) {
        StringBuilder builder = new StringBuilder();
        builder.append("Package is a JBOSS module.\n");
        builder.append("Module version : " + (moduleVersion == null ? "none" : moduleVersion) + "\n");
        builder.append("Module artifacts gav\n");
        if (artifacts.isEmpty()) {
            builder.append("NONE\n");
        } else {
            for (String art : artifacts) {
                builder.append(art + "\n");
            }
        }
        return builder.toString();
    }

    private static Map<String, String> getVariables(Path props) throws ProvisioningException, IOException {
        HashMap<String, String> variables = new HashMap<String, String>();
        if (Files.exists(props, new LinkOption[0])) {
            try (Stream<String> lines = Files.lines(props);){
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    String line = (String)iterator.next();
                    int i = line.indexOf(61);
                    if (i < 0) {
                        throw new ProvisioningException("Failed to locate '=' character in " + line);
                    }
                    variables.put(line.substring(0, i), line.substring(i + 1));
                }
            }
        }
        return variables;
    }

    private class ModuleContent
    implements CliPlugin.CustomPackageContent {
        private final String content;

        private ModuleContent(String content) throws IOException, ProvisioningException {
            this.content = content;
        }

        public String getInfo() {
            return this.content;
        }
    }
}

