/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.wildfly.galleon.plugin.AbstractEE9ArtifactInstaller;
import org.wildfly.galleon.plugin.WfInstallPlugin;
import org.wildfly.galleon.plugin.transformer.JakartaTransformer;

class EE9ArtifactTransformerInstaller
extends AbstractEE9ArtifactInstaller {
    EE9ArtifactTransformerInstaller(WfInstallPlugin.ArtifactResolver resolver, Path generatedMavenRepo, Set<String> transformExcluded, WfInstallPlugin plugin, String jakartaTransformSuffix, Path jakartaTransformConfigsDir, JakartaTransformer.LogHandler logHandler, boolean jakartaTransformVerbose, ProvisioningRuntime runtime) {
        super(resolver, generatedMavenRepo, transformExcluded, plugin, jakartaTransformSuffix, jakartaTransformConfigsDir, logHandler, jakartaTransformVerbose, runtime);
    }

    @Override
    String installArtifactFat(MavenArtifact artifact, Path targetDir, Path localCache) throws IOException, MavenUniverseException, ProvisioningException {
        String artifactFileName = artifact.getArtifactFileName();
        Path transformedFile = null;
        if (this.isOverriddenArtifact(artifact)) {
            transformedFile = this.setupOverriddenArtifact(artifact);
        }
        String version = artifact.getVersion();
        if (!this.isExcludedFromTransformation(artifact)) {
            artifactFileName = this.getTransformedArtifactFileName(artifact.getVersion(), artifactFileName);
            if (transformedFile == null) {
                Path transformedPath = targetDir.resolve(artifactFileName);
                this.transform(artifact, transformedPath);
            } else {
                Files.copy(transformedFile, targetDir.resolve(artifactFileName), StandardCopyOption.REPLACE_EXISTING);
            }
            version = this.getTransformedVersion(version);
        } else {
            Files.copy(artifact.getPath(), targetDir.resolve(artifactFileName), StandardCopyOption.REPLACE_EXISTING);
        }
        if (localCache != null) {
            Path pomFile = EE9ArtifactTransformerInstaller.getPomArtifactPath(artifact, this.getArtifactResolver());
            Path versionPath = EE9ArtifactTransformerInstaller.getLocalRepoPath(artifact, version, localCache);
            Files.copy(pomFile, versionPath.resolve(pomFile.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(targetDir.resolve(artifactFileName), versionPath.resolve(artifactFileName), StandardCopyOption.REPLACE_EXISTING);
        }
        return artifactFileName;
    }

    @Override
    String installArtifactThin(MavenArtifact artifact) throws IOException, MavenUniverseException, ProvisioningException {
        Path transformedFile = null;
        if (this.isOverriddenArtifact(artifact)) {
            transformedFile = this.setupOverriddenArtifact(artifact);
        }
        String version = artifact.getVersion();
        Path versionPath = EE9ArtifactTransformerInstaller.getLocalRepoPath(artifact, version, this.getGeneratedMavenRepo());
        if (!this.isExcludedFromTransformation(artifact)) {
            version = this.getTransformedVersion(artifact.getVersion());
            versionPath = EE9ArtifactTransformerInstaller.getLocalRepoPath(artifact, version, this.getGeneratedMavenRepo());
            if (transformedFile == null) {
                String name = this.getTransformedArtifactFileName(artifact.getVersion(), artifact.getPath().getFileName().toString());
                Path transformedTarget = versionPath.resolve(name);
                if (!Files.exists(transformedTarget, new LinkOption[0])) {
                    this.transform(artifact, transformedTarget);
                }
            } else {
                Files.copy(transformedFile, versionPath.resolve(transformedFile.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        } else {
            Files.copy(artifact.getPath(), versionPath.resolve(artifact.getArtifactFileName()), StandardCopyOption.REPLACE_EXISTING);
        }
        Path pomFile = EE9ArtifactTransformerInstaller.getPomArtifactPath(artifact, this.getArtifactResolver());
        Files.copy(pomFile, versionPath.resolve(pomFile.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
        return version;
    }

    @Override
    Path installCopiedArtifact(MavenArtifact artifact) throws IOException, ProvisioningException {
        Path transformedFile = null;
        if (this.isOverriddenArtifact(artifact)) {
            transformedFile = this.setupOverriddenArtifact(artifact);
        }
        Path path = artifact.getPath();
        String version = artifact.getVersion();
        if (!this.isExcludedFromTransformation(artifact)) {
            if (transformedFile == null) {
                String transformedFileName = this.getTransformedArtifactFileName(artifact.getVersion(), artifact.getPath().getFileName().toString());
                path = this.getRuntime().getTmpPath(new String[0]).resolve(transformedFileName);
                Files.createDirectories(path, new FileAttribute[0]);
                Files.deleteIfExists(path);
                this.transform(artifact, path);
            } else {
                path = transformedFile;
            }
            version = this.getTransformedVersion(version);
        }
        this.installInGeneratedRepo(artifact, version, path);
        return path;
    }
}

