/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.wildfly.galleon.plugin.AbstractArtifactInstaller;
import org.wildfly.galleon.plugin.AbstractModuleTemplateProcessor;
import org.wildfly.galleon.plugin.ModuleTemplate;
import org.wildfly.galleon.plugin.WfInstallPlugin;

class ThinModuleTemplateProcessor
extends AbstractModuleTemplateProcessor {
    ThinModuleTemplateProcessor(WfInstallPlugin plugin, AbstractArtifactInstaller installer, Path targetPath, ModuleTemplate template, Map<String, String> versionProps, boolean channelArtifactResolution) {
        super(plugin, installer, targetPath, template, versionProps, channelArtifactResolution);
    }

    @Override
    protected void processArtifact(AbstractModuleTemplateProcessor.ModuleArtifact moduleArtifact) throws IOException, MavenUniverseException, ProvisioningException {
        MavenArtifact artifact = moduleArtifact.getMavenArtifact();
        String installedVersion = this.getInstaller().installArtifactThin(artifact);
        StringBuilder buf = new StringBuilder();
        buf.append(artifact.getGroupId());
        buf.append(':');
        buf.append(artifact.getArtifactId());
        buf.append(':');
        buf.append(installedVersion);
        if (!artifact.getClassifier().isEmpty()) {
            buf.append(':');
            buf.append(artifact.getClassifier());
        }
        moduleArtifact.updateThinArtifact(buf.toString());
    }
}

