/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.wildfly.galleon.plugin.AbstractArtifactInstaller;
import org.wildfly.galleon.plugin.ModuleTemplate;
import org.wildfly.galleon.plugin.Utils;
import org.wildfly.galleon.plugin.WfInstallPlugin;

abstract class AbstractModuleTemplateProcessor {
    private final ModuleTemplate template;
    private final Map<String, String> versionProps;
    private final WfInstallPlugin plugin;
    private final AbstractArtifactInstaller installer;
    private final Path targetDir;
    private final boolean channelArtifactResolution;

    AbstractModuleTemplateProcessor(WfInstallPlugin plugin, AbstractArtifactInstaller installer, Path targetPath, ModuleTemplate template, Map<String, String> versionProps, boolean channelArtifactResolution) {
        this.template = template;
        this.versionProps = versionProps;
        this.plugin = plugin;
        this.installer = installer;
        this.targetDir = targetPath.getParent();
        this.channelArtifactResolution = channelArtifactResolution;
    }

    AbstractArtifactInstaller getInstaller() {
        return this.installer;
    }

    WfInstallPlugin getPlugin() {
        return this.plugin;
    }

    Path getTargetDir() {
        return this.targetDir;
    }

    MessageWriter getLog() {
        return this.plugin.log;
    }

    void process() throws ProvisioningException, IOException {
        if (this.template.isModule()) {
            this.processModuleVersion();
            this.processArtifacts();
        }
    }

    void processModuleVersion() throws ProvisioningException {
        String exprBody;
        int optionsIndex;
        String artifactName;
        MavenArtifact artifact;
        String versionExpr;
        Attribute versionAttribute = this.template.getRootElement().getAttribute("version");
        if (versionAttribute != null && (versionExpr = versionAttribute.getValue()).startsWith("${") && versionExpr.endsWith("}") && (artifact = Utils.toArtifactCoords(this.versionProps, artifactName = (optionsIndex = (exprBody = versionExpr.substring(2, versionExpr.length() - 1)).indexOf(63)) > 0 ? exprBody.substring(0, optionsIndex) : exprBody, false, this.channelArtifactResolution)) != null) {
            versionAttribute.setValue(artifact.getVersion());
        }
    }

    void processArtifacts() throws IOException, MavenUniverseException, ProvisioningException {
        Elements artifacts = this.template.getArtifacts();
        if (artifacts == null) {
            return;
        }
        int artifactCount = artifacts.size();
        for (int i = 0; i < artifactCount; ++i) {
            ModuleArtifact moduleArtifact = new ModuleArtifact(artifacts.get(i), this.versionProps, this.getLog(), this.installer, this.channelArtifactResolution);
            if (!moduleArtifact.hasMavenArtifact()) continue;
            Path artifactPath = moduleArtifact.getMavenArtifact().getPath();
            this.processArtifact(moduleArtifact);
            this.plugin.processSchemas(moduleArtifact.getMavenArtifact().getGroupId(), artifactPath);
        }
    }

    protected abstract void processArtifact(ModuleArtifact var1) throws IOException, MavenUniverseException, ProvisioningException;

    static class ModuleArtifact {
        private final Element element;
        private final Map<String, String> versionProps;
        private final MessageWriter log;
        private final AbstractArtifactInstaller installer;
        private final boolean channelArtifactResolution;
        boolean jandex;
        String coordsStr;
        private MavenArtifact artifact;
        private final Attribute attribute;

        ModuleArtifact(Element element, Map<String, String> versionProps, MessageWriter log, AbstractArtifactInstaller installer, boolean channelArtifactResolution) {
            this.versionProps = versionProps;
            this.log = log;
            this.installer = installer;
            this.element = element;
            this.channelArtifactResolution = channelArtifactResolution;
            assert (element.getLocalName().equals("artifact"));
            this.attribute = element.getAttribute("name");
            this.coordsStr = this.attribute.getValue();
            if (this.coordsStr.startsWith("${") && this.coordsStr.endsWith("}")) {
                this.coordsStr = this.coordsStr.substring(2, this.coordsStr.length() - 1);
                int optionsIndex = this.coordsStr.indexOf(63);
                if (optionsIndex >= 0) {
                    this.jandex = this.coordsStr.indexOf("jandex", optionsIndex) >= 0;
                    this.coordsStr = this.coordsStr.substring(0, optionsIndex);
                }
                this.coordsStr = this.versionProps.get(this.coordsStr);
            }
        }

        MavenArtifact getUnresolvedArtifact() throws IOException {
            if (this.coordsStr == null) {
                return null;
            }
            try {
                return Utils.toArtifactCoords(this.versionProps, this.coordsStr, false, this.channelArtifactResolution);
            }
            catch (ProvisioningException e) {
                throw new IOException("Failed to resolve full coordinates for " + this.coordsStr, e);
            }
        }

        MavenArtifact getMavenArtifact() throws IOException {
            if (this.artifact == null) {
                this.artifact = this.getUnresolvedArtifact();
                this.log.verbose("Resolving %s", new Object[]{this.artifact});
                try {
                    this.installer.getArtifactResolver().resolve(this.artifact);
                    if (this.channelArtifactResolution) {
                        this.log.verbose("Resolved %s", new Object[]{this.artifact});
                    }
                }
                catch (ProvisioningException e) {
                    throw new IOException("Failed to resolve artifact " + this.artifact, e);
                }
            }
            return this.artifact;
        }

        boolean hasMavenArtifact() throws IOException {
            return this.getMavenArtifact() != null;
        }

        boolean isJandex() {
            return this.jandex;
        }

        void updateFatArtifact(String finalFileName) {
            this.element.setLocalName("resource-root");
            this.attribute.setLocalName("path");
            this.attribute.setValue(finalFileName);
        }

        void updateThinArtifact(String coords) {
            this.attribute.setValue(coords);
        }
    }
}

