/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.wildfly.galleon.plugin.server.ConfigGeneratorException;
import org.wildfly.galleon.plugin.server.ForkCallback;

public class ForkedProcessRunner {
    public static void main(String ... args) {
        try {
            Object o;
            Class<?> cls;
            if (args.length < 2) {
                throw new IllegalStateException("Expected at least two arguments but got " + Arrays.asList(args));
            }
            ForkedProcessRunner.setSystemProps(args[0]);
            try {
                cls = Thread.currentThread().getContextClassLoader().loadClass(args[1]);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigGeneratorException("Failed to locate the target class " + args[1], e);
            }
            try {
                o = cls.newInstance();
            }
            catch (Exception e) {
                throw new ConfigGeneratorException("Failed to instantiate " + args[1], e);
            }
            ((ForkCallback)o).forkedForEmbedded(args.length == 2 ? new String[]{} : Arrays.copyOfRange(args, 2, args.length));
        }
        catch (Throwable t) {
            System.err.println("Forked embedded process has failed with the following error:");
            StringBuilder buf = new StringBuilder();
            while (t != null) {
                buf.setLength(0);
                buf.append(t.getClass().getName());
                if (t.getMessage() != null) {
                    buf.append(": ").append(t.getMessage());
                }
                System.err.println(buf.toString());
                for (StackTraceElement e : t.getStackTrace()) {
                    buf.setLength(0);
                    buf.append("\tat ").append(e.toString());
                    System.err.println(buf.toString());
                }
                t = t.getCause();
            }
            System.exit(1);
        }
    }

    private static void setSystemProps(String path) throws ConfigGeneratorException {
        Path props = Paths.get(path, new String[0]);
        if (!Files.exists(props, new LinkOption[0])) {
            throw new ConfigGeneratorException("Failed to locate " + props.toAbsolutePath());
        }
        Properties tmp = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(props);){
            tmp.load(reader);
        }
        catch (IOException e) {
            throw new ConfigGeneratorException("Failed to read " + props.toAbsolutePath());
        }
        for (Map.Entry<Object, Object> prop : tmp.entrySet()) {
            String current = System.getProperty(prop.getKey().toString());
            if (current != null) continue;
            System.setProperty(prop.getKey().toString(), prop.getValue().toString());
        }
    }
}

