/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.util.HashUtils;
import org.jboss.galleon.util.IoUtils;

public class ArtifactRecorder {
    private static final String ARTIFACT_LIST_FILE = "artifacts.txt";
    private static final String SEPARATOR = "::";
    private final Path stagedDir;
    private final Path cacheDir;
    private final Path artifactList;

    public ArtifactRecorder(Path stagedDir, Path cacheDir) throws IOException {
        this.stagedDir = stagedDir;
        this.cacheDir = cacheDir.isAbsolute() ? cacheDir : stagedDir.resolve(cacheDir);
        this.artifactList = this.cacheDir.resolve(ARTIFACT_LIST_FILE);
        this.initCacheDir();
    }

    private void initCacheDir() throws IOException {
        if (!Files.exists(this.cacheDir, new LinkOption[0])) {
            Files.createDirectories(this.cacheDir, new FileAttribute[0]);
        }
        Files.deleteIfExists(this.artifactList);
        Files.createFile(this.artifactList, new FileAttribute[0]);
    }

    public void record(MavenArtifact artifact, Path target) throws IOException {
        String hash = HashUtils.hashFile((Path)artifact.getPath());
        Files.writeString(this.artifactList, (CharSequence)(artifact.getCoordsAsString() + SEPARATOR + hash + SEPARATOR + this.stagedDir.relativize(target) + System.lineSeparator()), StandardOpenOption.APPEND);
    }

    public void cache(MavenArtifact artifact, Path jarSrc) throws MavenUniverseException, IOException {
        IoUtils.copy((Path)jarSrc, (Path)this.cacheDir.resolve(artifact.getArtifactFileName()));
        this.record(artifact, this.cacheDir.resolve(artifact.getArtifactFileName()));
    }
}

