/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.runtime.PackageRuntime;

class ModuleTemplate {
    private final Element rootElement;
    private final Document document;
    private final Path targetPath;

    ModuleTemplate(PackageRuntime pkg, Path moduleTemplate, Path targetPath) throws IOException, ProvisioningDescriptionException {
        Builder builder = new Builder(false);
        try (BufferedReader reader = Files.newBufferedReader(moduleTemplate, StandardCharsets.UTF_8);){
            this.document = builder.build(reader);
        }
        catch (ParsingException e) {
            throw new IOException("Failed to parse document", e);
        }
        this.rootElement = this.document.getRootElement();
        this.targetPath = targetPath;
    }

    String getName() {
        return this.rootElement.getAttributeValue("name");
    }

    Element getRootElement() {
        return this.rootElement;
    }

    Elements getArtifacts() {
        Elements artifacts = null;
        Element resourcesElement = this.rootElement.getFirstChildElement("resources", this.rootElement.getNamespaceURI());
        if (resourcesElement != null) {
            artifacts = resourcesElement.getChildElements("artifact", this.rootElement.getNamespaceURI());
        }
        return artifacts;
    }

    boolean isModule() {
        return this.rootElement.getLocalName().equals("module") || this.rootElement.getLocalName().equals("module-alias");
    }

    void store() throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(this.targetPath, new OpenOption[0]);){
            new Serializer(outputStream).write(this.document);
        }
        catch (Throwable t) {
            try {
                Files.deleteIfExists(this.targetPath);
            }
            catch (Throwable t2) {
                t2.addSuppressed(t);
                throw t2;
            }
            throw t;
        }
    }
}

