/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nu.xom.Elements;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.ProvisioningPluginWithOptions;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.w3c.dom.Document;
import org.wildfly.galleon.plugin.AbstractArtifactInstaller;
import org.wildfly.galleon.plugin.AbstractModuleTemplateProcessor;
import org.wildfly.galleon.plugin.ArtifactRecorder;
import org.wildfly.galleon.plugin.FatModuleTemplateProcessor;
import org.wildfly.galleon.plugin.MapPropertyResolver;
import org.wildfly.galleon.plugin.ModuleTemplate;
import org.wildfly.galleon.plugin.MonitorableArtifact;
import org.wildfly.galleon.plugin.PropertyReplacer;
import org.wildfly.galleon.plugin.PropertyResolver;
import org.wildfly.galleon.plugin.SimpleArtifactInstaller;
import org.wildfly.galleon.plugin.ThinModuleTemplateProcessor;
import org.wildfly.galleon.plugin.Utils;
import org.wildfly.galleon.plugin.WildFlyChannelResolutionMode;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.WildFlyPackageTasks;
import org.wildfly.galleon.plugin.config.CopyArtifact;
import org.wildfly.galleon.plugin.config.CopyPath;
import org.wildfly.galleon.plugin.config.DeletePath;
import org.wildfly.galleon.plugin.config.ExampleFpConfigs;
import org.wildfly.galleon.plugin.config.LineEndingsTask;
import org.wildfly.galleon.plugin.config.XslTransform;

public class WfInstallPlugin
extends ProvisioningPluginWithOptions
implements InstallPlugin {
    public static final String REQUIRES_CHANNEL_FOR_ARTIFACT_RESOLUTION_PROPERTY = "org.wildfly.plugins.galleon.all.artifact.requires.channel.resolution";
    private static final String TRACK_MODULES_BUILD = "JBMODULES";
    private static final String TRACK_COPY_CONFIGS = "JBCOPYCONFIGS";
    private static final String TRACK_ARTIFACTS_RESOLVE = "JB_ARTIFACTS_RESOLVE";
    private Optional<ArtifactRecorder> artifactRecorder;
    private static final String CONFIG_GEN_METHOD = "generate";
    private static final String CONFIG_GEN_GA = "org.wildfly.galleon-plugins:wildfly-config-gen";
    private static final String CONFIG_GEN_CLASS = "org.wildfly.galleon.plugin.config.generator.WfConfigGenerator";
    private static final String CLI_SCRIPT_RUNNER_CLASS = "org.wildfly.galleon.plugin.config.generator.CliScriptRunner";
    private static final String CLI_SCRIPT_RUNNER_METHOD = "runCliScript";
    private static final String JBOSS_MODULES_GA = "org.jboss.modules:jboss-modules";
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    private static final String WILDFLY_CLI_GA = "org.wildfly.core:wildfly-cli";
    private static final String WILDFLY_LAUNCHER_GA = "org.wildfly.core:wildfly-launcher";
    private static final ProvisioningOption OPTION_MVN_DIST = ProvisioningOption.builder((String)"jboss-maven-dist").setBooleanValueSet().build();
    public static final ProvisioningOption OPTION_DUMP_CONFIG_SCRIPTS = ProvisioningOption.builder((String)"jboss-dump-config-scripts").setPersistent(false).build();
    private static final ProvisioningOption OPTION_FORK_EMBEDDED = ProvisioningOption.builder((String)"jboss-fork-embedded").setBooleanValueSet().build();
    private static final ProvisioningOption OPTION_RESET_EMBEDDED_SYSTEM_PROPERTIES = ProvisioningOption.builder((String)"jboss-reset-embedded-system-properties").build();
    private static final ProvisioningOption OPTION_MVN_REPO = ProvisioningOption.builder((String)"jboss-maven-repo").setPersistent(false).build();
    private static final ProvisioningOption OPTION_OVERRIDDEN_ARTIFACTS = ProvisioningOption.builder((String)"jboss-overridden-artifacts").setPersistent(true).build();
    private static final ProvisioningOption OPTION_BULK_RESOLVE_ARTIFACTS = ProvisioningOption.builder((String)"jboss-bulk-resolve-artifacts").setBooleanValueSet().build();
    private static final ProvisioningOption OPTION_RECORD_ARTIFACTS = ProvisioningOption.builder((String)"jboss-resolved-artifacts-cache").setDefaultValue(".installation" + File.separator + ".cache").build();
    private ProvisioningRuntime runtime;
    MessageWriter log;
    private Map<String, String> mergedArtifactVersions = new HashMap<String, String>();
    private final Map<String, String> overriddenArtifactVersions = new HashMap<String, String>();
    private Map<FeaturePackLocation.ProducerSpec, Map<String, String>> fpArtifactVersions = new HashMap<FeaturePackLocation.ProducerSpec, Map<String, String>>();
    private Map<FeaturePackLocation.ProducerSpec, Map<String, String>> fpTasksProps = Collections.emptyMap();
    private Map<String, String> mergedTaskProps = new HashMap<String, String>();
    private PropertyResolver mergedTaskPropsResolver;
    private boolean thinServer;
    private Set<String> schemaGroups = Collections.emptySet();
    private List<WildFlyPackageTask> finalizingTasks = Collections.emptyList();
    private List<PackageRuntime> finalizingTasksPkgs = Collections.emptyList();
    private DocumentBuilderFactory docBuilderFactory;
    private TransformerFactory xsltFactory;
    private Map<String, Transformer> xslTransformers = Collections.emptyMap();
    private Map<FeaturePackLocation.FPID, ExampleFpConfigs> exampleConfigs = Collections.emptyMap();
    private ProgressTracker<PackageRuntime> pkgProgressTracker;
    private MavenRepoManager maven;
    private Map<Path, PackageRuntime> jbossModules = new LinkedHashMap<Path, PackageRuntime>();
    private Path generatedMavenRepo;
    private AbstractArtifactInstaller artifactInstaller;
    private ArtifactResolver artifactResolver;
    private boolean channelArtifactResolution;
    private boolean bulkResolveArtifacts;
    private final Map<MavenArtifact, MavenArtifact> artifactCache = new HashMap<MavenArtifact, MavenArtifact>();
    private final Map<Path, ModuleTemplate> moduleTemplateCache = new HashMap<Path, ModuleTemplate>();
    private final Map<String, String> resolvedVersionsProperties = new HashMap<String, String>();
    private Map<FeaturePackLocation.ProducerSpec, WildFlyChannelResolutionMode> channelResolutionModes = new LinkedHashMap<FeaturePackLocation.ProducerSpec, WildFlyChannelResolutionMode>();
    private Map<String, FeaturePackLocation.ProducerSpec> gaToProducer = new HashMap<String, FeaturePackLocation.ProducerSpec>();

    protected List<ProvisioningOption> initPluginOptions() {
        return Arrays.asList(OPTION_MVN_DIST, OPTION_DUMP_CONFIG_SCRIPTS, OPTION_FORK_EMBEDDED, OPTION_MVN_REPO, OPTION_RESET_EMBEDDED_SYSTEM_PROPERTIES, OPTION_OVERRIDDEN_ARTIFACTS, OPTION_BULK_RESOLVE_ARTIFACTS, OPTION_RECORD_ARTIFACTS);
    }

    public ProvisioningRuntime getRuntime() {
        return this.runtime;
    }

    private boolean isThinServer() throws ProvisioningException {
        return this.getBooleanOption(OPTION_MVN_DIST);
    }

    private Path getGeneratedMavenRepo() throws ProvisioningException {
        if (!this.runtime.isOptionSet(OPTION_MVN_REPO)) {
            return null;
        }
        String value = this.runtime.getOptionValue(OPTION_MVN_REPO);
        return value == null ? null : Paths.get(value, new String[0]);
    }

    private Map<String, String> getOverriddenArtifacts() throws ProvisioningException {
        if (!this.runtime.isOptionSet(OPTION_OVERRIDDEN_ARTIFACTS)) {
            return Collections.emptyMap();
        }
        if (this.channelArtifactResolution) {
            throw new ProvisioningException("Option " + OPTION_OVERRIDDEN_ARTIFACTS + " can't be used when channels are enabled.");
        }
        String value = this.runtime.getOptionValue(OPTION_OVERRIDDEN_ARTIFACTS);
        return value == null ? Collections.emptyMap() : Utils.toArtifactsMap(value);
    }

    private boolean isBulkResolveArtifacts() throws ProvisioningException {
        return this.getBooleanOption(OPTION_BULK_RESOLVE_ARTIFACTS);
    }

    private boolean isForkEmbedded(ProvisioningRuntime runtime) throws ProvisioningException {
        return this.getBooleanOption(OPTION_FORK_EMBEDDED);
    }

    private String isResetEmbeddedSystemProperties() throws ProvisioningException {
        if (!this.runtime.isOptionSet(OPTION_RESET_EMBEDDED_SYSTEM_PROPERTIES)) {
            return null;
        }
        String value = this.runtime.getOptionValue(OPTION_RESET_EMBEDDED_SYSTEM_PROPERTIES);
        return value == null ? "" : value;
    }

    private boolean getBooleanOption(ProvisioningOption option) throws ProvisioningException {
        if (!this.runtime.isOptionSet(option)) {
            return false;
        }
        String value = this.runtime.getOptionValue(option);
        return value == null ? true : Boolean.parseBoolean(value);
    }

    public void preInstall(ProvisioningRuntime runtime) throws ProvisioningException {
        String runningMode;
        FsDiff fsDiff = runtime.getFsDiff();
        if (fsDiff == null) {
            return;
        }
        String string = fsDiff.getEntry("standalone/tmp/startup-marker") != null ? "standalone" : (runningMode = fsDiff.getEntry("domain/tmp/startup-marker") != null ? "domain" : null);
        if (runningMode != null) {
            throw new ProvisioningException("The server appears to be running (" + runningMode + " mode).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInstall(ProvisioningRuntime runtime) throws ProvisioningException {
        Path layersConf;
        long startTime = runtime.isLogTime() ? System.nanoTime() : -1L;
        this.runtime = runtime;
        this.log = runtime.getMessageWriter();
        this.log.verbose((CharSequence)"WildFly Galleon Installation Plugin");
        if (runtime.isOptionSet(OPTION_RECORD_ARTIFACTS)) {
            String pathValue = runtime.getOptionValue(OPTION_RECORD_ARTIFACTS);
            if (pathValue != null && !pathValue.isEmpty()) {
                try {
                    this.log.verbose((CharSequence)"Starting artifact log");
                    this.artifactRecorder = Optional.of(new ArtifactRecorder(runtime.getStagedDir(), Path.of(pathValue, new String[0])));
                }
                catch (IOException e) {
                    throw new ProvisioningException("Unable to create artifact.log", (Throwable)e);
                }
            }
        } else {
            this.artifactRecorder = Optional.empty();
        }
        this.bulkResolveArtifacts = this.isBulkResolveArtifacts();
        this.thinServer = this.isThinServer();
        this.generatedMavenRepo = this.getGeneratedMavenRepo();
        if (this.generatedMavenRepo != null) {
            IoUtils.recursiveDelete((Path)this.generatedMavenRepo);
        }
        this.maven = (MavenRepoManager)runtime.getArtifactResolver("repository.maven");
        try {
            Class<?> clazz = Class.forName("org.wildfly.channel.spi.ChannelResolvable");
            this.channelArtifactResolution = clazz.isAssignableFrom(this.maven.getClass());
        }
        catch (ClassNotFoundException ex) {
            this.log.verbose((CharSequence)"Channel not present in classpath.");
        }
        this.log.verbose((CharSequence)("Channel artifact resolution enabled=" + this.channelArtifactResolution));
        this.overriddenArtifactVersions.putAll(this.getOverriddenArtifacts());
        for (FeaturePackRuntime fp : runtime.getFeaturePacks()) {
            Map<String, String> channelProps;
            String mode;
            Path path;
            Path tasksPropsPath;
            Path wfRes = fp.getResource(new String[]{"wildfly"});
            if (!Files.exists(wfRes, new LinkOption[0])) continue;
            Path artifactProps = wfRes.resolve("artifact-versions.properties");
            if (Files.exists(artifactProps, new LinkOption[0])) {
                Map<String, String> versionProps = Utils.readProperties(artifactProps);
                for (Map.Entry<String, String> entry : this.overriddenArtifactVersions.entrySet()) {
                    if (!versionProps.containsKey(entry.getKey())) continue;
                    versionProps.put(entry.getKey(), entry.getValue());
                }
                this.fpArtifactVersions.put(fp.getFPID().getProducer(), versionProps);
                if (versionProps.containsKey(CONFIG_GEN_GA)) {
                    this.gaToProducer.put(CONFIG_GEN_GA, fp.getFPID().getProducer());
                }
                if (versionProps.containsKey(WILDFLY_CLI_GA)) {
                    this.gaToProducer.put(WILDFLY_CLI_GA, fp.getFPID().getProducer());
                }
                if (versionProps.containsKey(WILDFLY_LAUNCHER_GA)) {
                    this.gaToProducer.put(WILDFLY_LAUNCHER_GA, fp.getFPID().getProducer());
                }
                if (versionProps.containsKey(JBOSS_MODULES_GA)) {
                    this.gaToProducer.put(JBOSS_MODULES_GA, fp.getFPID().getProducer());
                }
                this.mergedArtifactVersions.putAll(versionProps);
            }
            if (Files.exists(tasksPropsPath = wfRes.resolve("wildfly-tasks.properties"), new LinkOption[0])) {
                Map<String, String> map = Utils.readProperties(tasksPropsPath);
                this.fpTasksProps = CollectionUtils.put(this.fpTasksProps, (Object)fp.getFPID().getProducer(), map);
                this.mergedTaskProps.putAll(map);
            }
            if (Files.exists(path = wfRes.resolve("wildfly-channel.properties"), new LinkOption[0]) && (mode = (channelProps = Utils.readProperties(path)).get("resolution")) != null) {
                this.channelResolutionModes = CollectionUtils.put(this.channelResolutionModes, (Object)fp.getFPID().getProducer(), (Object)((Object)WildFlyChannelResolutionMode.valueOf(mode)));
            }
            if (!fp.containsPackage("docs.schema")) continue;
            Path schemaGroupsTxt = fp.getPackage("docs.schema").getResource(new String[]{"pm", "wildfly", "schema-groups.txt"});
            try {
                BufferedReader reader = Files.newBufferedReader(schemaGroupsTxt);
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        this.schemaGroups = CollectionUtils.add(this.schemaGroups, (Object)line);
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile((Path)schemaGroupsTxt), (Throwable)e);
            }
        }
        for (String key : this.overriddenArtifactVersions.keySet()) {
            if (this.mergedArtifactVersions.containsKey(key)) continue;
            throw new ProvisioningException("Overridden artifacts " + key + " is not found in the set of known server artifacts");
        }
        this.mergedArtifactVersions.putAll(this.overriddenArtifactVersions);
        this.mergedTaskPropsResolver = new MapPropertyResolver(this.mergedTaskProps);
        this.artifactResolver = this::resolveMaven;
        this.artifactInstaller = new SimpleArtifactInstaller(this.artifactResolver, this.generatedMavenRepo, this.artifactRecorder);
        ProvisioningLayoutFactory layoutFactory = runtime.getLayout().getFactory();
        this.pkgProgressTracker = layoutFactory.getProgressTracker("PACKAGES");
        long pkgsTotal = 0L;
        for (Object fp : runtime.getFeaturePacks()) {
            pkgsTotal += (long)fp.getPackageNames().size();
        }
        this.pkgProgressTracker.starting(pkgsTotal);
        for (Object fp : runtime.getFeaturePacks()) {
            this.processPackages((FeaturePackRuntime)fp);
        }
        this.pkgProgressTracker.complete();
        if (!this.jbossModules.isEmpty()) {
            if (this.bulkResolveArtifacts) {
                this.log.verbose((CharSequence)"Preloading artifacts");
                ProgressTracker artifactTracker = layoutFactory.getProgressTracker(TRACK_ARTIFACTS_RESOLVE);
                this.populateArtifactCache();
                artifactTracker.starting((long)this.artifactCache.size());
                this.resolveArtifactsInCache((ProgressTracker<MavenArtifact>)artifactTracker);
                artifactTracker.complete();
                this.log.verbose((CharSequence)"Finished preloading artifacts");
            }
            ProgressTracker modulesTracker = layoutFactory.getProgressTracker(TRACK_MODULES_BUILD);
            modulesTracker.starting((long)this.jbossModules.size());
            for (Map.Entry entry : this.jbossModules.entrySet()) {
                PackageRuntime pkg = (PackageRuntime)entry.getValue();
                modulesTracker.processing((Object)pkg);
                try {
                    this.processModuleTemplate(pkg, (Path)entry.getKey());
                }
                catch (IOException e) {
                    throw new ProvisioningException("Failed to process JBoss module XML template for feature-pack " + pkg.getFeaturePackRuntime().getFPID() + " package " + pkg.getName(), (Throwable)e);
                }
                modulesTracker.processed((Object)pkg);
            }
            modulesTracker.complete();
        }
        if (Files.exists(layersConf = runtime.getStagedDir().resolve("modules").resolve("layers.conf"), new LinkOption[0])) {
            this.mergeLayerConfs(runtime);
        }
        this.generateConfigs(runtime);
        if (Files.exists(runtime.getStagedDir(), new LinkOption[0])) {
            for (FeaturePackRuntime featurePackRuntime : runtime.getFeaturePacks()) {
                Path finalizeCli = featurePackRuntime.getResource(new String[]{"wildfly", "scripts", "finalize.cli"});
                if (!Files.exists(finalizeCli, new LinkOption[0])) continue;
                URL[] cp = new URL[2];
                try {
                    MavenArtifact artifact = Utils.toArtifactCoords(this.mergedArtifactVersions, CONFIG_GEN_GA, false, this.channelArtifactResolution, this.requireChannel(this.gaToProducer.get(CONFIG_GEN_GA)));
                    this.artifactResolver.resolve(artifact);
                    cp[0] = artifact.getPath().toUri().toURL();
                    artifact = Utils.toArtifactCoords(this.mergedArtifactVersions, WILDFLY_LAUNCHER_GA, false, this.channelArtifactResolution, this.requireChannel(this.gaToProducer.get(WILDFLY_LAUNCHER_GA)));
                    this.artifactResolver.resolve(artifact);
                    cp[1] = artifact.getPath().toUri().toURL();
                }
                catch (IOException e) {
                    throw new ProvisioningException("Failed to init classpath to run CLI finalize script for " + runtime.getStagedDir(), (Throwable)e);
                }
                ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
                URLClassLoader cliScriptCl = new URLClassLoader(cp, originalCl);
                try {
                    Path script;
                    try {
                        byte[] content = Files.readAllBytes(finalizeCli);
                        Path tmpDir = runtime.getTmpPath(new String[0]);
                        if (!Files.exists(tmpDir, new LinkOption[0])) {
                            Files.createDirectory(tmpDir, new FileAttribute[0]);
                        }
                        script = tmpDir.resolve(finalizeCli.getFileName().toString());
                        Files.write(script, content, new OpenOption[0]);
                    }
                    catch (IOException ex) {
                        throw new ProvisioningException(ex.getLocalizedMessage(), (Throwable)ex);
                    }
                    Thread.currentThread().setContextClassLoader(cliScriptCl);
                    try {
                        Class<?> cliScriptRunnerCls = cliScriptCl.loadClass(CLI_SCRIPT_RUNNER_CLASS);
                        Method m = cliScriptRunnerCls.getMethod(CLI_SCRIPT_RUNNER_METHOD, Path.class, Path.class, MessageWriter.class);
                        m.invoke(null, runtime.getStagedDir(), script, this.log);
                    }
                    catch (Throwable e) {
                        throw new ProvisioningException("Failed to initialize CLI script runner org.wildfly.galleon.plugin.config.generator.CliScriptRunner", e);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalCl);
                    try {
                        cliScriptCl.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!this.finalizingTasks.isEmpty()) {
            for (int i = 0; i < this.finalizingTasks.size(); ++i) {
                this.finalizingTasks.get(i).execute(this, this.finalizingTasksPkgs.get(i));
            }
        }
        if (!this.exampleConfigs.isEmpty()) {
            this.provisionExampleConfigs();
        }
        if (this.artifactRecorder.isPresent()) {
            try {
                this.artifactRecorder.get().writeCacheManifest();
            }
            catch (IOException e) {
                throw new ProvisioningException("Unable to record provisioned artifacts", (Throwable)e);
            }
        }
        if (startTime > 0L) {
            this.log.print((CharSequence)Errors.tookTime((String)"Overall WildFly Galleon Plugin", (long)startTime));
        }
    }

    private void populateArtifactCache() throws ProvisioningException {
        for (Map.Entry<Path, PackageRuntime> entry : this.jbossModules.entrySet()) {
            PackageRuntime pkg = entry.getValue();
            try {
                this.findArtifacts(pkg, entry.getKey());
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to process JBoss module XML template for feature-pack " + pkg.getFeaturePackRuntime().getFPID() + " package " + pkg.getName(), (Throwable)e);
            }
        }
    }

    private void findArtifacts(PackageRuntime pkg, Path moduleXmlRelativePath) throws ProvisioningException, IOException {
        Path moduleTemplateFile = pkg.getResource(new String[]{"pm", "wildfly", "module"}).resolve(moduleXmlRelativePath);
        Path targetPath = this.runtime.getStagedDir().resolve(moduleXmlRelativePath.toString());
        Map<String, String> versionProps = this.fpArtifactVersions.get(pkg.getFeaturePackRuntime().getFPID().getProducer());
        ModuleTemplate moduleTemplate = new ModuleTemplate(pkg, moduleTemplateFile, targetPath);
        this.moduleTemplateCache.put(moduleTemplateFile, moduleTemplate);
        if (!moduleTemplate.isModule()) {
            return;
        }
        Elements artifacts = moduleTemplate.getArtifacts();
        if (artifacts == null) {
            return;
        }
        int artifactCount = artifacts.size();
        for (int i = 0; i < artifactCount; ++i) {
            AbstractModuleTemplateProcessor.ModuleArtifact moduleArtifact = new AbstractModuleTemplateProcessor.ModuleArtifact(moduleTemplate, artifacts.get(i), versionProps, this.log, this.artifactInstaller, this.channelArtifactResolution, this.requireChannel(pkg.getFeaturePackRuntime().getFPID().getProducer()));
            MavenArtifact mavenArtifact = moduleArtifact.getUnresolvedArtifact();
            if (mavenArtifact == null) continue;
            MavenArtifact key = new MavenArtifact();
            key.setGroupId(mavenArtifact.getGroupId());
            key.setArtifactId(mavenArtifact.getArtifactId());
            key.setExtension(mavenArtifact.getExtension());
            key.setClassifier(mavenArtifact.getClassifier());
            key.setVersion(mavenArtifact.getVersion());
            key.setVersionRange(mavenArtifact.getVersionRange());
            this.artifactCache.put(key, mavenArtifact);
        }
    }

    private void resolveArtifactsInCache(ProgressTracker<MavenArtifact> tracker) throws ProvisioningException {
        try {
            this.maven.resolveAll(this.addListener(this.artifactCache.values(), tracker));
        }
        catch (MavenUniverseException e) {
            throw new ProvisioningException("Failed to resolve artifact", (Throwable)e);
        }
    }

    private Collection<MavenArtifact> addListener(Collection<MavenArtifact> values, ProgressTracker<MavenArtifact> tracker) {
        return values.stream().map(a -> new MonitorableArtifact((MavenArtifact)a, tracker)).collect(Collectors.toList());
    }

    private void setupLayerDirectory(Path layersConf, Path layersDir) throws ProvisioningException {
        this.log.verbose((CharSequence)"Creating layers directories if needed.");
        try (BufferedReader reader = Files.newBufferedReader(layersConf);){
            String[] layerNames;
            Properties props = new Properties();
            props.load(reader);
            String layersProp = props.getProperty("layers");
            if (layersProp == null || (layersProp = layersProp.trim()).length() == 0) {
                return;
            }
            for (String layerName : layerNames = layersProp.split(",")) {
                this.log.verbose("Found layer %s", new Object[]{layerName});
                Path layerDir = layersDir.resolve(layerName);
                if (Files.exists(layerDir, new LinkOption[0])) continue;
                this.log.verbose("Creating directory %s", new Object[]{layerDir});
                Files.createDirectories(layerDir, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw new ProvisioningException("Failed to setup layers directory in " + layersDir, (Throwable)ex);
        }
    }

    private void mergeLayerConfs(ProvisioningRuntime runtime) throws ProvisioningException {
        List<Path> layersConfs = Utils.collectLayersConf(runtime.getLayout());
        for (Path p : layersConfs) {
            this.setupLayerDirectory(p, runtime.getStagedDir().resolve("modules").resolve("system").resolve("layers"));
        }
        if (layersConfs.size() < 2) {
            return;
        }
        Utils.mergeLayersConfs(layersConfs, runtime.getStagedDir());
    }

    private void provisionExampleConfigs() throws ProvisioningException {
        Path examplesTmp = this.runtime.getTmpPath(new String[]{"example-configs"});
        ProvisioningLayoutFactory factory = this.runtime.getLayout().getFactory();
        final ProgressTracker examplesTracker = factory.getProgressTracker("JBEXTRACONFIGS");
        final ArrayList<String> trackedPhases = new ArrayList<String>(List.of("LAYOUT_BUILD", "PACKAGES", TRACK_MODULES_BUILD, "CONFIGS"));
        if (this.isBulkResolveArtifacts()) {
            trackedPhases.add(2, TRACK_ARTIFACTS_RESOLVE);
        }
        ProgressCallback<Object> aggregatingCallback = new ProgressCallback<Object>(){
            private int counter = 0;

            public void processing(ProgressTracker<Object> progressTracker) {
                Object item = progressTracker.getItem();
                examplesTracker.processing(Arrays.asList(trackedPhases.get(this.counter), item));
            }

            public void pulse(ProgressTracker<Object> progressTracker) {
            }

            public void complete(ProgressTracker<Object> progressTracker) {
                Object item = progressTracker.getItem();
                examplesTracker.processed(Arrays.asList(trackedPhases.get(this.counter), item));
                ++this.counter;
            }

            public void starting(ProgressTracker<Object> pt) {
            }
        };
        trackedPhases.forEach(arg_0 -> WfInstallPlugin.lambda$provisionExampleConfigs$1(factory, (ProgressCallback)aggregatingCallback, arg_0));
        ProvisioningManager pm = ProvisioningManager.builder().setInstallationHome(examplesTmp).setMessageWriter(this.log).setLayoutFactory(factory).setRecordState(false).build();
        ArrayList<Path> configPaths = new ArrayList<Path>();
        ProvisioningConfig.Builder configBuilder = ProvisioningConfig.builder();
        for (Map.Entry<FeaturePackLocation.FPID, ExampleFpConfigs> example : this.exampleConfigs.entrySet()) {
            FeaturePackConfig.Builder fpBuilder = ((FeaturePackConfig.Builder)FeaturePackConfig.builder((FeaturePackLocation)example.getKey().getLocation()).setInheritConfigs(false)).setInheritPackages(false);
            ExampleFpConfigs fpExampleConfigs = example.getValue();
            if (fpExampleConfigs != null) {
                for (Map.Entry<ConfigId, ConfigModel> config : fpExampleConfigs.getConfigs().entrySet()) {
                    ConfigId configId = config.getKey();
                    ConfigModel configModel = config.getValue();
                    String configName = null;
                    if (configModel != null) {
                        fpBuilder.addConfig(configModel);
                        if (configModel.hasProperties()) {
                            configName = "standalone".equals(configId.getModel()) ? (String)configModel.getProperties().get("--server-config") : ("host".equals(configId.getModel()) ? (String)configModel.getProperties().get("--host-config") : (String)configModel.getProperties().get("--domain-config"));
                        }
                        if (configName == null) {
                            configName = configId.getName();
                        }
                    } else {
                        fpBuilder.includeDefaultConfig(configId);
                        configName = configId.getName();
                    }
                    if ("host".equals(configId.getModel())) {
                        configPaths.add(examplesTmp.resolve("domain").resolve("configuration").resolve(configName));
                        continue;
                    }
                    configPaths.add(examplesTmp.resolve(configId.getModel()).resolve("configuration").resolve(configName));
                }
            }
            configBuilder.addFeaturePackDep(fpBuilder.build());
        }
        try {
            this.log.verbose((CharSequence)"Generating example configs");
            ProvisioningConfig config = configBuilder.build();
            HashMap options = this.runtime.getLayout().getOptions();
            if (!options.containsKey(OPTION_MVN_DIST.getName()) || options.containsKey(OPTION_MVN_REPO.getName())) {
                HashMap tmp = new HashMap(options.size() + 1);
                tmp.putAll(options);
                options = tmp;
                options.put(OPTION_MVN_DIST.getName(), null);
                options.remove(OPTION_MVN_REPO.getName());
            }
            pm.provision(config, (Map)options);
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException("Failed to generate example configs", (Throwable)e);
        }
        Path exampleConfigsDir = this.runtime.getStagedDir().resolve("docs").resolve("examples").resolve("configs");
        for (Path configPath : configPaths) {
            examplesTracker.processing(Arrays.asList(TRACK_COPY_CONFIGS, configPath));
            try {
                IoUtils.copy((Path)configPath, (Path)exampleConfigsDir.resolve(configPath.getFileName()));
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.copyFile((Path)configPath, (Path)exampleConfigsDir.resolve(configPath.getFileName())), (Throwable)e);
            }
        }
        examplesTracker.complete();
    }

    private void generateConfigs(ProvisioningRuntime runtime) throws ProvisioningException {
        if (!runtime.hasConfigs()) {
            return;
        }
        long startTime = runtime.isLogTime() ? System.nanoTime() : -1L;
        URL[] cp = new URL[3];
        try {
            MavenArtifact artifact = Utils.toArtifactCoords(this.mergedArtifactVersions, CONFIG_GEN_GA, false, this.channelArtifactResolution, this.requireChannel(this.gaToProducer.get(CONFIG_GEN_GA)));
            this.artifactResolver.resolve(artifact);
            if (this.artifactRecorder.isPresent()) {
                this.artifactRecorder.get().cache(artifact, artifact.getPath());
            }
            cp[0] = artifact.getPath().toUri().toURL();
            artifact = Utils.toArtifactCoords(this.mergedArtifactVersions, JBOSS_MODULES_GA, false, this.channelArtifactResolution, this.requireChannel(this.gaToProducer.get(JBOSS_MODULES_GA)));
            this.artifactResolver.resolve(artifact);
            cp[1] = artifact.getPath().toUri().toURL();
            artifact = Utils.toArtifactCoords(this.mergedArtifactVersions, "org.wildfly.core:wildfly-cli::client", false, this.channelArtifactResolution, this.requireChannel(this.gaToProducer.get(WILDFLY_CLI_GA)));
            this.artifactResolver.resolve(artifact);
            cp[2] = artifact.getPath().toUri().toURL();
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to init classpath for " + runtime.getStagedDir(), (Throwable)e);
        }
        if (this.log.isVerboseEnabled()) {
            this.log.verbose((CharSequence)"Config generator classpath:");
            for (int i = 0; i < cp.length; ++i) {
                this.log.verbose((CharSequence)(i + 1 + ". " + cp[i]));
            }
        }
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        URLClassLoader configGenCl = new URLClassLoader(cp, originalCl);
        Thread.currentThread().setContextClassLoader(configGenCl);
        try {
            Class<?> configHandlerCls = configGenCl.loadClass(CONFIG_GEN_CLASS);
            Constructor<?> ctor = configHandlerCls.getConstructor(new Class[0]);
            Method m = configHandlerCls.getMethod(CONFIG_GEN_METHOD, ProvisioningRuntime.class, Boolean.TYPE, String.class);
            Object generator = ctor.newInstance(new Object[0]);
            boolean forkEmbedded = this.isForkEmbedded(runtime);
            String resetEmbeddedSystemProperties = this.isResetEmbeddedSystemProperties();
            m.invoke(generator, runtime, forkEmbedded, resetEmbeddedSystemProperties);
            if (startTime > 0L) {
                this.log.print((CharSequence)Errors.tookTime((String)"WildFly configuration generation", (long)startTime));
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProvisioningException) {
                throw (ProvisioningException)cause;
            }
            throw new ProvisioningException("Failed to invoke config generator org.wildfly.galleon.plugin.config.generator.WfConfigGenerator", cause);
        }
        catch (Throwable e) {
            throw new ProvisioningException("Failed to initialize config generator org.wildfly.galleon.plugin.config.generator.WfConfigGenerator", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
            try {
                configGenCl.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void processPackages(FeaturePackRuntime fp) throws ProvisioningException {
        this.log.verbose("Processing %s packages", new Object[]{fp.getFPID()});
        for (PackageRuntime pkg : fp.getPackages()) {
            Path tasksXml;
            this.pkgProgressTracker.processing((Object)pkg);
            Path pmWfDir = pkg.getResource(new String[]{"pm", "wildfly"});
            if (!Files.exists(pmWfDir, new LinkOption[0])) {
                this.pkgProgressTracker.processed((Object)pkg);
                continue;
            }
            Path moduleDir = pmWfDir.resolve("module");
            if (Files.exists(moduleDir, new LinkOption[0])) {
                this.processModules(pkg, moduleDir);
            }
            if (Files.exists(tasksXml = pmWfDir.resolve("tasks.xml"), new LinkOption[0])) {
                WildFlyPackageTasks pkgTasks = WildFlyPackageTasks.load(tasksXml);
                if (pkgTasks.hasTasks()) {
                    this.log.verbose("Processing %s package %s tasks", new Object[]{fp.getFPID(), pkg.getName()});
                    for (WildFlyPackageTask task : pkgTasks.getTasks()) {
                        if (task.getPhase() == WildFlyPackageTask.Phase.PROCESSING) {
                            task.execute(this, pkg);
                            continue;
                        }
                        this.finalizingTasks = CollectionUtils.add(this.finalizingTasks, (Object)task);
                        this.finalizingTasksPkgs = CollectionUtils.add(this.finalizingTasksPkgs, (Object)pkg);
                    }
                }
                if (pkgTasks.hasMkDirs()) {
                    WfInstallPlugin.mkdirs(pkgTasks, this.runtime.getStagedDir());
                }
                List finalizingLineEndingTasks = pkgTasks.getLineEndings().stream().filter(t -> t.getPhase() == WildFlyPackageTask.Phase.FINALIZING).collect(Collectors.toList());
                this.finalizingTasks = CollectionUtils.addAll(this.finalizingTasks, finalizingLineEndingTasks);
                for (int i = 0; i < finalizingLineEndingTasks.size(); ++i) {
                    this.finalizingTasksPkgs = CollectionUtils.add(this.finalizingTasksPkgs, (Object)pkg);
                }
                List processingLineEndingTasks = pkgTasks.getLineEndings().stream().filter(t -> t.getPhase() == WildFlyPackageTask.Phase.PROCESSING).collect(Collectors.toList());
                for (LineEndingsTask lineEnding : processingLineEndingTasks) {
                    lineEnding.execute(this, pkg);
                }
            }
            this.pkgProgressTracker.processed((Object)pkg);
        }
    }

    public void xslTransform(PackageRuntime pkg, XslTransform xslt) throws ProvisioningException {
        Path src = this.runtime.getStagedDir().resolve(xslt.getSrc());
        if (!Files.exists(src, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)src));
        }
        Path tmp = this.runtime.getTmpPath(new String[0]).resolve(src.getFileName());
        try {
            MapPropertyResolver versionsResolver = new MapPropertyResolver(this.resolvedVersionsProperties);
            PropertyReplacer.copy(src, tmp, (PropertyResolver)versionsResolver, "Not Installed");
            Files.copy(tmp, src, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
        Path output = this.runtime.getStagedDir().resolve(xslt.getOutput());
        if (Files.exists(output, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathAlreadyExists((Path)output));
        }
        try (InputStream srcInput = Files.newInputStream(src, new OpenOption[0]);
             OutputStream outStream = Files.newOutputStream(output, new OpenOption[0]);){
            Map<String, String> taskProps;
            Document document = this.getXmlDocumentBuilderFactory().newDocumentBuilder().parse(srcInput);
            Transformer transformer = this.getXslTransformer(xslt.getStylesheet());
            if (xslt.hasParams()) {
                for (Map.Entry<String, String> entry : xslt.getParams().entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            Map<String, String> map = taskProps = xslt.isFeaturePackProperties() ? this.fpTasksProps.get(pkg.getFeaturePackRuntime().getFPID().getProducer()) : this.mergedTaskProps;
            if (taskProps != null) {
                for (Map.Entry<String, String> entry : taskProps.entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outStream);
            transformer.transform(dOMSource, streamResult);
        }
        catch (ProvisioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProvisioningException("Failed to transform " + xslt.getSrc() + " with " + xslt.getStylesheet() + " to " + xslt.getOutput(), (Throwable)e);
        }
    }

    private Transformer getXslTransformer(String stylesheet) throws ProvisioningException {
        Transformer transformer = this.xslTransformers.get(stylesheet);
        if (transformer != null) {
            return transformer;
        }
        transformer = this.getXslTransformer(this.runtime.getStagedDir().resolve(stylesheet));
        this.xslTransformers = CollectionUtils.put(this.xslTransformers, (Object)stylesheet, (Object)transformer);
        return transformer;
    }

    public DocumentBuilderFactory getXmlDocumentBuilderFactory() {
        if (this.docBuilderFactory == null) {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return this.docBuilderFactory;
    }

    public Transformer getXslTransformer(Path p) throws ProvisioningException {
        Transformer transformer;
        block10: {
            if (!Files.exists(p, new LinkOption[0])) {
                throw new ProvisioningException(Errors.pathDoesNotExist((Path)p));
            }
            InputStream styleInput = Files.newInputStream(p, new OpenOption[0]);
            try {
                StreamSource stylesource = new StreamSource(styleInput);
                if (this.xsltFactory == null) {
                    this.xsltFactory = TransformerFactory.newInstance();
                }
                transformer = this.xsltFactory.newTransformer(stylesource);
                if (styleInput == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (styleInput != null) {
                        try {
                            styleInput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ProvisioningException("Failed to initialize a transformer for " + p, (Throwable)e);
                }
            }
            styleInput.close();
        }
        return transformer;
    }

    private void processModules(final PackageRuntime pkg, final Path fpModuleDir) throws ProvisioningException {
        try {
            final Path stagedDir = this.runtime.getStagedDir();
            if (!Files.exists(stagedDir, new LinkOption[0])) {
                Files.createDirectories(stagedDir, new FileAttribute[0]);
            }
            Files.walkFileTree(fpModuleDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    block2: {
                        Path targetDir = stagedDir.resolve(fpModuleDir.relativize(dir).toString());
                        try {
                            Files.copy(dir, targetDir, new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException e) {
                            if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                            throw e;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().equals("module.xml")) {
                        PackageRuntime overriddenPkg = WfInstallPlugin.this.jbossModules.put(fpModuleDir.relativize(file), pkg);
                        if (overriddenPkg != null && WfInstallPlugin.this.log.isVerboseEnabled()) {
                            WfInstallPlugin.this.log.verbose((CharSequence)("Feature-pack " + pkg.getFeaturePackRuntime().getFPID() + " package " + pkg.getName() + " override jboss-module from feature-pack " + overriddenPkg.getFeaturePackRuntime().getFPID() + " package " + overriddenPkg.getName()));
                        }
                    } else {
                        Files.copy(file, stagedDir.resolve(fpModuleDir.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to process modules from package " + pkg.getName() + " from feature-pack " + pkg.getFeaturePackRuntime().getFPID(), (Throwable)e);
        }
    }

    private void processModuleTemplate(PackageRuntime pkg, Path moduleXmlRelativePath) throws ProvisioningException, IOException {
        Path moduleTemplateFile = pkg.getResource(new String[]{"pm", "wildfly", "module"}).resolve(moduleXmlRelativePath);
        Path targetPath = this.runtime.getStagedDir().resolve(moduleXmlRelativePath.toString());
        ModuleTemplate moduleTemplate = this.moduleTemplateCache.containsKey(moduleTemplateFile) ? this.moduleTemplateCache.get(moduleTemplateFile) : new ModuleTemplate(pkg, moduleTemplateFile, targetPath);
        if (!moduleTemplate.isModule()) {
            Files.copy(moduleTemplateFile, targetPath, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        Map<String, String> versionProps = this.fpArtifactVersions.get(pkg.getFeaturePackRuntime().getFPID().getProducer());
        Path targetDir = this.runtime.getStagedDir().resolve(moduleXmlRelativePath.toString());
        AbstractModuleTemplateProcessor processor = this.thinServer ? new ThinModuleTemplateProcessor(this, this.artifactInstaller, moduleXmlRelativePath, moduleTemplate, versionProps, this.channelArtifactResolution, this.requireChannel(pkg.getFeaturePackRuntime().getFPID().getProducer())) : new FatModuleTemplateProcessor(this, this.artifactInstaller, targetDir, moduleTemplate, versionProps, this.channelArtifactResolution, this.requireChannel(pkg.getFeaturePackRuntime().getFPID().getProducer()));
        processor.process();
        moduleTemplate.store();
    }

    public void addExampleConfigs(FeaturePackRuntime fp, ExampleFpConfigs exampleConfigs) throws ProvisioningException {
        FeaturePackLocation.FPID originFpId = exampleConfigs.getOrigin() != null ? fp.getSpec().getFeaturePackDep(exampleConfigs.getOrigin()).getLocation().getFPID() : fp.getFPID();
        ExampleFpConfigs existingConfigs = this.exampleConfigs.get(originFpId);
        if (existingConfigs == null) {
            this.exampleConfigs = CollectionUtils.put(this.exampleConfigs, (Object)originFpId, (Object)exampleConfigs);
        } else {
            existingConfigs.addAll(exampleConfigs);
        }
    }

    private void extractSchemas(Path moduleArtifact) throws IOException {
        Path targetSchemasDir = this.runtime.getStagedDir().resolve("docs").resolve("schema");
        Files.createDirectories(targetSchemasDir, new FileAttribute[0]);
        try (FileSystem jarFS = FileSystems.newFileSystem(moduleArtifact, (ClassLoader)null);){
            Path schemaSrc = jarFS.getPath("schema", new String[0]);
            if (Files.exists(schemaSrc, new LinkOption[0])) {
                ZipUtils.copyFromZip((Path)schemaSrc.toAbsolutePath(), (Path)targetSchemasDir);
            }
        }
    }

    private boolean requireChannel(FeaturePackLocation.ProducerSpec spec) {
        WildFlyChannelResolutionMode mode = this.channelResolutionModes.get(spec);
        boolean requireChannel = false;
        if (mode != null) {
            requireChannel = WildFlyChannelResolutionMode.REQUIRED.equals((Object)mode);
        }
        return requireChannel;
    }

    public void copyArtifact(CopyArtifact copyArtifact, PackageRuntime pkg) throws ProvisioningException {
        MavenArtifact artifact = Utils.toArtifactCoords(copyArtifact.isFeaturePackVersion() ? this.fpArtifactVersions.get(pkg.getFeaturePackRuntime().getFPID().getProducer()) : this.mergedArtifactVersions, copyArtifact.getArtifact(), copyArtifact.isOptional(), this.channelArtifactResolution, this.requireChannel(pkg.getFeaturePackRuntime().getFPID().getProducer()));
        if (artifact == null) {
            return;
        }
        try {
            this.log.verbose("Resolving artifact %s ", new Object[]{artifact});
            this.artifactResolver.resolve(artifact);
            if (this.channelArtifactResolution) {
                this.log.verbose("Resolved artifact %s ", new Object[]{artifact});
            }
            Path jarSrc = this.artifactInstaller.installCopiedArtifact(artifact);
            Object location = copyArtifact.getToLocation();
            if (!((String)location).isEmpty() && ((String)location).charAt(((String)location).length() - 1) == '/') {
                location = (String)location + jarSrc.getFileName();
            }
            Path jarTarget = this.runtime.getStagedDir().resolve((String)location);
            Files.createDirectories(jarTarget.getParent(), new FileAttribute[0]);
            this.log.verbose("Copying artifact %s to %s", new Object[]{jarSrc, jarTarget});
            if (copyArtifact.isExtract()) {
                Utils.extractArtifact(jarSrc, jarTarget, copyArtifact);
                if (this.artifactRecorder.isPresent()) {
                    this.artifactRecorder.get().cache(artifact, jarSrc);
                }
            } else {
                if (this.artifactRecorder.isPresent()) {
                    try {
                        this.artifactRecorder.get().record(artifact, jarTarget);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                IoUtils.copy((Path)jarSrc, (Path)jarTarget);
            }
            if (this.schemaGroups.contains(artifact.getGroupId())) {
                this.extractSchemas(jarSrc);
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to copy artifact " + artifact, (Throwable)e);
        }
    }

    void processSchemas(String groupId, Path artifactPath) throws IOException {
        if (this.schemaGroups.contains(groupId)) {
            this.extractSchemas(artifactPath);
        }
    }

    public void copyPath(Path relativeTo, CopyPath copyPath) throws ProvisioningException {
        Path target;
        final Path src = relativeTo.resolve(copyPath.getSrc());
        if (!Files.exists(src, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)src));
        }
        Path path = target = copyPath.getTarget() == null ? this.runtime.getStagedDir() : this.runtime.getStagedDir().resolve(copyPath.getTarget());
        if (copyPath.isReplaceProperties()) {
            if (!Files.exists(target.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.mkdirs((Path)target.getParent()), (Throwable)e);
                }
            }
            try {
                Files.walkFileTree(src, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        block2: {
                            Path targetDir = target.resolve(src.relativize(dir).toString());
                            try {
                                Files.copy(dir, targetDir, new CopyOption[0]);
                            }
                            catch (FileAlreadyExistsException e) {
                                if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                                throw e;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        PropertyReplacer.copy(file, target.resolve(src.relativize(file).toString()), WfInstallPlugin.this.mergedTaskPropsResolver, null);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.copyFile((Path)src, (Path)target), (Throwable)e);
            }
        }
        try {
            IoUtils.copy((Path)src, (Path)target);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.copyFile((Path)src, (Path)target));
        }
    }

    public void deletePath(DeletePath deletePath) throws ProvisioningException {
        Path path = this.runtime.getStagedDir().resolve(deletePath.getPath());
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (deletePath.isRecursive()) {
            IoUtils.recursiveDelete((Path)path);
            return;
        }
        if (deletePath.isIfEmpty()) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new ProvisioningException(Errors.notADir((Path)path));
            }
            try (Stream<Path> stream = Files.list(path);){
                if (stream.iterator().hasNext()) {
                    return;
                }
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readDirectory((Path)path));
            }
        }
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.deletePath((Path)path), (Throwable)e);
        }
    }

    private static void mkdirs(WildFlyPackageTasks tasks, Path installDir) throws ProvisioningException {
        for (String dirName : tasks.getMkDirs()) {
            try {
                Files.createDirectories(installDir.resolve(dirName), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.mkdirs((Path)installDir.resolve(dirName)));
            }
        }
    }

    void resolveMaven(MavenArtifact artifact) throws ProvisioningException {
        if (this.bulkResolveArtifacts && this.artifactCache.containsKey(artifact)) {
            MavenArtifact resolvedArtifact = this.artifactCache.get(artifact);
            artifact.setVersion(resolvedArtifact.getVersion());
            artifact.setPath(resolvedArtifact.getPath());
        } else {
            this.maven.resolve(artifact);
        }
        this.resolvedVersionsProperties.put("version." + artifact.getGroupId() + "." + artifact.getArtifactId(), artifact.getVersion());
    }

    boolean isOverriddenArtifact(MavenArtifact artifact) throws ProvisioningException {
        return Utils.containsArtifact(this.overriddenArtifactVersions, artifact);
    }

    private static /* synthetic */ void lambda$provisionExampleConfigs$1(ProvisioningLayoutFactory factory, ProgressCallback aggregatingCallback, String p) {
        factory.setProgressCallback(p, aggregatingCallback);
    }

    static interface ArtifactResolver {
        public void resolve(MavenArtifact var1) throws ProvisioningException;
    }
}

