/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.galleon.plugin.ArtifactRecorder;
import org.wildfly.galleon.plugin.Utils;
import org.wildfly.galleon.plugin.WfInstallPlugin;

public class ShadedModel
implements Utils.ArtifactResourceConsumer {
    public static final String FILE_NAME = "shaded-model.xml";
    private final Map<String, Set<String>> classes = new HashMap<String, Set<String>>();
    private final Map<String, List<String>> serviceLoaders = new HashMap<String, List<String>>();
    private final Element rootElement;
    private final Document document;
    private final Path tmpPath;
    private final WfInstallPlugin.ArtifactResolver artifactResolver;
    private final MessageWriter log;
    private final Map<String, String> mergedArtifactVersions;
    private final Optional<ArtifactRecorder> recorder;
    private boolean seenManifest;
    private final Installer installer;
    private final boolean channelArtifactResolution;
    private final boolean requireChannel;

    public ShadedModel(boolean requireChannel, Path shadedModel, Path tmpPath, WfInstallPlugin.ArtifactResolver artifactResolver, MessageWriter log, Map<String, String> mergedArtifactVersions, Installer installer, boolean channelArtifactResolution, Optional<ArtifactRecorder> recorder) throws IOException, ProvisioningDescriptionException {
        this.requireChannel = requireChannel;
        this.tmpPath = tmpPath;
        this.artifactResolver = artifactResolver;
        this.log = log;
        this.mergedArtifactVersions = mergedArtifactVersions;
        this.installer = installer;
        Builder builder = new Builder(false);
        try (BufferedReader reader = Files.newBufferedReader(shadedModel, StandardCharsets.UTF_8);){
            this.document = builder.build(reader);
        }
        catch (ParsingException e) {
            throw new IOException("Failed to parse document", e);
        }
        this.rootElement = this.document.getRootElement();
        this.channelArtifactResolution = channelArtifactResolution;
        this.recorder = recorder;
    }

    public List<MavenArtifact> getArtifacts() throws ProvisioningException, IOException {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        Element shadedDependencies = this.rootElement.getFirstChildElement("shaded-dependencies", this.rootElement.getNamespaceURI());
        Elements dependencies = shadedDependencies.getChildElements();
        for (int i = 0; i < dependencies.size(); ++i) {
            Element e = dependencies.get(i);
            MavenArtifact a = Utils.toArtifactCoords(this.mergedArtifactVersions, e.getValue(), false, this.channelArtifactResolution, this.requireChannel);
            this.artifactResolver.resolve(a);
            if (this.log.isVerboseEnabled()) {
                this.log.verbose((CharSequence)("Shadel model dependency: " + e.getValue() + " resolved version " + a.getVersion()));
            }
            Path transformed = this.installer.installCopiedArtifact(a);
            a.setPath(transformed);
            artifacts.add(a);
            if (!this.recorder.isPresent()) continue;
            this.recorder.get().cache(a, a.getPath());
        }
        return artifacts;
    }

    public Map<String, String> getManifestEntries() {
        HashMap<String, String> entries = new HashMap<String, String>();
        Element manifestEntries = this.rootElement.getFirstChildElement("manifestEntries", this.rootElement.getNamespaceURI());
        Elements elements = manifestEntries.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            Element e = elements.get(i);
            entries.put(e.getLocalName(), e.getValue());
        }
        return entries;
    }

    public String getMainClass() {
        String ret = null;
        Element mainClass = this.rootElement.getFirstChildElement("main-class", this.rootElement.getNamespaceURI());
        if (mainClass != null) {
            ret = mainClass.getValue();
        }
        return ret;
    }

    public String getName() {
        return this.rootElement.getFirstChildElement("name", this.rootElement.getNamespaceURI()).getValue();
    }

    public void buildJar(Path shadedJar) throws IOException, ProvisioningException {
        if (this.log.isVerboseEnabled()) {
            this.log.verbose((CharSequence)("Assembling shaded jar " + shadedJar));
        }
        Path tmpTarget = this.tmpPath.resolve("assemble_target").resolve(shadedJar.getFileName());
        Files.createDirectories(tmpTarget, new FileAttribute[0]);
        for (MavenArtifact dependency : this.getArtifacts()) {
            Utils.navigateArtifact(dependency.getPath(), tmpTarget, this);
        }
        this.generateMetaInf(tmpTarget);
        ZipUtils.zip((Path)tmpTarget, (Path)shadedJar);
        IoUtils.recursiveDelete((Path)tmpTarget);
    }

    private void generateMetaInf(Path target) throws IOException {
        Map<String, String> manifestEntries;
        Manifest manifest;
        Path targetMetaInf = target.resolve("META-INF");
        Path targetManifestPath = targetMetaInf.resolve("MANIFEST.MF");
        if (!Files.exists(targetManifestPath, new LinkOption[0])) {
            manifest = new Manifest();
        } else {
            try (FileInputStream stream = new FileInputStream(targetManifestPath.toFile());){
                manifest = new Manifest(stream);
            }
        }
        Attributes attributes = manifest.getMainAttributes();
        String mainClass = this.getMainClass();
        if (mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, mainClass);
        }
        if ((manifestEntries = this.getManifestEntries()) != null) {
            for (Map.Entry<String, String> entry : manifestEntries.entrySet()) {
                if (entry.getValue() == null) {
                    attributes.remove(new Attributes.Name(entry.getKey()));
                    continue;
                }
                attributes.put(new Attributes.Name(entry.getKey()), entry.getValue());
            }
        }
        attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, "Galleon shading of " + this.getName());
        attributes.put(Attributes.Name.SPECIFICATION_TITLE, "Galleon shading of " + this.getName());
        attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, "Unknown");
        Files.deleteIfExists(targetManifestPath);
        if (!Files.exists(targetMetaInf, new LinkOption[0])) {
            Files.createDirectories(targetMetaInf, new FileAttribute[0]);
        }
        try (FileOutputStream out = new FileOutputStream(targetManifestPath.toFile());){
            manifest.write(out);
        }
        Path moduleInfoPath = target.resolve("module-info.class");
        Files.deleteIfExists(moduleInfoPath);
        Path indexListPath = target.resolve("META-INF/INDEX.LIST");
        Files.deleteIfExists(indexListPath);
        Path services = target.resolve("META-INF").resolve("services");
        for (Map.Entry<String, List<String>> entry : this.serviceLoaders.entrySet()) {
            Path file = services.resolve(entry.getKey());
            Files.write(file, (Iterable<? extends CharSequence>)entry.getValue(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    @Override
    public boolean consume(Path resourcePath) throws IOException {
        String entry = resourcePath.toString().substring(1);
        if (entry.startsWith("META-INF/MANIFEST.MF")) {
            if (!this.seenManifest) {
                this.seenManifest = true;
                return true;
            }
            return false;
        }
        if (entry.startsWith("META-INF/services/")) {
            String fileName = resourcePath.getFileName().toString();
            List<String> lines = Files.readAllLines(resourcePath);
            List<String> allLines = this.serviceLoaders.get(fileName);
            Set<String> allClasses = this.classes.get(fileName);
            if (allLines == null) {
                allLines = new ArrayList<String>();
                this.serviceLoaders.put(fileName, allLines);
            }
            if (allClasses == null) {
                allClasses = new HashSet<String>();
                this.classes.put(fileName, allClasses);
            }
            boolean newClasses = false;
            for (String l : lines) {
                if ((l = l.trim()).isEmpty() || l.startsWith("#") || allClasses.contains(l)) continue;
                newClasses = true;
                break;
            }
            if (newClasses) {
                for (String l : lines) {
                    if ((l = l.trim()).isEmpty()) continue;
                    if (l.startsWith("#")) {
                        allLines.add(l);
                        continue;
                    }
                    if (allClasses.contains(l)) continue;
                    allClasses.add(l);
                    allLines.add(l);
                }
            }
            return false;
        }
        return true;
    }

    public static interface Installer {
        public Path installCopiedArtifact(MavenArtifact var1) throws IOException, ProvisioningException;
    }
}

