/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.wildfly.galleon.plugin.PropertyResolver;

public class PropertyReplacer {
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private static final int RESOLVED = 3;
    private static final int DEFAULT = 4;

    public static void copy(Path src, Path target, PropertyResolver resolver, String failureReplacement) throws IOException {
        if (!Files.exists(target.getParent(), new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        try (BufferedReader reader = Files.newBufferedReader(src);
             BufferedWriter writer = Files.newBufferedWriter(target, new OpenOption[0]);){
            PropertyReplacer.copy(reader, writer, resolver, failureReplacement);
        }
    }

    public static void copy(Reader reader, Writer writer, PropertyResolver properties, String failureReplacement) throws IOException {
        int state = 0;
        StringBuilder buf = new StringBuilder();
        int ch = reader.read();
        while (ch >= 0) {
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case 36: {
                            state = 1;
                            break block0;
                        }
                    }
                    writer.write(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 36: {
                            buf.setLength(0);
                            writer.write(ch);
                            state = 0;
                            break block0;
                        }
                        case 123: {
                            state = 2;
                            break block0;
                        }
                    }
                    writer.append('$');
                    writer.write(ch);
                    buf.setLength(0);
                    state = 0;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 44: 
                        case 125: {
                            String name = buf.toString();
                            if ("/".equals(name)) {
                                writer.append(File.separatorChar);
                                state = ch == 125 ? 0 : 3;
                            } else {
                                String val = properties.resolveProperty(name);
                                if (val != null) {
                                    writer.write(val);
                                    state = ch == 125 ? 0 : 3;
                                } else if (ch == 44) {
                                    state = 4;
                                } else if (failureReplacement != null) {
                                    writer.write(failureReplacement);
                                    state = ch == 125 ? 0 : 3;
                                } else {
                                    throw new IllegalStateException("Failed to resolve property: " + String.valueOf(buf));
                                }
                            }
                            buf.setLength(0);
                            break block0;
                        }
                    }
                    buf.appendCodePoint(ch);
                    break;
                }
                case 3: {
                    if (ch != 125) break;
                    state = 0;
                    break;
                }
                case 4: {
                    if (ch == 125) {
                        state = 0;
                        String val = properties.resolveProperty(buf.toString());
                        if (val != null) {
                            writer.write(val);
                            break;
                        }
                        writer.write(buf.toString());
                        break;
                    }
                    buf.appendCodePoint(ch);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected char seen: " + ch);
                }
            }
            ch = reader.read();
        }
        switch (state) {
            case 1: {
                writer.append('$');
                break;
            }
            case 4: {
                writer.write(buf.toString());
                break;
            }
            case 2: {
                throw new IllegalStateException("Incomplete expression: " + buf.toString());
            }
        }
    }
}

