/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.Collections;
import java.util.List;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.util.CollectionUtils;
import org.wildfly.galleon.plugin.WfInstallPlugin;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.config.FileFilter;

public class CopyArtifact
implements WildFlyPackageTask {
    private String artifact;
    private String toLocation;
    private boolean extract;
    private List<FileFilter> filters = Collections.emptyList();
    private boolean optional;
    private boolean featurePackVersion;

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public void setToLocation(String toLocation) {
        this.toLocation = toLocation;
    }

    public void setExtract() {
        this.extract = true;
    }

    public void addFilter(FileFilter filter) {
        this.filters = CollectionUtils.add(this.filters, (Object)filter);
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getToLocation() {
        return this.toLocation;
    }

    public boolean isExtract() {
        return this.extract;
    }

    public List<FileFilter> getFilters() {
        return this.filters;
    }

    public void setOptional() {
        this.optional = true;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean includeFile(String path) {
        for (FileFilter filter : this.filters) {
            if (!filter.matches(path)) continue;
            return filter.isInclude();
        }
        return true;
    }

    public void setFeaturePackVersion() {
        this.featurePackVersion = true;
    }

    public boolean isFeaturePackVersion() {
        return this.featurePackVersion;
    }

    @Override
    public void execute(WfInstallPlugin plugin, PackageRuntime pkg) throws ProvisioningException {
        try {
            plugin.copyArtifact(this, pkg);
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException("Failed to execute an artifact copying task of feature-pack " + String.valueOf(pkg.getFeaturePackRuntime().getFPID()) + " package " + pkg.getName(), (Throwable)e);
        }
    }
}

