/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.WildFlyPackageTasks;
import org.wildfly.galleon.plugin.config.AssembleShadedArtifact;
import org.wildfly.galleon.plugin.config.CopyArtifact;
import org.wildfly.galleon.plugin.config.CopyPath;
import org.wildfly.galleon.plugin.config.DeletePath;
import org.wildfly.galleon.plugin.config.ExampleFpConfigs;
import org.wildfly.galleon.plugin.config.FileAppender;
import org.wildfly.galleon.plugin.config.FileFilter;
import org.wildfly.galleon.plugin.config.FilePermission;
import org.wildfly.galleon.plugin.config.FilePermissions;
import org.wildfly.galleon.plugin.config.LineEndingsTask;
import org.wildfly.galleon.plugin.config.XmlMerge;
import org.wildfly.galleon.plugin.config.XslTransform;

class WildFlyPackageTasksParser32
implements XMLElementReader<WildFlyPackageTasks.Builder> {
    WildFlyPackageTasksParser32() {
    }

    public void readElement(XMLExtendedStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int count = reader.getAttributeCount();
        if (count != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block17: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 2: {
                            builder.addTask(this.parseAssembleShadedArtifact((XMLStreamReader)reader));
                            continue block17;
                        }
                        case 1: {
                            builder.addTask(this.parseCopyArtifact((XMLStreamReader)reader));
                            continue block17;
                        }
                        case 3: {
                            builder.addTask(this.parseCopyPath(reader));
                            continue block17;
                        }
                        case 4: {
                            builder.addTask(this.parseDeletePath((XMLStreamReader)reader));
                            continue block17;
                        }
                        case 5: {
                            builder.addTask(this.parseExampleConfigs(reader));
                            continue block17;
                        }
                        case 16: {
                            builder.addTask(this.parseTransform(reader));
                            continue block17;
                        }
                        case 7: {
                            this.parseFilePermissions(reader, builder);
                            continue block17;
                        }
                        case 11: {
                            builder.addMkDir(this.parseMkdir((XMLStreamReader)reader));
                            continue block17;
                        }
                        case 19: {
                            builder.addTask(this.parseXmlMerge((XMLStreamReader)reader));
                            continue block17;
                        }
                        case 6: {
                            builder.addTask(this.parseFileAppender(reader));
                            continue block17;
                        }
                        case 10: {
                            this.parseLineEndings((XMLStreamReader)reader, builder);
                            continue block17;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private ExampleFpConfigs parseExampleConfigs(XMLExtendedStreamReader reader) throws XMLStreamException {
        ExampleFpConfigs exampleConfigs = new ExampleFpConfigs();
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 15: {
                    exampleConfigs.setOrigin(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return exampleConfigs;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 0: {
                            this.parseExampleConfigs(reader, exampleConfigs);
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseExampleConfigs(XMLExtendedStreamReader reader, ExampleFpConfigs builder) throws XMLStreamException {
        ConfigModel.Builder configBuilder = ConfigModel.builder();
        ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)configBuilder);
        try {
            builder.addConfig(configBuilder.build());
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to instantiate config model", e);
        }
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute.ordinal()) {
                case 13: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return name;
    }

    private String parseMkdir(XMLStreamReader reader) throws XMLStreamException {
        return this.parseName(reader);
    }

    private void parseLineEndings(XMLStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        WildFlyPackageTask.Phase phase = WildFlyPackageTask.Phase.PROCESSING;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 19: {
                    phase = WildFlyPackageTask.Phase.valueOf(reader.getAttributeValue(i).toUpperCase());
                    continue block11;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        List unixLineEndFilters = Collections.emptyList();
        List windowsLineEndFilters = Collections.emptyList();
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    LineEndingsTask lineEndingsTask = new LineEndingsTask(unixLineEndFilters, windowsLineEndFilters, phase);
                    builder.addLineEndings(lineEndingsTask);
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 18: {
                            windowsLineEndFilters = CollectionUtils.addAll(windowsLineEndFilters, this.parseLineEnding(reader));
                            continue block12;
                        }
                        case 17: {
                            unixLineEndFilters = CollectionUtils.addAll(unixLineEndFilters, this.parseLineEnding(reader));
                            continue block12;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private List<FileFilter> parseLineEnding(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        List filters = Collections.emptyList();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return filters;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    FileFilter filter = this.parseFilter(reader);
                    switch (element.ordinal()) {
                        case 8: {
                            filters = CollectionUtils.add(filters, (Object)filter);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    public FileFilter parseFilter(XMLStreamReader reader) throws XMLStreamException {
        FileFilter builder = new FileFilter();
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN, Attribute.INCLUDE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute.ordinal()) {
                case 18: {
                    builder.setPatternString(reader.getAttributeValue(i));
                    continue block4;
                }
                case 10: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block4;
                    builder.setInclude();
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return builder;
    }

    private CopyArtifact parseCopyArtifact(XMLStreamReader reader) throws XMLStreamException {
        CopyArtifact builder = new CopyArtifact();
        EnumSet<Attribute> required = EnumSet.of(Attribute.ARTIFACT, Attribute.TO_LOCATION);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute.ordinal()) {
                case 2: {
                    builder.setArtifact(reader.getAttributeValue(i));
                    continue block14;
                }
                case 27: {
                    builder.setToLocation(reader.getAttributeValue(i));
                    continue block14;
                }
                case 4: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block14;
                    builder.setExtract();
                    continue block14;
                }
                case 14: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block14;
                    builder.setOptional();
                    continue block14;
                }
                case 6: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block14;
                    builder.setFeaturePackVersion();
                    continue block14;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return builder;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 8: {
                            builder.addFilter(this.parseFilter(reader));
                            continue block15;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private AssembleShadedArtifact parseAssembleShadedArtifact(XMLStreamReader reader) throws XMLStreamException {
        AssembleShadedArtifact builder = new AssembleShadedArtifact();
        EnumSet<Attribute> required = EnumSet.of(Attribute.SHADED_MODEL_PACKAGE, Attribute.TO_LOCATION);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute.ordinal()) {
                case 23: {
                    builder.setShadedModelPackage(reader.getAttributeValue(i));
                    continue block4;
                }
                case 27: {
                    builder.setToLocation(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return builder;
    }

    private CopyPath parseCopyPath(XMLExtendedStreamReader reader) throws XMLStreamException {
        CopyPath cpBuilder = new CopyPath();
        boolean src = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 24: {
                    cpBuilder.setSrc(reader.getAttributeValue(i));
                    src = true;
                    continue block6;
                }
                case 26: {
                    cpBuilder.setTarget(reader.getAttributeValue(i));
                    continue block6;
                }
                case 22: {
                    cpBuilder.setReplaceProperties(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block6;
                }
                case 20: {
                    cpBuilder.setRelativeTo(reader.getAttributeValue(i));
                    src = true;
                    continue block6;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!src) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PATH));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return cpBuilder;
    }

    private FileAppender parseFileAppender(XMLExtendedStreamReader reader) throws XMLStreamException {
        FileAppender fileAppender = new FileAppender();
        boolean target = false;
        boolean src = false;
        int count = reader.getAttributeCount();
        block18: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 1: {
                    fileAppender.setAllMatches(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block18;
                }
                case 0: {
                    fileAppender.setAddToMatchingLine(reader.getAttributeValue(i));
                    continue block18;
                }
                case 11: {
                    fileAppender.setMatch(reader.getAttributeValue(i));
                    continue block18;
                }
                case 26: {
                    fileAppender.setTarget(reader.getAttributeValue(i));
                    target = true;
                    continue block18;
                }
                case 9: {
                    fileAppender.setIgnore(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    continue block18;
                }
                case 24: {
                    fileAppender.setSource(reader.getAttributeValue(i));
                    src = true;
                    continue block18;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!target) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PATH));
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 9: {
                            fileAppender.addLine(reader.getElementText());
                            if (!src) break block8;
                            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
                case 2: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 9: {
                            break block8;
                        }
                    }
                    return fileAppender;
                }
            }
        }
        return fileAppender;
    }

    private void parseFilePermissions(XMLExtendedStreamReader reader, WildFlyPackageTasks.Builder builder) throws XMLStreamException {
        FilePermissions permissions = new FilePermissions();
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 19: {
                    permissions.setPhase(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    builder.addTask(permissions);
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 14: {
                            permissions.addFilePermissions(this.parsePermission((XMLStreamReader)reader));
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    protected FilePermission parsePermission(XMLStreamReader reader) throws XMLStreamException {
        FilePermission permissionBuilder = new FilePermission();
        EnumSet<Attribute> required = EnumSet.of(Attribute.VALUE);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute.ordinal()) {
                case 28: {
                    permissionBuilder.setValue(reader.getAttributeValue(i));
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return permissionBuilder;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 8: {
                            permissionBuilder.addFilter(this.parseFilter(reader));
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private DeletePath parseDeletePath(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String path = null;
        boolean recursive = false;
        boolean ifEmpty = false;
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 17: {
                    path = reader.getAttributeValue(i);
                    continue block5;
                }
                case 21: {
                    recursive = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block5;
                }
                case 8: {
                    ifEmpty = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block5;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (path == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PATH));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return new DeletePath(path, recursive, ifEmpty);
    }

    private XslTransform parseTransform(XMLExtendedStreamReader reader) throws XMLStreamException {
        XslTransform result = new XslTransform();
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 24: {
                    result.setSrc(reader.getAttributeValue(i));
                    continue block14;
                }
                case 16: {
                    result.setOutput(reader.getAttributeValue(i));
                    continue block14;
                }
                case 25: {
                    result.setStylesheet(reader.getAttributeValue(i));
                    continue block14;
                }
                case 19: {
                    result.setPhase(reader.getAttributeValue(i));
                    continue block14;
                }
                case 5: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block14;
                    result.setFeaturePackProperties();
                    continue block14;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (result.getSrc() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.SRC));
                    }
                    if (result.getOutput() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.OUTPUT));
                    }
                    if (result.getStylesheet() == null) {
                        throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.STYLESHEET));
                    }
                    return result;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 13: {
                            this.parseParams((XMLStreamReader)reader, result);
                            continue block15;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseParams(XMLStreamReader reader, XslTransform result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 12: {
                            this.parseParam(reader, result);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseParam(XMLStreamReader reader, XslTransform result) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 13: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case 28: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        result.setParam(name, value);
    }

    private XmlMerge parseXmlMerge(XMLStreamReader reader) throws XMLStreamException {
        XmlMerge builder = new XmlMerge();
        EnumSet<Attribute> required = EnumSet.of(Attribute.OUTPUT);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute.ordinal()) {
                case 16: {
                    builder.setOutput(reader.getAttributeValue(i));
                    continue block11;
                }
                case 3: {
                    builder.setBasedir(reader.getAttributeValue(i));
                    continue block11;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return builder;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 8: {
                            builder.addFilter(this.parseFilter(reader));
                            continue block12;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute implements XmlNameProvider
    {
        ADD_TO_MATCHING_LINE("add-to-matching-line"),
        ALL_MATCHES("all-matches"),
        ARTIFACT("artifact"),
        BASEDIR("basedir"),
        EXTRACT("extract"),
        FEATURE_PACK_PROPS("feature-pack-properties"),
        FEATURE_PACK_VERSION("feature-pack-version"),
        GROUP("group"),
        IF_EMPTY("if-empty"),
        IGNORE("ignore"),
        INCLUDE("include"),
        MATCH("match"),
        MODEL("model"),
        NAME("name"),
        OPTIONAL("optional"),
        ORIGIN("origin"),
        OUTPUT("output"),
        PATH("path"),
        PATTERN("pattern"),
        PHASE("phase"),
        RELATIVE_TO("relative-to"),
        RECURSIVE("recursive"),
        REPLACE_PROPERTIES("replace-props"),
        SHADED_MODEL_PACKAGE("shaded-model-package"),
        SRC("src"),
        STYLESHEET("stylesheet"),
        TARGET("target"),
        TO_LOCATION("to-location"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>(28);
            attributesMap.put(new QName(ADD_TO_MATCHING_LINE.getLocalName()), ADD_TO_MATCHING_LINE);
            attributesMap.put(new QName(ALL_MATCHES.getLocalName()), ALL_MATCHES);
            attributesMap.put(new QName(ARTIFACT.getLocalName()), ARTIFACT);
            attributesMap.put(new QName(BASEDIR.getLocalName()), BASEDIR);
            attributesMap.put(new QName(EXTRACT.getLocalName()), EXTRACT);
            attributesMap.put(new QName(FEATURE_PACK_PROPS.getLocalName()), FEATURE_PACK_PROPS);
            attributesMap.put(new QName(FEATURE_PACK_VERSION.getLocalName()), FEATURE_PACK_VERSION);
            attributesMap.put(new QName(GROUP.getLocalName()), GROUP);
            attributesMap.put(new QName(IF_EMPTY.getLocalName()), IF_EMPTY);
            attributesMap.put(new QName(IGNORE.getLocalName()), IGNORE);
            attributesMap.put(new QName(INCLUDE.getLocalName()), INCLUDE);
            attributesMap.put(new QName(MATCH.getLocalName()), MATCH);
            attributesMap.put(new QName(MODEL.getLocalName()), MODEL);
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributesMap.put(new QName(ORIGIN.getLocalName()), ORIGIN);
            attributesMap.put(new QName(OPTIONAL.getLocalName()), OPTIONAL);
            attributesMap.put(new QName(OUTPUT.getLocalName()), OUTPUT);
            attributesMap.put(new QName(PATH.getLocalName()), PATH);
            attributesMap.put(new QName(PATTERN.getLocalName()), PATTERN);
            attributesMap.put(new QName(PHASE.getLocalName()), PHASE);
            attributesMap.put(new QName(RECURSIVE.getLocalName()), RECURSIVE);
            attributesMap.put(new QName(RELATIVE_TO.getLocalName()), RELATIVE_TO);
            attributesMap.put(new QName(REPLACE_PROPERTIES.getLocalName()), REPLACE_PROPERTIES);
            attributesMap.put(new QName(SHADED_MODEL_PACKAGE.getLocalName()), SHADED_MODEL_PACKAGE);
            attributesMap.put(new QName(SRC.getLocalName()), SRC);
            attributesMap.put(new QName(STYLESHEET.getLocalName()), STYLESHEET);
            attributesMap.put(new QName(TARGET.getLocalName()), TARGET);
            attributesMap.put(new QName(TO_LOCATION.getLocalName()), TO_LOCATION);
            attributesMap.put(new QName(VALUE.getLocalName()), VALUE);
            attributes = attributesMap;
        }
    }

    static enum Element {
        CONFIG("config"),
        COPY_ARTIFACT("copy-artifact"),
        ASSEMBLE_SHADED_ARTIFACT("assemble-shaded-artifact"),
        COPY_PATH("copy-path"),
        DELETE("delete"),
        EXAMPLE_CONFIGS("example-configs"),
        FILE_APPENDER("append-file"),
        FILE_PERMISSIONS("file-permissions"),
        FILTER("filter"),
        LINE("line"),
        LINE_ENDINGS("line-endings"),
        MKDIR("mkdir"),
        PARAM("param"),
        PARAMS("params"),
        PERMISSION("permission"),
        TASKS("tasks"),
        TRANSFORM("transform"),
        UNIX("unix"),
        WINDOWS("windows"),
        XML_MERGE("xml-merge"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>(19);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", ASSEMBLE_SHADED_ARTIFACT.getLocalName()), ASSEMBLE_SHADED_ARTIFACT);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", COPY_ARTIFACT.getLocalName()), COPY_ARTIFACT);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", COPY_PATH.getLocalName()), COPY_PATH);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", DELETE.getLocalName()), DELETE);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", EXAMPLE_CONFIGS.getLocalName()), EXAMPLE_CONFIGS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", FILE_APPENDER.getLocalName()), FILE_APPENDER);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", FILE_PERMISSIONS.getLocalName()), FILE_PERMISSIONS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", FILTER.getLocalName()), FILTER);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", LINE.getLocalName()), LINE);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", LINE_ENDINGS.getLocalName()), LINE_ENDINGS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", MKDIR.getLocalName()), MKDIR);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", PARAM.getLocalName()), PARAM);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", PARAMS.getLocalName()), PARAMS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", PERMISSION.getLocalName()), PERMISSION);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", TASKS.getLocalName()), TASKS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", TRANSFORM.getLocalName()), TRANSFORM);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", UNIX.getLocalName()), UNIX);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", WINDOWS.getLocalName()), WINDOWS);
            elementsMap.put(new QName("urn:wildfly:wildfly-feature-pack-tasks:3.2", XML_MERGE.getLocalName()), XML_MERGE);
            elements = elementsMap;
        }
    }
}

