/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.arquillian.apache.surefire.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.wildfly.glow.plugin.arquillian.apache.surefire.util.ScanResult;
import org.wildfly.glow.plugin.arquillian.apache.surefire.util.ScannerFilter;
import org.wildfly.glow.plugin.arquillian.apache.surefire.util.TestsToRun;

public class DefaultScanResult
implements ScanResult {
    private final List<String> classes;
    private static final String SCAN_RESULT_NUMBER = "tc.";

    public DefaultScanResult(List<String> classes) {
        this.classes = Collections.unmodifiableList(classes);
    }

    @Override
    public int size() {
        return this.classes.size();
    }

    @Override
    public String getClassName(int index) {
        return this.classes.get(index);
    }

    @Override
    public void writeTo(Map<String, String> properties) {
        int size = this.classes.size();
        for (int i = 0; i < size; ++i) {
            properties.put(SCAN_RESULT_NUMBER + i, this.classes.get(i));
        }
    }

    public static DefaultScanResult from(Map<String, String> properties) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        String item;
        while ((item = properties.get(SCAN_RESULT_NUMBER + i++)) != null) {
            result.add(item);
        }
        return new DefaultScanResult(result);
    }

    public boolean isEmpty() {
        return this.classes.isEmpty();
    }

    public List<String> getClasses() {
        return this.classes;
    }

    @Override
    public TestsToRun applyFilter(ScannerFilter scannerFilter, ClassLoader testClassLoader) {
        LinkedHashSet result = new LinkedHashSet();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String className = this.getClassName(i);
            Class<?> testClass = DefaultScanResult.loadClass(testClassLoader, className);
            if (scannerFilter != null && !scannerFilter.accept(testClass)) continue;
            result.add(testClass);
        }
        return new TestsToRun(result);
    }

    @Override
    public List<Class<?>> getClassesSkippedByValidation(ScannerFilter scannerFilter, ClassLoader testClassLoader) {
        ArrayList result = new ArrayList();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String className = this.getClassName(i);
            Class<?> testClass = DefaultScanResult.loadClass(testClassLoader, className);
            if (scannerFilter == null || scannerFilter.accept(testClass)) continue;
            result.add(testClass);
        }
        return result;
    }

    private static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to create test class '" + className + "'", e);
        }
    }

    public DefaultScanResult append(DefaultScanResult other) {
        if (other != null) {
            ArrayList<String> src = new ArrayList<String>(this.classes);
            src.addAll(other.classes);
            return new DefaultScanResult(src);
        }
        return this;
    }
}

