/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public class MavenProxySelector
implements ProxySelector {
    private final List<Pattern> nonProxyHosts;
    private final Proxy proxy;

    MavenProxySelector(String host, int port, String protocol, String userName, String password, List<Pattern> nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
        if (userName != null && password != null) {
            AuthenticationBuilder builder = new AuthenticationBuilder();
            builder.addPassword(password);
            builder.addUsername(userName);
            this.proxy = new Proxy(protocol, host, port, builder.build());
        } else {
            this.proxy = new Proxy(protocol, host, port);
        }
    }

    public Proxy getProxy(RemoteRepository repo) {
        return this.proxyFor(repo.getHost()) ? this.proxy : null;
    }

    public boolean proxyFor(String host) {
        boolean match = false;
        for (Pattern p : this.nonProxyHosts) {
            if (!p.matcher(host).matches()) continue;
            match = true;
            break;
        }
        return !match;
    }

    static class Builder {
        private String userName;
        private String password;
        private final String host;
        private final int port;
        private final String protocol;
        private final List<Pattern> nonProxyHosts = new ArrayList<Pattern>();

        Builder(String host, int port, String protocol) {
            this.host = host;
            this.port = port;
            this.protocol = protocol;
        }

        Builder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        Builder addNonProxyHosts(List<String> lst) {
            for (String h : lst) {
                h = h.replaceAll("\\*", ".*");
                this.nonProxyHosts.add(Pattern.compile(h));
            }
            return this;
        }

        MavenProxySelector build() {
            return new MavenProxySelector(this.host, this.port, this.protocol, this.userName, this.password, this.nonProxyHosts);
        }
    }
}

