/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate.cache;

import java.io.IOException;
import java.util.Objects;
import java.util.OptionalInt;
import org.hibernate.cache.internal.CacheKeyImplementation;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class CacheKeyImplementationMarshaller
implements ProtoStreamMarshaller<CacheKeyImplementation> {
    private static final int ID_INDEX = 1;
    private static final int ENTITY_INDEX = 2;
    private static final int TENANT_INDEX = 3;
    private static final int HASH_CODE_INDEX = 4;

    public Class<? extends CacheKeyImplementation> getJavaClass() {
        return CacheKeyImplementation.class;
    }

    public CacheKeyImplementation readFrom(ProtoStreamReader reader) throws IOException {
        Object id = null;
        String entity = null;
        String tenant = null;
        OptionalInt hashCode = OptionalInt.empty();
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    id = reader.readAny();
                    continue block6;
                }
                case 2: {
                    entity = reader.readString();
                    continue block6;
                }
                case 3: {
                    tenant = reader.readString();
                    continue block6;
                }
                case 4: {
                    hashCode = OptionalInt.of(reader.readSFixed32());
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        return new CacheKeyImplementation(id, entity, tenant, hashCode.orElse(Objects.hashCode(id)));
    }

    public void writeTo(ProtoStreamWriter writer, CacheKeyImplementation key) throws IOException {
        int hashCode;
        String tenant;
        String entity;
        Object id = key.getId();
        if (id != null) {
            writer.writeAny(1, id);
        }
        if ((entity = key.getEntityOrRoleName()) != null) {
            writer.writeString(2, entity);
        }
        if ((tenant = key.getTenantId()) != null) {
            writer.writeString(3, tenant);
        }
        if ((hashCode = key.hashCode()) != Objects.hashCode(id)) {
            writer.writeSFixed32(4, hashCode);
        }
    }
}

