/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.wildfly.core.launcher.Arguments;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Environment;
import org.wildfly.core.launcher.Jvm;
import org.wildfly.core.launcher.logger.LauncherMessages;

public class JBossModulesCommandBuilder
implements CommandBuilder {
    static final String[] DEFAULT_VM_ARGUMENTS = new String[]{"-Xms64m", "-Xmx512m", "-Djava.net.preferIPv4Stack=true", "-Djava.awt.headless=true", "-Djboss.modules.system.pkgs=org.jboss.byteman"};
    static final Collection<String> DEFAULT_MODULAR_VM_ARGUMENTS;
    static final Collection<String> OPTIONAL_DEFAULT_MODULAR_VM_ARGUMENTS;
    private static final String ALLOW_VALUE = "allow";
    private static final String DISALLOW_VALUE = "disallow";
    static final String SECURITY_MANAGER_ARG = "-secmgr";
    static final String SECURITY_MANAGER_PROP = "java.security.manager";
    static final String SECURITY_MANAGER_PROP_WITH_ALLOW_VALUE = "-Djava.security.manager=allow";
    final Environment environment;
    final Arguments serverArgs;
    final Arguments javaOpts;
    private final String moduleName;
    private String modulesLocklessArg;
    private String modulesMetricsArg;
    private boolean useSecMgr;
    private boolean addModuleAgent;
    private final Collection<String> moduleOpts;

    protected JBossModulesCommandBuilder(Path wildflyHome, String moduleName) {
        this(wildflyHome, null, moduleName);
    }

    JBossModulesCommandBuilder(Path wildflyHome, Jvm jvm, String moduleName) {
        if (wildflyHome == null) {
            throw LauncherMessages.MESSAGES.nullParam("wildflyHome");
        }
        if (moduleName == null) {
            throw LauncherMessages.MESSAGES.nullParam("moduleName");
        }
        this.environment = new Environment(wildflyHome).setJvm(jvm);
        this.serverArgs = new Arguments();
        this.moduleName = moduleName;
        this.javaOpts = new Arguments();
        this.moduleOpts = new ArrayList<String>();
        this.addModuleAgent = false;
    }

    public static JBossModulesCommandBuilder of(Path wildflyHome, String moduleName) {
        if (moduleName == null) {
            throw LauncherMessages.MESSAGES.nullParam("moduleName");
        }
        return new JBossModulesCommandBuilder(Environment.validateWildFlyDir(wildflyHome), moduleName);
    }

    public static JBossModulesCommandBuilder of(String wildflyHome, String moduleName) {
        if (moduleName == null) {
            throw LauncherMessages.MESSAGES.nullParam("moduleName");
        }
        return new JBossModulesCommandBuilder(Environment.validateWildFlyDir(wildflyHome), moduleName);
    }

    public JBossModulesCommandBuilder setUseSecurityManager(boolean useSecMgr) {
        if (this.environment.getJvm().isSecurityManagerSupported()) {
            this.useSecMgr = useSecMgr;
            return this;
        }
        throw LauncherMessages.MESSAGES.securityManagerNotSupported(this.environment.getJvm().getPath());
    }

    public boolean useSecurityManager() {
        return this.useSecMgr;
    }

    public JBossModulesCommandBuilder addModuleDir(String moduleDir) {
        this.environment.addModuleDir(moduleDir);
        return this;
    }

    public JBossModulesCommandBuilder addModuleDirs(String ... moduleDirs) {
        this.environment.addModuleDirs(moduleDirs);
        return this;
    }

    public JBossModulesCommandBuilder addModuleDirs(Iterable<String> moduleDirs) {
        this.environment.addModuleDirs(moduleDirs);
        return this;
    }

    public JBossModulesCommandBuilder setModuleDirs(Iterable<String> moduleDirs) {
        this.environment.setModuleDirs(moduleDirs);
        return this;
    }

    public JBossModulesCommandBuilder setModuleDirs(String ... moduleDirs) {
        this.environment.setModuleDirs(moduleDirs);
        return this;
    }

    public String getModulePaths() {
        return this.environment.getModulePaths();
    }

    public JBossModulesCommandBuilder addServerArgument(String arg) {
        Arguments.Argument argument;
        if (arg != null && this.addServerArgument(argument = Arguments.parse(arg))) {
            if (SECURITY_MANAGER_ARG.equals(arg)) {
                this.setUseSecurityManager(true);
            } else {
                this.serverArgs.add(argument);
            }
        }
        return this;
    }

    public JBossModulesCommandBuilder addServerArguments(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.addServerArgument(arg);
            }
        }
        return this;
    }

    public JBossModulesCommandBuilder addServerArguments(Iterable<String> args) {
        if (args != null) {
            for (String arg : args) {
                this.addServerArgument(arg);
            }
        }
        return this;
    }

    public Path getWildFlyHome() {
        return this.environment.getWildflyHome();
    }

    public Path getJavaHome() {
        return this.environment.getWildflyHome();
    }

    public String getModulesJarName() {
        return this.environment.getModuleJar().toString();
    }

    public List<String> getServerArguments() {
        return this.serverArgs.asList();
    }

    public JBossModulesCommandBuilder addJavaOption(String jvmArg) {
        if (jvmArg != null && !jvmArg.isBlank()) {
            Arguments.Argument argument = Arguments.parse(jvmArg);
            if (argument.getKey().equals(SECURITY_MANAGER_PROP)) {
                this.setUseSecurityManager(JBossModulesCommandBuilder.isJavaSecurityManagerConfigured(argument));
            } else {
                this.javaOpts.add(argument);
            }
        }
        return this;
    }

    public JBossModulesCommandBuilder addJavaOptions(String ... javaOpts) {
        if (javaOpts != null) {
            for (String javaOpt : javaOpts) {
                this.addJavaOption(javaOpt);
            }
        }
        return this;
    }

    public JBossModulesCommandBuilder addJavaOptions(Iterable<String> javaOpts) {
        if (javaOpts != null) {
            for (String javaOpt : javaOpts) {
                this.addJavaOption(javaOpt);
            }
        }
        return this;
    }

    public JBossModulesCommandBuilder setJavaOptions(Iterable<String> javaOpts) {
        this.javaOpts.clear();
        return this.addJavaOptions(javaOpts);
    }

    public JBossModulesCommandBuilder setJavaOptions(String ... javaOpts) {
        this.javaOpts.clear();
        return this.addJavaOptions(javaOpts);
    }

    public List<String> getJavaOptions() {
        return this.javaOpts.asList();
    }

    public JBossModulesCommandBuilder addModuleOption(String arg) {
        if (arg != null) {
            if (arg.startsWith("-javaagent:")) {
                this.addModuleAgent = true;
            } else {
                if ("-mp".equals(arg) || "--modulepath".equals(arg)) {
                    throw LauncherMessages.MESSAGES.invalidArgument(arg, "addModuleOption");
                }
                if (SECURITY_MANAGER_ARG.equals(arg)) {
                    throw LauncherMessages.MESSAGES.invalidArgument(arg, "setUseSecurityManager");
                }
            }
            this.moduleOpts.add(arg);
        }
        return this;
    }

    public JBossModulesCommandBuilder addModuleOptions(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.addModuleOption(arg);
            }
        }
        return this;
    }

    public JBossModulesCommandBuilder addModuleOptions(Iterable<String> args) {
        if (args != null) {
            for (String arg : args) {
                this.addModuleOption(arg);
            }
        }
        return this;
    }

    public JBossModulesCommandBuilder setModuleOptions(String ... args) {
        this.moduleOpts.clear();
        this.addModuleOptions(args);
        return this;
    }

    public JBossModulesCommandBuilder setModuleOptions(Iterable<String> args) {
        this.moduleOpts.clear();
        this.addModuleOptions(args);
        return this;
    }

    public JBossModulesCommandBuilder setJavaHome(String javaHome) {
        this.environment.setJvm(Jvm.of(javaHome));
        return this;
    }

    public JBossModulesCommandBuilder setJavaHome(Path javaHome) {
        this.environment.setJvm(Jvm.of(javaHome));
        return this;
    }

    public JBossModulesCommandBuilder setModulesLockless(boolean b) {
        this.modulesLocklessArg = b ? "-Djboss.modules.lockless=true" : null;
        return this;
    }

    public JBossModulesCommandBuilder setModulesMetrics(boolean b) {
        this.modulesMetricsArg = b ? "-Djboss.modules.metrics=true" : null;
        return this;
    }

    @Override
    public List<String> buildArguments() {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.addModuleAgent) {
            cmd.add("-javaagent:" + this.getModulesJarName());
        }
        cmd.addAll(this.getJavaOptions());
        cmd.addAll(DEFAULT_MODULAR_VM_ARGUMENTS);
        for (String optionalModularArgument : OPTIONAL_DEFAULT_MODULAR_VM_ARGUMENTS) {
            if (!Jvm.isPackageAvailable(this.environment.getJvm().getPath(), optionalModularArgument)) continue;
            cmd.add(optionalModularArgument);
        }
        if (this.environment.getJvm().enhancedSecurityManagerAvailable()) {
            cmd.add(SECURITY_MANAGER_PROP_WITH_ALLOW_VALUE);
        }
        if (this.modulesLocklessArg != null) {
            cmd.add(this.modulesLocklessArg);
        }
        if (this.modulesMetricsArg != null) {
            cmd.add(this.modulesMetricsArg);
        }
        cmd.add("-jar");
        cmd.add(this.getModulesJarName());
        if (this.useSecurityManager()) {
            cmd.add(SECURITY_MANAGER_ARG);
        }
        cmd.addAll(this.moduleOpts);
        cmd.add("-mp");
        cmd.add(this.getModulePaths());
        cmd.add(this.moduleName);
        cmd.addAll(this.getServerArguments());
        return cmd;
    }

    @Override
    public List<String> build() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.environment.getJvm().getCommand());
        cmd.addAll(this.buildArguments());
        return cmd;
    }

    protected void setSingleServerArg(String key, String value) {
        this.serverArgs.set(key, value);
    }

    protected void addServerArg(String key, String value) {
        this.serverArgs.add(key, value);
    }

    protected String getServerArg(String key) {
        return this.serverArgs.get(key);
    }

    boolean addServerArgument(Arguments.Argument argument) {
        return true;
    }

    static boolean isJavaSecurityManagerConfigured(Arguments.Argument argument) {
        return !ALLOW_VALUE.equals(argument.getValue()) && !DISALLOW_VALUE.equals(argument.getValue());
    }

    static {
        boolean skipJPMSOptions = Boolean.getBoolean("launcher.skip.jpms.properties");
        List<String> modularJavaOpts = !skipJPMSOptions ? List.of("--add-exports=java.desktop/sun.awt=ALL-UNNAMED", "--add-exports=java.naming/com.sun.jndi.ldap=ALL-UNNAMED", "--add-exports=java.naming/com.sun.jndi.url.ldap=ALL-UNNAMED", "--add-exports=java.naming/com.sun.jndi.url.ldaps=ALL-UNNAMED", "--add-exports=jdk.naming.dns/com.sun.jndi.dns=ALL-UNNAMED", "--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-opens=java.base/java.lang.invoke=ALL-UNNAMED", "--add-opens=java.base/java.lang.reflect=ALL-UNNAMED", "--add-opens=java.base/java.io=ALL-UNNAMED", "--add-opens=java.base/java.net=ALL-UNNAMED", "--add-opens=java.base/java.security=ALL-UNNAMED", "--add-opens=java.base/java.util=ALL-UNNAMED", "--add-opens=java.base/java.util.concurrent=ALL-UNNAMED", "--add-opens=java.management/javax.management=ALL-UNNAMED", "--add-opens=java.naming/javax.naming=ALL-UNNAMED", "--add-modules=java.se") : List.of();
        DEFAULT_MODULAR_VM_ARGUMENTS = modularJavaOpts;
        List<Object> optionalModularJavaOpts = !skipJPMSOptions ? List.of("--add-opens=java.base/com.sun.net.ssl.internal.ssl=ALL-UNNAMED") : List.of();
        OPTIONAL_DEFAULT_MODULAR_VM_ARGUMENTS = optionalModularJavaOpts;
    }
}

