/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.legacy.util;

import java.io.File;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.legacy.util.Tools;

public class GrabModelVersionsUtil {
    public static void main(String[] args) throws Exception {
        ModelNode versions = Tools.getCurrentModelVersions();
        System.out.println("<table border=\"1\">");
        System.out.println("<tr><th>Subsystem</th><th>Management Version</th><th>Schemas</th></tr>");
        System.out.print("<tr valign=\"top\" align=\"left\"><td><b>Standalone core</b></td><td>");
        System.out.print(Tools.createModelVersion(versions.get(new String[]{"core", "standalone"})));
        System.out.println("</td><td>&nbsp;</td></tr>");
        for (Property entry : versions.get("subsystem").asPropertyList()) {
            System.out.print("<tr valign=\"top\" align=\"left\"><td><b>");
            System.out.print(entry.getName());
            System.out.print("</b></td><td>");
            System.out.print(Tools.createModelVersion(entry.getValue()));
            System.out.print("<td>");
            boolean first = true;
            for (ModelNode ns : entry.getValue().get("xml-namespaces").asList()) {
                if (first) {
                    first = false;
                } else {
                    System.out.println("<br/>");
                }
                System.out.print(ns.asString());
            }
            System.out.print("</td>");
            System.out.println("</td></tr>");
        }
        System.out.println("</table>");
        System.out.println("----------------");
        File projectDir = Tools.getProjectDirectory();
        File target = new File(projectDir, "target");
        File file = new File(target, "standalone-model-versions-running.dmr");
        Tools.serializeModeNodeToFile(versions, file);
    }
}

