/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import dk.nykredit.jackson.dataformat.hal.HALLink;
import dk.nykredit.jackson.dataformat.hal.annotation.Link;
import dk.nykredit.jackson.dataformat.hal.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.TagDeserializer;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.ValueWrapper;

@Resource
@JsonDeserialize(using=TagDeserializer.class)
public class Tag {
    @Link
    private HALLink self;
    @Link
    private HALLink type;
    private List<ValueWrapper> uuid;
    private String lang;
    private String name;

    public Tag(String uuid, String tid) {
        this(uuid, tid, "en");
    }

    public Tag(String uuid, String tid, String lang, String name) {
        this(uuid, tid, lang);
        this.name = name;
    }

    public Tag(String uuid, String tid, String lang) {
        this.lang = lang;
        this.uuid = Collections.singletonList(new ValueWrapper(uuid));
        this.self = new HALLink.Builder(String.format("%%drupalLocation%%/taxonomy/term/%s?_format=hal_json", tid)).build();
        this.type = new HALLink.Builder("%drupalLocation%/rest/type/taxonomy_term/tags").build();
    }

    public HALLink getSelf() {
        return this.self;
    }

    public HALLink getType() {
        return this.type;
    }

    public List<ValueWrapper> getUuid() {
        return new ArrayList<ValueWrapper>(this.uuid);
    }

    public void addUuid(String uuid) {
        this.uuid.add(new ValueWrapper(uuid));
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Tag{uuid=" + this.uuid.get(0).getValue().toString() + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.getUuid().get(0).getValue(), tag.getUuid().get(0).getValue()) && Objects.equals(this.getName(), tag.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getUuid().get(0).getValue(), this.getName());
    }
}

