/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.CodingResourceGenerator;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.DrupalCommunication;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.SitemapEntry;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.CodingResource;

@Mojo(name="drupal-push", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class DrupalPushMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}", required=true, property="rootDirectory")
    private File rootDirectory;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="", readonly=true, required=true)
    private String drupalUrl;
    @Parameter(defaultValue="quickstart", readonly=true)
    private String resourceType;
    @Parameter(required=true, readonly=true)
    private String serverName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (Objects.isNull(this.project) || Objects.isNull(this.project.getVersion()) || Objects.isNull(this.rootDirectory) || Objects.isNull(this.settings) || Objects.isNull(this.serverName) || Objects.isNull(this.settings.getServer(this.serverName)) || Objects.isNull(this.resourceType) || Objects.isNull(this.drupalUrl)) {
            throw new MojoExecutionException("Missing required arguments, please consult the README");
        }
        Server drupal = this.settings.getServer(this.serverName);
        DrupalCommunication drupalCommunication = new DrupalCommunication(drupal.getUsername(), drupal.getPassword(), this.drupalUrl, this.getLog());
        List<String> ignoredDirs = Arrays.asList("target", "dist", "template", "guide");
        try {
            ((Stream)Files.find(this.rootDirectory.toPath(), 2, (path, attributes) -> path.getFileName().endsWith("README.adoc") && !path.getParent().equals(this.rootDirectory.toPath()) && !ignoredDirs.contains(path.getParent().getFileName().toString()), new FileVisitOption[0]).parallel()).forEach(path -> {
                this.getLog().debug((CharSequence)("Processing files at " + path.getParent()));
                CodingResource resource = new CodingResourceGenerator(drupalCommunication, this.getLog()).createResource(path.getParent(), this.resourceType);
                resource.addVersion(this.project.getVersion());
                List<SitemapEntry> entries = drupalCommunication.getEntriesOfType(this.resourceType);
                SitemapEntry testEntry = new SitemapEntry(resource.getPathValue());
                if (entries.contains(testEntry)) {
                    SitemapEntry entry = entries.get(entries.indexOf(testEntry));
                    if (entry.getLastmod().isBefore(Instant.ofEpochMilli(path.toFile().lastModified()))) {
                        boolean success = drupalCommunication.updateCodingResource(resource);
                        if (success) {
                            this.getLog().info((CharSequence)("Successful update to " + resource.getPathValue()));
                        } else {
                            this.getLog().warn((CharSequence)("Was not able to update " + resource.getPathValue() + ". Consult log."));
                        }
                    } else {
                        this.getLog().debug((CharSequence)"not modified");
                    }
                } else {
                    boolean success = drupalCommunication.postNewCodingResource(resource);
                    if (success) {
                        this.getLog().info((CharSequence)("Successful creation of " + resource.getPathValue()));
                    } else {
                        this.getLog().warn((CharSequence)("Was not able to create " + resource.getPathValue() + ". Consult log."));
                    }
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not send coding resources to Drupal.", (Exception)e);
        }
    }
}

