/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.nio.ByteBuffer;
import org.wildfly.common.Assert;
import org.wildfly.openssl.util.DirectByteBufferDeallocator;

public class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    public static ByteBuffer expand(ByteBuffer in) {
        return ByteBufferUtils.expand(in, in.capacity() * 2);
    }

    public static ByteBuffer expand(ByteBuffer in, int newSize) {
        ByteBuffer out;
        Assert.checkNotNullParam("in", in);
        Assert.checkMinimumParameter("newSize", 0, newSize);
        if (in.capacity() >= newSize) {
            return in;
        }
        boolean direct = false;
        if (in.isDirect()) {
            out = ByteBuffer.allocateDirect(newSize);
            direct = true;
        } else {
            out = ByteBuffer.allocate(newSize);
        }
        in.flip();
        out.put(in);
        if (direct) {
            ByteBufferUtils.cleanDirectBuffer(in);
        }
        return out;
    }

    public static void cleanDirectBuffer(ByteBuffer buf) {
        DirectByteBufferDeallocator.free(buf);
    }
}

