/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.componentmatrix;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;

public class DependencyId
implements Comparable<DependencyId> {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String classifier;
    private final String scope;

    public DependencyId(Artifact artifact) {
        this.groupId = artifact.getGroupId();
        this.artifactId = artifact.getArtifactId();
        this.type = artifact.getType();
        this.classifier = artifact.getClassifier();
        this.scope = artifact.getScope();
    }

    public DependencyId(Dependency dependency) {
        this.groupId = dependency.getGroupId();
        this.artifactId = dependency.getArtifactId();
        this.type = dependency.getType();
        this.classifier = dependency.getClassifier();
        this.scope = dependency.getScope();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyId that = (DependencyId)o;
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(that.classifier) : that.classifier != null) {
            return false;
        }
        return this.scope != null ? this.scope.equals(that.scope) : that.scope == null;
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(DependencyId o) {
        int curr = this.groupId.compareTo(o.groupId);
        if (curr != 0) {
            return curr;
        }
        curr = this.artifactId.compareTo(o.artifactId);
        if (curr != 0) {
            return curr;
        }
        curr = this.compareNullable(this.type, o.type);
        if (curr != 0) {
            return curr;
        }
        curr = this.compareNullable(this.classifier, o.classifier);
        if (curr != 0) {
            return curr;
        }
        curr = this.compareNullable(this.scope, o.scope);
        if (curr != 0) {
            return curr;
        }
        return 0;
    }

    private int compareNullable(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        if (a == null && b != null) {
            return 1;
        }
        if (a != null && b == null) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.groupId + ":" + this.artifactId);
        sb.append(":");
        if (this.type != null) {
            sb.append(this.type);
        }
        sb.append(":");
        if (this.classifier != null) {
            sb.append(this.classifier);
        }
        sb.append(":");
        if (this.scope != null) {
            sb.append(this.scope);
        }
        return sb.toString();
    }
}

