/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins;

import java.io.File;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.wildfly.plugins.Insert;
import org.wildfly.plugins.JBossModule;
import org.wildfly.plugins.RegisterExtension;
import org.wildfly.plugins.RegisterOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="deploy", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyCollection=ResolutionScope.COMPILE)
public class DeployExtensionMojo
extends AbstractMojo {
    @Parameter
    private File moduleZip;
    @Parameter
    private String artifact;
    @Parameter(defaultValue="${jboss.home}", required=true)
    private File jbossHome;
    @Parameter(defaultValue="modules/system/layers/base")
    private String modulesHome;
    @Parameter(defaultValue="standalone/configuration/standalone.xml")
    private String serverConfig;
    @Parameter(defaultValue="standalone/configuration/standalone.xml.old")
    private String serverConfigBackup;
    @Parameter
    private File subsystem;
    @Parameter
    private File socketBinding;
    @Parameter
    private String[] socketBindingGroups = new String[]{"standard-sockets"};
    @Parameter
    private Insert[] edit;
    @Parameter
    private boolean failNoMatch;
    @Parameter(defaultValue="false")
    private boolean skipDeploy;
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private MojoExecution mojoExecution;
    private File serverConfigAbsolute;
    private File serverConfigBackupAbsolute;
    private File modulesHomeAbsolute;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipDeploy) {
            this.getLog().info((CharSequence)"Skipped execution");
            return;
        }
        this.validConfiguration();
        if (this.artifact != null) {
            this.moduleZip = this.resolveArtifactModuleZip();
        }
        JBossModule module = null;
        RegisterOptions resolvedOptions = new RegisterOptions();
        if (this.moduleZip != null) {
            try {
                module = JBossModule.readFromZipFile(this.getLog(), this.moduleZip);
            }
            catch (Exception e) {
                throw new MojoFailureException("Failed to read module : " + e.getMessage());
            }
            try {
                List<File> installedFiles = module.installTo(this.modulesHomeAbsolute);
                resolvedOptions = this.resolveBundledXmlSnippets(installedFiles);
            }
            catch (Exception e) {
                throw new MojoFailureException("Failed to install module : " + e.getMessage());
            }
        }
        try {
            RegisterOptions options = new RegisterOptions();
            if (module != null) {
                options.withExtension(module.getModuleId());
            }
            options.serverConfig(this.serverConfigAbsolute).serverConfigBackup(this.serverConfigBackupAbsolute).subsystem(this.subsystem).socketBinding(this.socketBinding).socketBindingGroups(this.socketBindingGroups).inserts(this.edit).failNoMatch(this.failNoMatch);
            resolvedOptions.extend(options);
            this.getLog().debug((CharSequence)("Proceeding with \n" + resolvedOptions));
            this.register(resolvedOptions);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException("Failed to update server configuration file : " + e.getMessage());
        }
    }

    private RegisterOptions resolveBundledXmlSnippets(List<File> installedFiles) {
        RegisterOptions options = new RegisterOptions();
        for (File file : installedFiles) {
            if ("subsystem-snippet.xml".equals(file.getName())) {
                this.getLog().debug((CharSequence)("Found packaged subsystem snippet " + file.getAbsolutePath()));
                options.subsystem(file);
            }
            if (!"socket-binding-snippet.xml".equals(file.getName())) continue;
            this.getLog().debug((CharSequence)("Found packaged socket-binding snippet " + file.getAbsolutePath()));
            options.socketBinding(file);
        }
        return options;
    }

    private File resolveArtifactModuleZip() throws MojoExecutionException {
        if (this.artifact == null) {
            return null;
        }
        this.getLog().info((CharSequence)("Invoking maven-dependency-plugin:copy to pull " + this.artifact));
        String gav = String.valueOf(this.artifact);
        String tmpOutputDir = "${project.build.directory}/tmp/wildfly-extension-plugin";
        String[] pieces = gav.split(":");
        String moduleTempFile = pieces[1];
        if (pieces.length > 3) {
            moduleTempFile = String.valueOf(moduleTempFile) + "." + pieces[3];
        } else {
            moduleTempFile = String.valueOf(moduleTempFile) + ".zip";
            gav = String.valueOf(gav) + ":zip:module";
        }
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.10")), (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)"${project.build.directory}/tmp/wildfly-extension-plugin"), MojoExecutor.element((String)MojoExecutor.name((String)"overWriteIfNewer"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"overWriteReleases"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"overWriteSnapshots"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"stripClassifier"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"stripVersion"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"artifact"), (String)gav)}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        moduleTempFile = String.valueOf(this.evalPluginParameterExpression("${project.build.directory}/tmp/wildfly-extension-plugin/" + moduleTempFile));
        return new File(moduleTempFile);
    }

    private Object evalPluginParameterExpression(String expression) {
        PluginParameterExpressionEvaluator evaluator = new PluginParameterExpressionEvaluator(this.mavenSession, this.mojoExecution);
        try {
            return evaluator.evaluate(expression);
        }
        catch (ExpressionEvaluationException e) {
            this.getLog().error((CharSequence)("Failed to evaluate [" + expression + "]"), (Throwable)e);
            return null;
        }
    }

    public void register(RegisterOptions options) throws Exception {
        File serverConfig = options.getServerConfig();
        this.getLog().info((CharSequence)("Backup original serverConfig [" + serverConfig.getAbsolutePath() + "] to [" + options.getServerConfigBackup().getAbsolutePath() + "]"));
        FileUtils.copyFile((File)serverConfig, (File)options.getServerConfigBackup());
        new RegisterExtension(this.getLog()).register(options);
    }

    private void validConfiguration() throws MojoFailureException {
        if (!(this.jbossHome.exists() && this.jbossHome.isDirectory() && this.jbossHome.canRead())) {
            throw new MojoFailureException("jbossHome = " + this.jbossHome.getAbsolutePath() + " is not readable and existing directory");
        }
        if (!new File(this.jbossHome, "modules").isDirectory()) {
            throw new MojoFailureException("jbossHome = " + this.jbossHome.getAbsolutePath() + " does not seem to point to AS7/WildFly installation dir");
        }
        this.serverConfigAbsolute = new File(this.serverConfig).isAbsolute() ? new File(this.serverConfig) : new File(this.jbossHome, this.serverConfig);
        if (!(this.serverConfigAbsolute.exists() && this.serverConfigAbsolute.isFile() && this.serverConfigAbsolute.canWrite())) {
            throw new MojoFailureException("serverConfig = " + this.serverConfig + " is not writable and existing file. [serverConfig] must be either absolute path or relative to [jbossHome]");
        }
        this.serverConfigBackupAbsolute = new File(this.serverConfigBackup).isAbsolute() ? new File(this.serverConfigBackup) : new File(this.jbossHome, this.serverConfigBackup);
        if (!(this.serverConfigBackupAbsolute.getParentFile().exists() && this.serverConfigAbsolute.getParentFile().isDirectory() && this.serverConfigAbsolute.getParentFile().canWrite())) {
            throw new MojoFailureException("serverConfigBackup = " + this.serverConfigBackup + " 's parent directory does not exist or is writable. [serverConfigBackup] must be either absolute path or relative to [jbossHome]");
        }
        if (this.modulesHome == null) {
            this.modulesHome = "";
        }
        this.modulesHomeAbsolute = new File(this.modulesHome).isAbsolute() ? new File(this.modulesHome) : new File(this.jbossHome, this.modulesHome);
        if (!(this.modulesHomeAbsolute.exists() && this.modulesHomeAbsolute.isDirectory() && this.modulesHomeAbsolute.canWrite())) {
            throw new MojoFailureException("modulesHome = " + this.modulesHome + " is not writable and existing directory. [modulesHome] must be either absolute path or relative to [jbossHome]");
        }
    }
}

