/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins;

import java.io.File;
import java.util.Arrays;
import org.wildfly.plugins.Insert;

public class RegisterOptions {
    private File serverConfig;
    private File serverConfigBackup;
    private File subsystem;
    private File socketBinding;
    private String[] socketBindingGroups;
    private Insert[] inserts;
    String[] removes;
    private String moduleId;
    private boolean failNoMatch;

    public String toString() {
        return "RegisterOptions: [" + ("\n  serverConfig = " + this.serverConfig) + ("\n  serverConfigBackup = " + this.serverConfigBackup) + ("\n  moduleId = " + this.moduleId) + ("\n  subsystem = " + this.subsystem) + ("\n  socket-binding = " + this.socketBinding) + ("\n  socketBindingGroups = " + Arrays.toString(this.socketBindingGroups)) + ("\n  edit = " + Arrays.toString(this.inserts)) + ("\n  failNoMatch = " + this.failNoMatch) + "\n]";
    }

    public RegisterOptions extend(RegisterOptions options) {
        this.serverConfig = options.serverConfig == null ? this.serverConfig : options.serverConfig;
        this.serverConfigBackup = options.serverConfigBackup == null ? this.serverConfigBackup : options.serverConfigBackup;
        this.subsystem = options.subsystem == null ? this.subsystem : options.subsystem;
        this.socketBinding = options.socketBinding == null ? this.socketBinding : options.socketBinding;
        this.socketBindingGroups = options.socketBindingGroups == null ? this.socketBindingGroups : options.socketBindingGroups;
        this.inserts = options.inserts == null ? this.inserts : options.inserts;
        this.removes = options.removes == null ? this.removes : options.removes;
        this.moduleId = options.moduleId == null ? this.moduleId : options.moduleId;
        this.failNoMatch = options.failNoMatch;
        return this;
    }

    public RegisterOptions failNoMatch(boolean failNoMatch) {
        this.failNoMatch = failNoMatch;
        return this;
    }

    public RegisterOptions withExtension(String moduleId) {
        this.moduleId = moduleId;
        return this;
    }

    public RegisterOptions serverConfigBackup(File serverConfigBackup) {
        this.serverConfigBackup = serverConfigBackup;
        return this;
    }

    public RegisterOptions serverConfig(File serverConfig) {
        this.serverConfig = serverConfig;
        return this;
    }

    public RegisterOptions subsystem(File subsystem) {
        this.subsystem = subsystem;
        return this;
    }

    public RegisterOptions socketBinding(File socketBinding) {
        this.socketBinding = socketBinding;
        return this;
    }

    public RegisterOptions socketBindingGroups(String[] socketBindingGroups) {
        this.socketBindingGroups = socketBindingGroups;
        return this;
    }

    public RegisterOptions inserts(Insert[] inserts) {
        this.inserts = inserts;
        return this;
    }

    public Insert[] getInserts() {
        if (this.inserts == null) {
            this.inserts = new Insert[0];
        }
        return this.inserts;
    }

    public RegisterOptions removes(String[] removes) {
        this.removes = removes;
        return this;
    }

    public String[] getRemoves() {
        if (this.removes == null) {
            this.removes = new String[0];
        }
        return this.removes;
    }

    public File getServerConfig() {
        return this.serverConfig;
    }

    public File getSocketBinding() {
        return this.socketBinding;
    }

    public File getSubsystem() {
        return this.subsystem;
    }

    public String[] getSocketBindingGroups() {
        return this.socketBindingGroups;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public File getServerConfigBackup() {
        return this.serverConfigBackup;
    }

    public boolean isFailNoMatch() {
        return this.failNoMatch;
    }
}

