/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.extensions.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.wildfly.core.jar.boot.Main;
import org.wildfly.core.jar.boot.RuntimeExtension;

public class CloudExtension
implements RuntimeExtension {
    private static final String OPENSHIFT_RESOURCE = "/openshift.properties";
    private static final String KUBERNETES_RESOURCE = "/kubernetes.properties";
    private static final String OPENSHIFT_HOST_NAME_ENV = "HOSTNAME";
    private static final String JBOSS_NODE_NAME_PROPERTY = "jboss.node.name";
    private static final Path JBOSS_CONTAINER_DIR = Paths.get("/opt/jboss/container", new String[0]);
    private static final Path JBOSS_CONTAINER_BOOTABLE_DIR = JBOSS_CONTAINER_DIR.resolve("wildfly-bootable-jar");
    private static final Path INSTALL_DIR_FILE = JBOSS_CONTAINER_BOOTABLE_DIR.resolve("install-dir");

    public void boot(List<String> args, Path installDir) throws Exception {
        String hostname = System.getenv(OPENSHIFT_HOST_NAME_ENV);
        this.doBoot(args, installDir, hostname);
    }

    void doBoot(List<String> args, Path installDir, String hostname) throws Exception {
        CloudExtension.handleCloud(args, installDir, hostname);
        if (Files.exists(JBOSS_CONTAINER_DIR, new LinkOption[0])) {
            try {
                if (!Files.exists(JBOSS_CONTAINER_BOOTABLE_DIR, new LinkOption[0])) {
                    Files.createDirectory(JBOSS_CONTAINER_BOOTABLE_DIR, new FileAttribute[0]);
                }
                Files.write(INSTALL_DIR_FILE, installDir.toString().getBytes(), StandardOpenOption.CREATE);
            }
            catch (IOException ex) {
                System.err.println("Warning, can't generate " + INSTALL_DIR_FILE + ". " + ex);
            }
        }
    }

    private static void handleCloud(List<String> args, Path installDir, String hostname) throws Exception {
        String value;
        Properties props;
        block30: {
            props = new Properties();
            try (InputStream wf = Main.class.getResourceAsStream(OPENSHIFT_RESOURCE);){
                boolean isOpenshift;
                if (wf != null) {
                    isOpenshift = true;
                    props.load(wf);
                    break block30;
                }
                try (Iterator<String> wf2 = Main.class.getResourceAsStream(KUBERNETES_RESOURCE);){
                    isOpenshift = false;
                    props.load((InputStream)((Object)wf2));
                }
            }
        }
        boolean hasJbossNodeName = false;
        HashSet<String> overridingProps = new HashSet<String>();
        for (String arg : args) {
            if (arg.startsWith("-Djboss.node.name=")) {
                hasJbossNodeName = true;
                continue;
            }
            if (!arg.startsWith("-D")) continue;
            String prop = null;
            int eq = arg.indexOf("=");
            prop = eq == -1 ? arg.substring(2) : arg.substring(2, eq);
            overridingProps.add(prop);
        }
        for (String p : props.stringPropertyNames()) {
            if (overridingProps.contains(p)) continue;
            args.add("-D" + p + "=" + props.getProperty(p));
        }
        if (!hasJbossNodeName && (value = System.getProperty(JBOSS_NODE_NAME_PROPERTY)) == null && hostname != null) {
            if (hostname.length() > 23) {
                String originalHostName = hostname;
                StringBuilder builder = new StringBuilder();
                builder.append(hostname.substring(0, 11));
                String suffix = hostname.substring(11);
                suffix = CloudExtension.checksum(suffix).substring(0, 12);
                builder.append(suffix);
                hostname = builder.toString();
                System.out.println("The HOSTNAME env variable used to set jboss.node.name islonger than 23 bytes. jboss.node.name value was adjusted to 23 bytes long string " + hostname + " from the original value " + originalHostName);
            }
            args.add("-Djboss.node.name=" + hostname);
        }
    }

    static String checksum(String value) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(value.getBytes());
        byte[] digest = md.digest();
        StringBuilder buffer = new StringBuilder(2 * digest.length);
        for (int i = 0; i < digest.length; ++i) {
            buffer.append(Character.forDigit(digest[i] >> 4 & 0xF, 16));
            buffer.append(Character.forDigit(digest[i] & 0xF, 16));
        }
        return buffer.toString().toUpperCase();
    }
}

