/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.wildfly.plugins.bootablejar.maven.common.Utils;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
public final class RunBootableJarMojo
extends AbstractMojo {
    @Parameter(alias="jvmArguments", property="wildfly.bootable.run.jvmArguments")
    public List<String> jvmArguments = new ArrayList<String>();
    @Parameter(alias="arguments", property="wildfly.bootable.run.arguments")
    public List<String> arguments = new ArrayList<String>();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="wildfly.bootable.run.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping run of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        Utils.startBootableJar(Utils.getBootableJarPath(this.project, "run"), this.jvmArguments, this.arguments, true, false, null, -1L);
    }
}

