/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.wildfly.core.launcher.BootableJarCommandBuilder;
import org.wildfly.plugins.bootablejar.maven.common.Utils;
import org.wildfly.plugins.bootablejar.maven.goals.BuildBootableJarMojo;

public abstract class AbstractDevBootableJarMojo
extends BuildBootableJarMojo {
    @Parameter(property="wildfly.bootable.jvmArguments")
    public List<String> jvmArguments = new ArrayList<String>();
    @Parameter(property="wildfly.bootable.arguments")
    public List<String> arguments = new ArrayList<String>();

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping run of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        this.configureServer();
        this.hollowJar = true;
        super.execute();
        this.doExecute();
    }

    protected abstract void configureServer();

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected BootableJarCommandBuilder buildCommandBuilder(boolean redirect) throws MojoExecutionException {
        BootableJarCommandBuilder builder = BootableJarCommandBuilder.of((String)Utils.getBootableJarPath(this.outputFileName, this.project, "dev")).addJavaOptions(this.jvmArguments).addServerArguments(this.arguments);
        if (redirect) {
            builder.addJavaOption("-Dorg.jboss.logmanager.nocolor=true");
        }
        return builder;
    }

    public void setJvmArguments(String jvmArguments) {
        this.jvmArguments = Utils.splitArguments(jvmArguments);
    }

    public void setArguments(String arguments) {
        this.arguments = Utils.splitArguments(arguments);
    }
}

