/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.nio.file.Path;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.galleon.config.ConfigId;
import org.wildfly.plugins.bootablejar.maven.cloud.CloudConfig;
import org.wildfly.plugins.bootablejar.maven.common.Utils;
import org.wildfly.plugins.bootablejar.maven.goals.AbstractBuildBootableJarMojo;

@Mojo(name="package", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class BuildBootableJarMojo
extends AbstractBuildBootableJarMojo {
    @Parameter(alias="cloud")
    CloudConfig cloud;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping run of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        super.execute();
    }

    @Override
    protected boolean updateManifest(Manifest manifest) {
        if (this.cloud != null) {
            return this.cloud.updateManifest(manifest);
        }
        return false;
    }

    @Override
    protected ConfigId willProvision(Utils.ProvisioningSpecifics specifics) throws MojoExecutionException {
        if (!this.isPackageDev() && this.cloud != null) {
            this.getLog().info((CharSequence)"Cloud support is enabled");
            this.cloud.validate();
            for (String layer : this.cloud.getExtraLayers(this, specifics.getHealthLayer(), this.getLog())) {
                this.addExtraLayer(layer);
            }
        }
        return specifics.getDefaultConfig(this.cloud != null);
    }

    @Override
    protected void configureCli(List<String> commands) {
        if (this.cloud != null) {
            try {
                this.cloud.addCLICommands(this, commands);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    protected void copyExtraContentInternal(Path wildflyDir, Path contentDir) throws Exception {
        if (this.cloud != null) {
            this.cloud.copyExtraContent(this, wildflyDir, contentDir);
        }
    }
}

