/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.ProjectBuildingException;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.plugins.bootablejar.maven.goals.CliSession;

class DevWatchContext {
    private static final Set<String> NO_DEPLOYMENT_WEB_FILE_EXTENSIONS = new HashSet<String>();
    private final Map<WatchKey, Path> watchedDirectories = new HashMap<WatchKey, Path>();
    private final Path webAppDir;
    private final Set<Path> resourceDirectories = new HashSet<Path>();
    private final Set<Path> compileRootDirectories;
    private final Set<Path> extraDirectories = new HashSet<Path>();
    private final Set<Path> cliFiles = new HashSet<Path>();
    private final Path pom;
    private final WatchService watcher;
    private final Path projectBuildDir;
    private final Path artifactFile;
    private final boolean isWebApp;
    private final boolean isJarApp;
    private final String fileName;
    private final Path targetDir;
    private final ProjectContext ctx;

    DevWatchContext(ProjectContext ctx, WatchService watcher) throws IOException, MojoExecutionException {
        Object p;
        this.watcher = watcher;
        this.ctx = ctx;
        this.projectBuildDir = ctx.getProjectBuildDir();
        Path mainDir = ctx.getSourceDir().resolve("main");
        this.compileRootDirectories = ctx.getCompileRoots();
        this.webAppDir = mainDir.resolve("webapp");
        String finalName = ctx.getFinalName();
        this.artifactFile = this.projectBuildDir.resolve(finalName + "." + ctx.getPackaging());
        if (!Files.exists(ctx.getDeploymentsDir(), new LinkOption[0])) {
            Files.createDirectories(ctx.getDeploymentsDir(), new FileAttribute[0]);
        }
        String fName = this.artifactFile.getFileName().toString();
        boolean webapp = false;
        boolean jarapp = false;
        if (ctx.getPackaging().equals("war") || fName.endsWith("war")) {
            if (ctx.isContextRoot()) {
                fName = "ROOT.war";
            }
            webapp = true;
        } else if (ctx.getPackaging().equals("jar") || fName.endsWith("jar")) {
            jarapp = true;
        } else {
            throw new RuntimeException("Not supported packaging : " + ctx.getPackaging());
        }
        this.isWebApp = webapp;
        this.isJarApp = jarapp;
        this.fileName = fName;
        this.targetDir = ctx.getDeploymentsDir().resolve(this.fileName);
        this.registerDir(ctx.getBaseDir());
        this.pom = ctx.getPomFile();
        for (Path p2 : ctx.getResources()) {
            if (!p2.isAbsolute()) {
                p2 = ctx.getBaseDir().resolve(p2);
            }
            this.resourceDirectories.add(p2);
            ctx.debug("[WATCH] resources dir: " + p2);
            if (!Files.exists(p2, new LinkOption[0])) continue;
            this.registerDir(p2);
        }
        for (String extra : ctx.getExtraServerContent()) {
            p = Paths.get(extra, new String[0]);
            if (!p.isAbsolute()) {
                p = ctx.getBaseDir().resolve((Path)p);
            }
            this.extraDirectories.add((Path)p);
            ctx.debug("[WATCH] extra-content dir: " + (Path)p);
            this.registerDir((Path)p);
        }
        for (CliSession session : ctx.getCliSessions()) {
            for (String f : session.getScriptFiles()) {
                Path p3 = Paths.get(f, new String[0]);
                if (!p3.isAbsolute()) {
                    p3 = ctx.getBaseDir().resolve(p3);
                }
                this.cliFiles.add(p3);
                ctx.debug("[WATCH] CLI script File: " + p3);
                this.watchedDirectories.put(p3.getParent().register(watcher, StandardWatchEventKinds.ENTRY_MODIFY), p3.getParent());
            }
            if (session.getPropertiesFile() == null) continue;
            p = Paths.get(session.getPropertiesFile(), new String[0]);
            if (!p.isAbsolute()) {
                p = ctx.getBaseDir().resolve((Path)p);
            }
            this.cliFiles.add((Path)p);
            ctx.debug("[WATCH] CLI properties File: " + (Path)p);
            this.watchedDirectories.put(p.getParent().register(watcher, StandardWatchEventKinds.ENTRY_MODIFY), p.getParent());
        }
    }

    Path getTargetDirectory() {
        return this.targetDir;
    }

    private void fileDeleted(Path absolutePath, Set<Path> paths) {
        WatchKey key = null;
        for (Map.Entry<WatchKey, Path> entry : this.watchedDirectories.entrySet()) {
            if (!entry.getValue().equals(absolutePath)) continue;
            key = entry.getKey();
            break;
        }
        if (key != null) {
            this.ctx.debug("[WATCH] cancelling monitoring of " + absolutePath);
            paths.add(absolutePath);
            key.cancel();
        }
    }

    private boolean isJavaFile(Path absolutePath) {
        if (absolutePath.getFileName().toString().endsWith(".java")) {
            for (Path javaDir : this.compileRootDirectories) {
                if (!absolutePath.startsWith(javaDir)) continue;
                return true;
            }
        }
        return false;
    }

    Path getPath(WatchKey key, Path fileName) {
        Path p = this.watchedDirectories.get(key);
        if (p == null) {
            this.ctx.debug("No more watching key, ignoring change done to " + fileName);
            return null;
        }
        Path resolved = p.resolve(fileName);
        if (this.projectBuildDir.equals(resolved)) {
            return null;
        }
        return resolved;
    }

    private Path getResourcesDir(Path p) {
        for (Path path : this.resourceDirectories) {
            if (!p.startsWith(path)) continue;
            return path;
        }
        if (!this.isJavaFile(p)) {
            for (Path javaDir : this.compileRootDirectories) {
                if (!p.startsWith(javaDir)) continue;
                return javaDir;
            }
        }
        return null;
    }

    private boolean isBootableSpecificFile(Path p) {
        if (this.cliFiles.contains(p)) {
            return true;
        }
        for (Path path : this.extraDirectories) {
            if (!p.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private void registerDir(Path dir) throws IOException {
        this.registerDir(dir, null);
    }

    private void registerDir(Path dir, final Set<Path> set) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (!DevWatchContext.this.projectBuildDir.equals(dir)) {
                    DevWatchContext.this.watchedDirectories.put(dir.register(DevWatchContext.this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY), dir);
                    DevWatchContext.this.ctx.debug("[WATCH] watching " + dir);
                    if (set != null) {
                        set.add(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }

    void cleanup() {
        for (WatchKey k : this.watchedDirectories.keySet()) {
            k.cancel();
        }
        if (Files.exists(this.getTargetDirectory(), new LinkOption[0])) {
            IoUtils.recursiveDelete((Path)this.getTargetDirectory());
        }
    }

    BootableAppEventHandler newEventHandler() {
        JavaAppEventHandler handler;
        if (this.isWebApp) {
            handler = new WebAppEventHandler();
        } else if (this.isJarApp) {
            handler = new JavaAppEventHandler();
        } else {
            throw new RuntimeException("Not supported packaging");
        }
        return handler;
    }

    void build(boolean autoCompile) throws IOException, MojoExecutionException {
        this.rebuild(autoCompile, true, true, true, true, true);
    }

    private void rebuild(boolean autoCompile, boolean compile, boolean repackage, boolean redeploy, boolean cleanup, boolean resources) throws IOException, MojoExecutionException {
        if (cleanup) {
            this.ctx.cleanup(autoCompile);
        }
        if (compile || cleanup) {
            this.ctx.compile(autoCompile);
        }
        if (resources) {
            this.ctx.resources();
        }
        if (repackage || cleanup) {
            this.ctx.debug("[WATCH] re-package");
            if (!Files.exists(this.ctx.getDeploymentsDir(), new LinkOption[0])) {
                Files.createDirectories(this.ctx.getDeploymentsDir(), new FileAttribute[0]);
            }
            if (this.isWebApp) {
                this.ctx.packageWar(this.targetDir);
            } else if (this.isJarApp) {
                this.ctx.packageJar(this.targetDir, this.artifactFile);
            }
        }
        if (redeploy || cleanup) {
            this.ctx.debug("[WATCH] re-deploy");
            try {
                this.ctx.deploy(this.getTargetDirectory());
            }
            catch (Exception ex) {
                throw new MojoExecutionException(ex.toString(), ex);
            }
        }
    }

    static {
        NO_DEPLOYMENT_WEB_FILE_EXTENSIONS.add("xhtml");
        NO_DEPLOYMENT_WEB_FILE_EXTENSIONS.add("html");
        NO_DEPLOYMENT_WEB_FILE_EXTENSIONS.add("jsp");
        NO_DEPLOYMENT_WEB_FILE_EXTENSIONS.add("css");
    }

    static interface ProjectContext {
        public List<String> getWebExtensions();

        public Path getBaseDir();

        public Path getSourceDir();

        public Path getProjectBuildDir();

        public Path getDeploymentsDir();

        public Set<Path> getResources();

        public boolean isContextRoot();

        public String getFinalName();

        public boolean isPluginConfigUpdated() throws ProjectBuildingException;

        public List<CliSession> getCliSessions();

        public List<String> getExtraServerContent();

        public void debug(String var1);

        public void info(String var1);

        public String getPackaging();

        public void cleanup(boolean var1) throws MojoExecutionException;

        public void compile(boolean var1) throws MojoExecutionException;

        public void resources() throws MojoExecutionException;

        public void packageWar(Path var1) throws MojoExecutionException;

        public void packageJar(Path var1, Path var2) throws IOException, MojoExecutionException;

        public Path getPomFile();

        public void deploy(Path var1) throws Exception;

        public Set<Path> getCompileRoots();
    }

    private class WebAppEventHandler
    extends JavaAppEventHandler {
        private WebAppEventHandler() {
        }

        @Override
        public void handle(WatchEvent.Kind event, Path absolutePath) throws Exception {
            Path relativePath;
            boolean isDirectory = Files.isDirectory(absolutePath, new LinkOption[0]);
            boolean fileExists = Files.exists(absolutePath, new LinkOption[0]);
            boolean handledLocally = false;
            if ((event == StandardWatchEventKinds.ENTRY_MODIFY || event == StandardWatchEventKinds.ENTRY_CREATE) && fileExists && !isDirectory && (relativePath = this.isWebFile(absolutePath)) != null) {
                this.copyInDeployment(absolutePath, relativePath);
                this.redeploy = this.requiresRedeploy(absolutePath);
                handledLocally = true;
            }
            if (!handledLocally) {
                super.handle(event, absolutePath);
            }
        }

        private boolean requiresRedeploy(Path path) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return true;
            }
            String fileName = path.getFileName().toString();
            int index = fileName.lastIndexOf(".");
            if (index != -1 && index != fileName.length() - 1) {
                String extension = fileName.substring(index + 1);
                HashSet<String> allExtensions = new HashSet<String>();
                allExtensions.addAll(NO_DEPLOYMENT_WEB_FILE_EXTENSIONS);
                allExtensions.addAll(DevWatchContext.this.ctx.getWebExtensions());
                if (allExtensions.contains(extension)) {
                    DevWatchContext.this.ctx.debug("[WATCH] Simple copy for file " + fileName);
                    return false;
                }
            }
            return true;
        }

        private Path isWebFile(Path absolutePath) {
            if (absolutePath.startsWith(DevWatchContext.this.webAppDir)) {
                return DevWatchContext.this.webAppDir.relativize(absolutePath);
            }
            return null;
        }

        @Override
        protected Path getInDeploymentPath(Path absolutePath) {
            if (absolutePath.startsWith(DevWatchContext.this.webAppDir)) {
                return this.toDeploymentPath(absolutePath, DevWatchContext.this.webAppDir.relativize(absolutePath));
            }
            return super.getInDeploymentPath(absolutePath);
        }

        @Override
        Path getResourcesPath() {
            return Paths.get("WEB-INF", new String[0]).resolve("classes");
        }
    }

    private class JavaAppEventHandler
    extends BootableAppEventHandler {
        private JavaAppEventHandler() {
        }

        @Override
        public void handle(WatchEvent.Kind event, Path absolutePath) throws Exception {
            boolean isDirectory = Files.isDirectory(absolutePath, new LinkOption[0]);
            boolean fileExists = Files.exists(absolutePath, new LinkOption[0]);
            boolean handledLocally = false;
            if (event == StandardWatchEventKinds.ENTRY_MODIFY) {
                if (!isDirectory && fileExists) {
                    if (DevWatchContext.this.isJavaFile(absolutePath)) {
                        DevWatchContext.this.ctx.debug("[WATCH] java compilation roots dir updated, need to re-compile");
                        this.compile = true;
                        this.repackage = true;
                        this.redeploy = true;
                        this.seenUpdated.add(absolutePath);
                        handledLocally = true;
                    } else {
                        Path resourcesDir = DevWatchContext.this.getResourcesDir(absolutePath);
                        if (resourcesDir != null) {
                            DevWatchContext.this.ctx.debug("[WATCH] resources dir updated, need to re-deploy");
                            this.copyInDeployment(absolutePath, this.getResourcesPath().resolve(resourcesDir.relativize(absolutePath)));
                            this.redeploy = true;
                            this.resources = true;
                            handledLocally = true;
                        }
                    }
                }
            } else if (event == StandardWatchEventKinds.ENTRY_DELETE && DevWatchContext.this.isJavaFile(absolutePath)) {
                DevWatchContext.this.ctx.debug("[WATCH] java file deleted, need to clean and re-compile");
                this.compile = true;
                this.repackage = true;
                this.redeploy = true;
                this.clean = true;
            }
            if (!handledLocally) {
                super.handle(event, absolutePath);
            }
        }

        @Override
        protected Path getInDeploymentPath(Path absolutePath) {
            Path path = DevWatchContext.this.getResourcesDir(absolutePath);
            if (path != null) {
                return this.toDeploymentPath(absolutePath, this.getResourcesPath().resolve(path.relativize(absolutePath)));
            }
            return null;
        }

        Path toDeploymentPath(Path absolutePath, Path relativePath) {
            return DevWatchContext.this.targetDir.resolve(relativePath);
        }

        Path getResourcesPath() {
            return Paths.get("", new String[0]);
        }

        void copyInDeployment(Path absolutePath, Path relativePath) throws IOException {
            Path p = this.toDeploymentPath(absolutePath, relativePath);
            DevWatchContext.this.ctx.debug("[WATCH] copy " + absolutePath + " to " + p);
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            Files.copy(absolutePath, p, StandardCopyOption.REPLACE_EXISTING);
            this.copied.put(absolutePath, p);
        }
    }

    abstract class BootableAppEventHandler {
        boolean rebuildBootableJAR;
        boolean compile;
        boolean redeploy;
        boolean repackage;
        boolean clean;
        boolean reset;
        boolean resources;
        Map<Path, Path> copied = new HashMap<Path, Path>();
        Map<Path, Path> deleted = new HashMap<Path, Path>();
        Set<Path> monitored = new HashSet<Path>();
        Set<Path> stopMonitored = new HashSet<Path>();
        Set<Path> seenUpdated = new HashSet<Path>();

        BootableAppEventHandler() {
        }

        public void handle(WatchEvent.Kind event, Path absolutePath) throws Exception {
            boolean isDirectory = Files.isDirectory(absolutePath, new LinkOption[0]);
            boolean fileExists = Files.exists(absolutePath, new LinkOption[0]);
            if (event == StandardWatchEventKinds.ENTRY_DELETE) {
                DevWatchContext.this.fileDeleted(absolutePath, this.stopMonitored);
                Path indep = this.getInDeploymentPath(absolutePath);
                if (indep != null) {
                    DevWatchContext.this.ctx.debug("[WATCH] Delete file " + indep);
                    Files.deleteIfExists(indep);
                    this.deleted.put(absolutePath, indep);
                    this.redeploy = true;
                } else {
                    DevWatchContext.this.ctx.debug("[WATCH] Not a deployment file " + absolutePath);
                    this.deleted.put(absolutePath, absolutePath);
                }
            } else if (event == StandardWatchEventKinds.ENTRY_CREATE) {
                if (isDirectory) {
                    DevWatchContext.this.registerDir(absolutePath, this.monitored);
                }
            } else if (event == StandardWatchEventKinds.ENTRY_MODIFY && fileExists && !isDirectory) {
                if (DevWatchContext.this.pom.equals(absolutePath)) {
                    if (DevWatchContext.this.ctx.isPluginConfigUpdated()) {
                        DevWatchContext.this.ctx.info("[WATCH] Must rebuild the bootable JAR.");
                        this.rebuildBootableJAR = true;
                    } else {
                        DevWatchContext.this.ctx.info("[WATCH] Reset the watcher.");
                        this.reset = true;
                    }
                    this.seenUpdated.add(absolutePath);
                } else if (DevWatchContext.this.isBootableSpecificFile(absolutePath)) {
                    this.rebuildBootableJAR = true;
                    DevWatchContext.this.ctx.info("[WATCH] Must rebuild the bootable JAR. ");
                    this.seenUpdated.add(absolutePath);
                }
            }
        }

        void applyChanges() throws IOException, MojoExecutionException {
            if (this.compile || this.redeploy) {
                DevWatchContext.this.ctx.debug("[WATCH] updating application");
                DevWatchContext.this.rebuild(false, this.compile, this.repackage, this.redeploy, this.clean, this.resources);
            }
        }

        protected abstract Path getInDeploymentPath(Path var1);
    }
}

