/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.common;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.core.ServerHelper;

public class Utils {
    public static String getBootableJarPath(MavenProject project, String goal) throws MojoExecutionException {
        String finalName = project.getBuild().getFinalName();
        String jarName = finalName + "-" + "wildfly" + "." + "jar";
        String path = project.getBuild().getDirectory() + File.separator + jarName;
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            throw new MojoExecutionException("Cannot " + goal + " without a bootable jar; please `mvn wildfly-jar:package` prior to invoking wildfly-jar:run from the command-line");
        }
        return path;
    }

    public static void startBootableJar(String jarPath, List<String> jvmArguments, List<String> arguments, boolean waitFor, boolean checkStart, ModelControllerClient client, long timeout) throws MojoExecutionException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Utils.getJava());
        cmd.addAll(jvmArguments);
        cmd.add("-jar");
        cmd.add(jarPath);
        cmd.addAll(arguments);
        ProcessBuilder builder = new ProcessBuilder(cmd).inheritIO();
        try {
            Process p = builder.start();
            if (waitFor) {
                p.waitFor();
            } else if (checkStart) {
                Utils.checkStarted(client, timeout);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getLocalizedMessage(), ex);
        }
    }

    private static void checkStarted(ModelControllerClient client, long timeout) throws Exception {
        ServerHelper.waitForStandalone(null, (ModelControllerClient)client, (long)timeout);
    }

    private static String getJava() {
        String javaHome;
        String exe = "java";
        if (Utils.isWindows()) {
            exe = "java.exe";
        }
        if ((javaHome = System.getenv("JAVA_HOME")) == null) {
            return exe;
        }
        return javaHome + File.separator + "bin" + File.separator + exe;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", null).toLowerCase(Locale.ENGLISH).contains("windows");
    }
}

