/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.core.ServerHelper;

@Mojo(name="shutdown")
public class ShutdownBootableJarMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="wildfly.bootable.shutdown.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping " + this.goal() + " of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        try (ModelControllerClient client = this.createClient();){
            ServerHelper.shutdownStandalone((ModelControllerClient)client);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public String goal() {
        return "shutdown";
    }
}

