/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;
import org.wildfly.common.expression.Expression;

@Named
public class BootLoggingConfiguration
extends AbstractLogEnabled {
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)([kKmMgGbBtT])?");
    private static final String NEW_LINE = System.lineSeparator();
    private static final Collection<String> IGNORED_PROPERTIES = Arrays.asList("java.ext.dirs", "java.home", "jboss.home.dir", "java.io.tmpdir", "jboss.controller.temp.dir", "jboss.server.base.dir", "jboss.server.config.dir", "jboss.server.data.dir", "jboss.server.default.config", "jboss.server.deploy.dir", "jboss.server.log.dir", "jboss.server.persist.config", "jboss.server.management.uuid", "jboss.server.temp.dir", "modules.path", "org.jboss.server.bootstrap.maxThreads", "user.dir", "user.home");
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, String> usedProperties = new TreeMap<String, String>();
    private final Map<String, String> additionalPatternFormatters = new LinkedHashMap<String, String>();
    private ModelControllerClient client;

    void generate(Path configDir, ModelControllerClient client) throws IOException, MojoExecutionException {
        this.properties.clear();
        this.usedProperties.clear();
        this.additionalPatternFormatters.clear();
        ModelNode op = Operations.createOperation((String)"read-children-names");
        op.get("child-type").set("subsystem");
        ModelNode result = client.execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new MojoExecutionException("Could not determine if the logging subsystem was present: " + Operations.getFailureDescription((ModelNode)result).asString());
        }
        if (Operations.readResult((ModelNode)result).asList().stream().noneMatch(name -> name.asString().equals("logging"))) {
            return;
        }
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create().addStep(Operations.createReadResourceOperation((ModelNode)Operations.createAddress((String[])new String[]{"subsystem", "logging"}), (boolean)true));
        op = Operations.createOperation((String)"read-children-resources");
        op.get("child-type").set("system-property");
        builder.addStep(op);
        op = Operations.createOperation((String)"read-children-resources");
        op.get("child-type").set("path");
        builder.addStep(op);
        result = client.execute(builder.build());
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new MojoExecutionException("Failed to determine the logging configuration: " + Operations.getFailureDescription((ModelNode)result).asString());
        }
        result = Operations.readResult((ModelNode)result);
        ModelNode subsystem = Operations.readResult((ModelNode)result.get("step-1"));
        ModelNode systemProperties = Operations.readResult((ModelNode)result.get("step-2"));
        ModelNode paths = Operations.readResult((ModelNode)result.get("step-3"));
        if (subsystem.isDefined()) {
            this.client = client;
            this.parseProperties(systemProperties);
            try (BufferedWriter writer = Files.newBufferedWriter(configDir.resolve("logging.properties"), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write("# Note this file has been generated and will be overwritten if a");
                writer.write(NEW_LINE);
                writer.write("# logging subsystem has been defined in the XML configuration.");
                writer.write(NEW_LINE);
                writer.write(NEW_LINE);
                this.writeLoggers(writer, subsystem);
                this.writeHandlers(writer, subsystem, paths);
                this.writeFormatters(writer, subsystem);
                this.writeFilters(writer, subsystem);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write the logging configuration file to " + configDir.toAbsolutePath(), (Exception)e);
            }
            Properties requiredProperties = new Properties();
            Iterator<Map.Entry<String, String>> iter = this.usedProperties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                String key = entry.getKey();
                if (this.properties.containsKey(key)) {
                    requiredProperties.put(key, this.properties.get(key));
                } else {
                    this.getLogger().warn(String.format("The value for the expression \"%s\" could not be resolved and may not be set at boot if no default value is available.", entry.getValue()));
                }
                iter.remove();
            }
            if (!requiredProperties.isEmpty()) {
                try (BufferedWriter writer = Files.newBufferedWriter(configDir.resolve("boot-config.properties"), new OpenOption[0]);){
                    requiredProperties.store(writer, "Bootable JAR boot properties required by the log manager.");
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to write the system properties required by the logging configuration file to " + configDir.toAbsolutePath(), (Exception)e);
                }
            }
        }
    }

    private void writeFilters(Writer writer, ModelNode subsystem) throws IOException {
        if (subsystem.hasDefined("filter")) {
            for (Property property : subsystem.get("filter").asPropertyList()) {
                ModelNode properties;
                String name = property.getName();
                ModelNode model = property.getValue();
                String prefix = "filter." + name;
                BootLoggingConfiguration.writeProperty(writer, prefix, null, this.resolveAsString(model.get("class")));
                BootLoggingConfiguration.writeProperty(writer, prefix, "module", this.resolveAsString(model.get("module")));
                ModelNode allProperties = new ModelNode();
                if (model.hasDefined("constructor-properties")) {
                    properties = model.get("constructor-properties");
                    Collection constructorNames = properties.asPropertyList().stream().map(Property::getName).collect(Collectors.toList());
                    BootLoggingConfiguration.writeProperty(writer, prefix, "constructorProperties", BootLoggingConfiguration.toCsvString(constructorNames));
                    for (String n : constructorNames) {
                        allProperties.get(n).set(properties.get(n));
                    }
                }
                if (model.hasDefined("properties")) {
                    properties = model.get("properties");
                    Collection propertyNames = properties.asPropertyList().stream().map(Property::getName).collect(Collectors.toList());
                    for (String n : propertyNames) {
                        allProperties.get(n).set(properties.get(n));
                    }
                }
                if (!allProperties.isDefined()) continue;
                BootLoggingConfiguration.writeProperty(writer, prefix, "properties", BootLoggingConfiguration.toCsvString(allProperties.asPropertyList().stream().map(Property::getName).collect(Collectors.toList())));
                this.writeProperties(writer, prefix, allProperties);
            }
            writer.write(NEW_LINE);
        }
    }

    private void writeFormatters(Writer writer, ModelNode subsystem) throws IOException {
        if (subsystem.hasDefined("custom-formatter")) {
            this.writeCustomFormatter(writer, subsystem.get("custom-formatter").asPropertyList());
        }
        if (subsystem.hasDefined("json-formatter")) {
            this.writeStructuredFormatter("org.jboss.logmanager.formatters.JsonFormatter", writer, subsystem.get("json-formatter").asPropertyList());
        }
        if (subsystem.hasDefined("pattern-formatter")) {
            this.writePatternFormatter(writer, subsystem.get("pattern-formatter").asPropertyList());
        }
        if (subsystem.hasDefined("xml-formatter")) {
            this.writeStructuredFormatter("org.jboss.logmanager.formatters.XmlFormatter", writer, subsystem.get("xml-formatter").asPropertyList());
        }
    }

    private void writeCustomFormatter(Writer writer, List<Property> formatters) throws IOException {
        for (Property property : formatters) {
            String name = property.getName();
            ModelNode model = property.getValue().clone();
            String prefix = "formatter." + name;
            BootLoggingConfiguration.writeProperty(writer, prefix, null, this.resolveAsString(model.remove("class")));
            BootLoggingConfiguration.writeProperty(writer, prefix, "module", this.resolveAsString(model.remove("module")));
            if (model.hasDefined("properties")) {
                ModelNode properties = model.get("properties");
                Collection definedPropertyNames = properties.asPropertyList().stream().filter(p -> p.getValue().isDefined()).map(Property::getName).collect(Collectors.toList());
                BootLoggingConfiguration.writeProperty(writer, prefix, "properties", BootLoggingConfiguration.toCsvString(definedPropertyNames));
                for (String attributeName : definedPropertyNames) {
                    this.writeProperty(writer, prefix, attributeName, properties.get(attributeName));
                }
            }
            writer.write(NEW_LINE);
        }
    }

    private void writePatternFormatter(Writer writer, List<Property> formatters) throws IOException {
        for (Property property : formatters) {
            String name = property.getName();
            ModelNode model = property.getValue().clone();
            String prefix = "formatter." + name;
            BootLoggingConfiguration.writeProperty(writer, prefix, null, "org.jboss.logmanager.formatters.PatternFormatter");
            Collection definedPropertyNames = model.asPropertyList().stream().filter(p -> p.getValue().isDefined()).map(Property::getName).collect(Collectors.toList());
            BootLoggingConfiguration.writeProperty(writer, prefix, "properties", BootLoggingConfiguration.toCsvString(definedPropertyNames.stream().map(BootLoggingConfiguration::resolvePropertyName).collect(Collectors.toList())));
            for (String attributeName : definedPropertyNames) {
                this.writeProperty(writer, prefix, BootLoggingConfiguration.resolvePropertyName(attributeName), model.get(attributeName));
            }
            writer.write(NEW_LINE);
        }
        Iterator<Map.Entry<String, String>> iter = this.additionalPatternFormatters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String prefix = "formatter." + entry.getKey();
            BootLoggingConfiguration.writeProperty(writer, prefix, null, "org.jboss.logmanager.formatters.PatternFormatter");
            BootLoggingConfiguration.writeProperty(writer, prefix, "constructorProperties", "pattern");
            BootLoggingConfiguration.writeProperty(writer, prefix, "properties", "pattern");
            BootLoggingConfiguration.writeProperty(writer, prefix, "pattern", entry.getValue());
            writer.write(NEW_LINE);
            iter.remove();
        }
    }

    private void writeStructuredFormatter(String type, Writer writer, List<Property> formatters) throws IOException {
        for (Property property : formatters) {
            String name = property.getName();
            ModelNode model = property.getValue().clone();
            String prefix = "formatter." + name;
            BootLoggingConfiguration.writeProperty(writer, prefix, null, type);
            if (model.hasDefined("key-overrides")) {
                BootLoggingConfiguration.writeProperty(writer, prefix, "constructorProperties", "keyOverrides");
            }
            Collection definedPropertyNames = model.asPropertyList().stream().filter(p -> p.getValue().isDefined()).map(Property::getName).collect(Collectors.toList());
            BootLoggingConfiguration.writeProperty(writer, prefix, "properties", BootLoggingConfiguration.toCsvString(definedPropertyNames.stream().map(BootLoggingConfiguration::resolvePropertyName).collect(Collectors.toList())));
            for (String attributeName : definedPropertyNames) {
                ModelNode value = model.get(attributeName);
                if ("exception-output-type".equals(attributeName)) {
                    BootLoggingConfiguration.writeProperty(writer, prefix, BootLoggingConfiguration.resolvePropertyName(attributeName), this.toEnumString(model.get(attributeName)));
                    continue;
                }
                this.writeProperty(writer, prefix, BootLoggingConfiguration.resolvePropertyName(attributeName), value);
            }
            writer.write(NEW_LINE);
        }
    }

    private void writeHandlers(Writer writer, ModelNode subsystem, ModelNode pathModel) throws IOException {
        if (subsystem.hasDefined("async-handler")) {
            this.writeAsyncHandlers(writer, subsystem.get("async-handler").asPropertyList());
        }
        if (subsystem.hasDefined("console-handler")) {
            this.writeConsoleHandlers(writer, subsystem.get("console-handler").asPropertyList());
        }
        if (subsystem.hasDefined("custom-handler")) {
            this.writeCustomHandlers(writer, subsystem.get("custom-handler").asPropertyList());
        }
        if (subsystem.hasDefined("file-handler")) {
            this.writeFileHandlers(pathModel, "org.jboss.logmanager.handlers.FileHandler", writer, subsystem.get("file-handler").asPropertyList());
        }
        if (subsystem.hasDefined("periodic-rotating-file-handler")) {
            this.writeFileHandlers(pathModel, "org.jboss.logmanager.handlers.PeriodicRotatingFileHandler", writer, subsystem.get("periodic-rotating-file-handler").asPropertyList());
        }
        if (subsystem.hasDefined("periodic-size-rotating-file-handler")) {
            this.writeFileHandlers(pathModel, "org.jboss.logmanager.handlers.PeriodicSizeRotatingFileHandler", writer, subsystem.get("periodic-size-rotating-file-handler").asPropertyList());
        }
        if (subsystem.hasDefined("size-rotating-file-handler")) {
            this.writeFileHandlers(pathModel, "org.jboss.logmanager.handlers.SizeRotatingFileHandler", writer, subsystem.get("size-rotating-file-handler").asPropertyList());
        }
        if (subsystem.hasDefined("socket-handler")) {
            this.writeSocketHandler(writer, subsystem.get("socket-handler").asPropertyList());
        }
        if (subsystem.hasDefined("syslog-handler")) {
            this.writeSyslogHandler(writer, subsystem.get("syslog-handler").asPropertyList());
        }
    }

    private void writeAsyncHandlers(Writer writer, List<Property> handlers) throws IOException {
        for (Property property : handlers) {
            String name = property.getName();
            String prefix = "handler." + name;
            ModelNode model = property.getValue().clone();
            this.writeCommonHandler("org.jboss.logmanager.handlers.AsyncHandler", writer, name, prefix, model);
            ModelNode subhandlers = model.remove("subhandlers");
            if (BootLoggingConfiguration.isDefined(subhandlers)) {
                this.writeProperty(writer, prefix, "handlers", subhandlers);
            }
            Collection definedPropertyNames = model.asPropertyList().stream().filter(p -> p.getValue().isDefined()).map(Property::getName).collect(Collectors.toList());
            definedPropertyNames.add("closeChildren");
            BootLoggingConfiguration.writeProperty(writer, prefix, "properties", BootLoggingConfiguration.toCsvString(definedPropertyNames.stream().map(BootLoggingConfiguration::resolvePropertyName).collect(Collectors.toList())));
            BootLoggingConfiguration.writeProperty(writer, prefix, "constructorProperties", "queueLength");
            for (String attributeName : definedPropertyNames) {
                if ("closeChildren".equals(attributeName)) {
                    BootLoggingConfiguration.writeProperty(writer, prefix, attributeName, "false");
                    continue;
                }
                this.writeProperty(writer, prefix, BootLoggingConfiguration.resolvePropertyName(attributeName), model.get(attributeName));
            }
            writer.write(NEW_LINE);
        }
    }

    private void writeConsoleHandlers(Writer writer, List<Property> handlers) throws IOException {
        for (Property property : handlers) {
            String name = property.getName();
            String prefix = "handler." + name;
            ModelNode model = property.getValue().clone();
            this.writeCommonHandler("org.jboss.logmanager.handlers.ConsoleHandler", writer, name, prefix, model);
            Collection definedPropertyNames = model.asPropertyList().stream().filter(p -> p.getValue().isDefined()).map(Property::getName).collect(Collectors.toList());
            BootLoggingConfiguration.writeProperty(writer, prefix, "properties", BootLoggingConfiguration.toCsvString(definedPropertyNames.stream().map(BootLoggingConfiguration::resolvePropertyName).collect(Collectors.toList())));
            for (String attributeName : definedPropertyNames) {
                if ("target".equals(attributeName)) {
                    BootLoggingConfiguration.writeProperty(writer, prefix, BootLoggingConfiguration.resolvePropertyName(attributeName), this.toEnumString(model.get(attributeName)));
                    continue;
                }
                this.writeProperty(writer, prefix, BootLoggingConfiguration.resolvePropertyName(attributeName), model.get(attributeName));
            }
            writer.write(NEW_LINE);
        }
    }

    private void writeCustomHandlers(Writer writer, List<Property> handlers) throws IOException {
        for (Property property : handlers) {
            String name = property.getName();
            String prefix = "handler." + name;
            ModelNode model = property.getValue().clone();
            this.writeCommonHandler(null, writer, name, prefix, model);
            if (model.hasDefined("properties")) {
                Collection definedPropertyNames = model.get("properties").asPropertyList().stream().filter(p -> p.getValue().isDefined()).map(Property::getName).collect(Collectors.toList());
                if (model.hasDefined("enabled")) {
                    definedPropertyNames.add("enabled");
                }
                BootLoggingConfiguration.writeProperty(writer, prefix, "properties", BootLoggingConfiguration.toCsvString(definedPropertyNames));
                ModelNode properties = model.get("properties");
                for (String attributeName : definedPropertyNames) {
                    if ("enabled".equals(attributeName)) {
                        if (!model.hasDefined(attributeName)) continue;
                        this.writeProperty(writer, prefix, attributeName, model.get(attributeName));
                        continue;
                    }
                    this.writeProperty(writer, prefix, attributeName, properties.get(attributeName));
                }
            } else if (model.hasDefined("enabled")) {
                BootLoggingConfiguration.writeProperty(writer, prefix, "properties", "enabled");
                this.writeProperty(writer, prefix, "enabled", model.get("enabled"));
            }
            writer.write(NEW_LINE);
        }
    }

    private void writeFileHandlers(ModelNode pathModel, String type, Writer writer, List<Property> handlers) throws IOException {
        for (Property property : handlers) {
            String name = property.getName();
            String prefix = "handler." + name;
            ModelNode model = property.getValue().clone();
            ModelNode file = model.remove("file");
            if (!BootLoggingConfiguration.isDefined(file)) continue;
            this.writeCommonHandler(type, writer, name, prefix, model);
            Collection definedPropertyNames = model.asPropertyList().stream().filter(p -> p.getValue().isDefined()).map(Property::getName).collect(Collectors.toList());
            Collection propertyNames = definedPropertyNames.stream().map(BootLoggingConfiguration::resolvePropertyName).collect(Collectors.toList());
            propertyNames.add("fileName");
            BootLoggingConfiguration.writeProperty(writer, prefix, "properties", BootLoggingConfiguration.toCsvString(propertyNames));
            BootLoggingConfiguration.writeProperty(writer, prefix, "constructorProperties", "fileName,append");
            for (String attributeName : definedPropertyNames) {
                if ("rotate-size".equals(attributeName)) {
                    String resolvedValue = String.valueOf(this.parseSize(model.get(attributeName)));
                    BootLoggingConfiguration.writeProperty(writer, prefix, BootLoggingConfiguration.resolvePropertyName(attributeName), resolvedValue);
                    continue;
                }
                this.writeProperty(writer, prefix, BootLoggingConfiguration.resolvePropertyName(attributeName), model.get(attributeName));
            }
            StringBuilder result = new StringBuilder();
            if (file.hasDefined("relative-to")) {
                String relativeTo = file.get("relative-to").asString();
                this.resolveRelativeTo(pathModel, relativeTo, result);
            }
            if (file.hasDefined("path")) {
                result.append(this.resolveAsString(file.get("path")));
            }
            BootLoggingConfiguration.writeProperty(writer, prefix, "fileName", result.toString());
            writer.write(NEW_LINE);
        }
    }

    private void writeSocketHandler(Writer writer, List<Property> handlers) throws IOException {
        for (Property property : handlers) {
            String name = property.getName();
            String prefix = "handler." + name;
            ModelNode model = property.getValue().clone();
            this.writeCommonHandler("org.jboss.logmanager.handlers.DelayedHandler", writer, name, prefix, model);
            if (model.hasDefined("enabled")) {
                BootLoggingConfiguration.writeProperty(writer, prefix, "properties", "enabled");
                this.writeProperty(writer, prefix, "enabled", model.get("enabled"));
            }
            writer.write(NEW_LINE);
        }
    }

    private void writeSyslogHandler(Writer writer, List<Property> handlers) throws IOException {
        for (Property property : handlers) {
            String name = property.getName();
            String prefix = "handler." + name;
            ModelNode model = property.getValue().clone();
            this.writeCommonHandler("org.jboss.logmanager.handlers.SyslogHandler", writer, name, prefix, model);
            Collection definedPropertyNames = model.asPropertyList().stream().filter(p -> p.getValue().isDefined()).map(Property::getName).collect(Collectors.toList());
            BootLoggingConfiguration.writeProperty(writer, prefix, "properties", BootLoggingConfiguration.toCsvString(definedPropertyNames.stream().map(BootLoggingConfiguration::resolvePropertyName).collect(Collectors.toList())));
            for (String attributeName : definedPropertyNames) {
                if ("facility".equals(attributeName)) {
                    BootLoggingConfiguration.writeProperty(writer, prefix, BootLoggingConfiguration.resolvePropertyName(attributeName), this.toEnumString(model.get(attributeName)));
                    continue;
                }
                this.writeProperty(writer, prefix, BootLoggingConfiguration.resolvePropertyName(attributeName), model.get(attributeName));
            }
            writer.write(NEW_LINE);
        }
    }

    private void writeCommonHandler(String type, Writer writer, String name, String prefix, ModelNode model) throws IOException {
        ModelNode encoding;
        if (type == null) {
            BootLoggingConfiguration.writeProperty(writer, prefix, null, this.resolveAsString(model.remove("class")));
            BootLoggingConfiguration.writeProperty(writer, prefix, "module", this.resolveAsString(model.remove("module")));
        } else {
            BootLoggingConfiguration.writeProperty(writer, prefix, null, type);
        }
        model.remove("name");
        ModelNode level = model.remove("level");
        if (BootLoggingConfiguration.isDefined(level)) {
            this.writeProperty(writer, prefix, "level", level);
        }
        if (BootLoggingConfiguration.isDefined(encoding = model.remove("encoding"))) {
            this.writeProperty(writer, prefix, "encoding", encoding);
        }
        ModelNode namedFormatter = model.remove("named-formatter");
        ModelNode formatter = model.remove("formatter");
        if (BootLoggingConfiguration.isDefined(namedFormatter)) {
            BootLoggingConfiguration.writeProperty(writer, prefix, "formatter", namedFormatter.asString());
        } else if (BootLoggingConfiguration.isDefined(formatter)) {
            String defaultFormatterName = name + "-wfcore-pattern-formatter";
            this.additionalPatternFormatters.put(defaultFormatterName, this.resolveAsString(formatter));
            BootLoggingConfiguration.writeProperty(writer, prefix, "formatter", defaultFormatterName);
        }
        model.remove("filter");
        ModelNode filter = model.remove("filter-spec");
        if (BootLoggingConfiguration.isDefined(filter)) {
            this.writeProperty(writer, prefix, "filter", filter);
        }
    }

    private void writeLoggers(Writer writer, ModelNode model) throws IOException {
        if (model.hasDefined("logger")) {
            List loggerModel = model.get("logger").asPropertyList();
            writer.write("# Additional loggers to configure (the root logger is always configured)");
            writer.write(NEW_LINE);
            BootLoggingConfiguration.writeProperty(writer, "loggers", null, BootLoggingConfiguration.toCsvString(loggerModel.stream().map(Property::getName).collect(Collectors.toList())));
            writer.write(NEW_LINE);
            if (model.hasDefined(new String[]{"root-logger", "ROOT"})) {
                this.writeLogger(writer, null, model.get(new String[]{"root-logger", "ROOT"}));
            }
            for (Property property : loggerModel) {
                this.writeLogger(writer, property.getName(), property.getValue());
            }
        }
    }

    private void writeLogger(Writer writer, String name, ModelNode model) throws IOException {
        String prefix;
        String string = prefix = name == null ? "logger" : "logger." + name;
        if (model.hasDefined("filter-spec")) {
            this.writeProperty(writer, prefix, "filter", model.get("filter-spec"));
        }
        if (model.hasDefined("handlers")) {
            BootLoggingConfiguration.writeProperty(writer, prefix, "handlers", BootLoggingConfiguration.toCsvString(model.get("handlers").asList().stream().map(ModelNode::asString).collect(Collectors.toList())));
        }
        if (model.hasDefined("level")) {
            this.writeProperty(writer, prefix, "level", model.get("level"));
        }
        if (model.hasDefined("use-parent-filters")) {
            this.writeProperty(writer, prefix, "useParentFilters", model.get("use-parent-filters"));
        }
        if (model.hasDefined("use-parent-handlers")) {
            this.writeProperty(writer, prefix, "useParentHandlers", model.get("use-parent-handlers"));
        }
        writer.write(NEW_LINE);
    }

    private void writeProperties(Writer writer, String prefix, ModelNode model) throws IOException {
        for (Property property : model.asPropertyList()) {
            String name = property.getName();
            ModelNode value = property.getValue();
            if (!value.isDefined()) continue;
            this.writeProperty(writer, prefix, name, value);
        }
    }

    private void writeProperty(Writer out, String prefix, String name, ModelNode value) throws IOException {
        BootLoggingConfiguration.writeProperty(out, prefix, name, this.resolveAsString(value));
    }

    private String toEnumString(ModelNode value) {
        StringBuilder result = new StringBuilder();
        if (value.getType() == ModelType.EXPRESSION) {
            Expression expression = Expression.of(value.asExpression());
            this.usedProperties.put(expression.getKey(), value.asString());
            result.append("${").append(expression.getKey());
            if (expression.hasDefault()) {
                if (expression.hasDefault()) {
                    result.append(':');
                    String dft = expression.getDefaultValue();
                    for (char c : dft.toCharArray()) {
                        if (c == '-' || c == '.') {
                            result.append('_');
                            continue;
                        }
                        result.append(Character.toUpperCase(c));
                    }
                }
                result.append('}');
            }
        } else {
            for (char c : value.asString().toCharArray()) {
                if (c == '-' || c == '.') {
                    result.append('_');
                    continue;
                }
                result.append(Character.toUpperCase(c));
            }
        }
        return result.toString();
    }

    private String resolveAsString(ModelNode value) {
        if (value.getType() == ModelType.LIST) {
            return BootLoggingConfiguration.toCsvString(value.asList().stream().map(ModelNode::asString).collect(Collectors.toList()));
        }
        if (value.getType() == ModelType.OBJECT) {
            return BootLoggingConfiguration.modelToMap(value);
        }
        if (value.getType() == ModelType.EXPRESSION) {
            Expression expression = Expression.of(value.asExpression());
            this.usedProperties.put(expression.getKey(), value.asString());
        }
        return value.asString();
    }

    private long parseSize(ModelNode value) throws IOException {
        String stringValue;
        if (value.getType() == ModelType.EXPRESSION) {
            Expression expression = Expression.of(value.asExpression());
            this.usedProperties.put(expression.getKey(), value.asString());
            ModelNode op = Operations.createOperation((String)"resolve-expression");
            op.get("expression").set(value.asString());
            ModelNode result = this.client.execute(op);
            if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                throw new RuntimeException(String.format("Failed to resolve the expression %s: %s", value.asString(), Operations.getFailureDescription((ModelNode)result).asString()));
            }
            stringValue = Operations.readResult((ModelNode)result).asString();
        } else {
            stringValue = value.asString();
        }
        Matcher matcher = SIZE_PATTERN.matcher(stringValue);
        if (!matcher.matches()) {
            return 655360L;
        }
        long qty = Long.parseLong(matcher.group(1), 10);
        String chr = matcher.group(2);
        if (chr != null) {
            switch (chr.charAt(0)) {
                case 'B': 
                case 'b': {
                    break;
                }
                case 'K': 
                case 'k': {
                    qty <<= 10;
                    break;
                }
                case 'M': 
                case 'm': {
                    qty <<= 20;
                    break;
                }
                case 'G': 
                case 'g': {
                    qty <<= 30;
                    break;
                }
                case 'T': 
                case 't': {
                    qty <<= 40;
                    break;
                }
                default: {
                    return 655360L;
                }
            }
        }
        return qty;
    }

    private void parseProperties(ModelNode model) {
        if (model.isDefined()) {
            for (Property property : model.asPropertyList()) {
                ModelNode value;
                String key = property.getName();
                if (IGNORED_PROPERTIES.contains(key) || !(value = property.getValue().get("value")).isDefined()) continue;
                this.properties.put(key, value.asString());
            }
        }
    }

    private void resolveRelativeTo(ModelNode pathModel, String relativeTo, StringBuilder builder) {
        if (pathModel.hasDefined(relativeTo)) {
            ModelNode path = pathModel.get(relativeTo);
            if (path.hasDefined("relative-to")) {
                this.resolveRelativeTo(pathModel, path.get("relative-to").asString(), builder);
            }
            if (path.hasDefined("path")) {
                ModelNode pathEntry = path.get("path");
                if (pathEntry.getType() == ModelType.EXPRESSION) {
                    Expression expression = Expression.of(pathEntry.asExpression());
                    if (!this.properties.containsKey(expression.getKey())) {
                        this.getLogger().warn(String.format("The path %s is an undefined property. If not set at boot time unexpected results may occur.", pathEntry.asString()));
                    } else {
                        this.usedProperties.put(expression.getKey(), this.properties.get(expression.getKey()));
                        expression.appendTo(builder);
                    }
                } else {
                    if (!IGNORED_PROPERTIES.contains(relativeTo)) {
                        this.properties.put(relativeTo, pathEntry.asString());
                        this.usedProperties.put(relativeTo, pathEntry.asString());
                    }
                    builder.append("${").append(relativeTo).append("}");
                }
            }
            builder.append('/');
        }
    }

    private static void writeProperty(Writer out, String prefix, String name, String value) throws IOException {
        if (name == null) {
            BootLoggingConfiguration.writeKey(out, prefix);
        } else {
            BootLoggingConfiguration.writeKey(out, String.format("%s.%s", prefix, name));
        }
        BootLoggingConfiguration.writeValue(out, value);
        out.write(NEW_LINE);
    }

    private static void writeValue(Appendable out, String value) throws IOException {
        BootLoggingConfiguration.writeSanitized(out, value, false);
    }

    private static void writeKey(Appendable out, String key) throws IOException {
        BootLoggingConfiguration.writeSanitized(out, key, true);
        out.append('=');
    }

    private static void writeSanitized(Appendable out, String string, boolean escapeSpaces) throws IOException {
        block8: for (int x = 0; x < string.length(); ++x) {
            char c = string.charAt(x);
            switch (c) {
                case ' ': {
                    if (x == 0 || escapeSpaces) {
                        out.append('\\');
                    }
                    out.append(c);
                    continue block8;
                }
                case '\t': {
                    out.append('\\').append('t');
                    continue block8;
                }
                case '\n': {
                    out.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    out.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    out.append('\\').append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    out.append('\\').append(c);
                    continue block8;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    private static String modelToMap(ModelNode value) {
        if (value.getType() != ModelType.OBJECT) {
            return null;
        }
        List properties = value.asPropertyList();
        StringBuilder result = new StringBuilder();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            BootLoggingConfiguration.escapeKey(result, property.getName());
            result.append('=');
            ModelNode v = property.getValue();
            if (v.isDefined()) {
                BootLoggingConfiguration.escapeValue(result, v.asString());
            }
            if (!iterator.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    }

    private static boolean isDefined(ModelNode value) {
        return value != null && value.isDefined();
    }

    private static String toCsvString(Collection<String> names) {
        StringBuilder result = new StringBuilder(1024);
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            if (name.isEmpty()) continue;
            result.append(name);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private static String resolvePropertyName(String modelName) {
        if ("autoflush".equals(modelName)) {
            return "autoFlush";
        }
        if ("color-map".equals(modelName)) {
            return "colors";
        }
        if ("syslog-format".equals(modelName)) {
            return "syslogType";
        }
        if ("server-address".equals(modelName)) {
            return "serverHostname";
        }
        if (modelName.contains("-")) {
            StringBuilder builder = new StringBuilder();
            boolean cap = false;
            for (char c : modelName.toCharArray()) {
                if (c == '-') {
                    cap = true;
                    continue;
                }
                if (cap) {
                    builder.append(Character.toUpperCase(c));
                    cap = false;
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        }
        return modelName;
    }

    private static void escapeKey(StringBuilder sb, String key) {
        char[] chars = key.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\\') {
                int n = i + 1;
                if (n >= chars.length) {
                    sb.append('\\').append('\\');
                    continue;
                }
                char next = chars[n];
                if (next == '\\' || next == '=') {
                    sb.append(c);
                    sb.append(next);
                    i = n;
                    continue;
                }
                sb.append('\\').append('\\');
                continue;
            }
            if (c == '=') {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
    }

    private static void escapeValue(StringBuilder sb, String value) {
        if (value != null) {
            char[] chars = value.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == '\\') {
                    int n = i + 1;
                    if (n >= chars.length) {
                        sb.append('\\').append('\\');
                        continue;
                    }
                    char next = chars[n];
                    if (next == '\\' || next == ',') {
                        sb.append(c);
                        sb.append(next);
                        i = n;
                        continue;
                    }
                    sb.append('\\').append('\\');
                    continue;
                }
                if (c == ',') {
                    sb.append('\\').append(c);
                    continue;
                }
                sb.append(c);
            }
        }
    }

    private static class Expression {
        private final String key;
        private final String defaultValue;

        private Expression(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        static Expression of(ValueExpression value) {
            String expression = value.getExpressionString();
            AtomicReference keyRef = new AtomicReference();
            AtomicReference dftRef = new AtomicReference();
            org.wildfly.common.expression.Expression.compile((String)expression, (Expression.Flag[])new Expression.Flag[0]).evaluate((context, builder) -> {
                keyRef.set(context.getKey());
                if (context.hasDefault()) {
                    dftRef.set(context.getExpandedDefault());
                }
            });
            return new Expression((String)keyRef.get(), (String)dftRef.get());
        }

        String getKey() {
            return this.key;
        }

        boolean hasDefault() {
            return this.defaultValue != null;
        }

        String getDefaultValue() {
            return this.defaultValue;
        }

        void appendTo(StringBuilder builder) {
            builder.append("${").append(this.key);
            if (this.hasDefault()) {
                builder.append(':').append(this.defaultValue);
            }
            builder.append('}');
        }

        public String toString() {
            return "${" + this.key + (this.defaultValue != null ? ":" + this.defaultValue + "}" : "}");
        }
    }
}

