/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.launcher.BootableJarCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugins.bootablejar.maven.common.Utils;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class StartBootableJarMojo
extends AbstractServerConnection {
    @Parameter(alias="jvmArguments")
    public List<String> jvmArguments = new ArrayList<String>();
    @Parameter(alias="arguments")
    public List<String> arguments = new ArrayList<String>();
    @Parameter(property="wildfly.bootable.jvmArguments")
    public String jvmArgumentsProps;
    @Parameter(property="wildfly.bootable.arguments")
    public String argumentsProps;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="wildfly.bootable.start.skip")
    private boolean skip;
    @Parameter(alias="check-server-start", defaultValue="true", property="wildfly.bootable.start.check.start")
    private boolean checkStarted;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.bootable.start.timeout")
    private long startupTimeout;
    @Parameter(alias="id", defaultValue="60", property="wildfly.bootable.start.id")
    private String id;
    @Parameter(alias="jar-file-name", property="wildfly.bootable.start.jar.file.name")
    String jarFileName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doExecute(this.project);
    }

    private void doExecute(MavenProject project) throws MojoExecutionException, MojoFailureException {
        block19: {
            StringTokenizer args;
            if (this.skip) {
                this.getLog().debug((CharSequence)String.format("Skipping " + this.goal() + " of %s:%s", project.getGroupId(), project.getArtifactId()));
                return;
            }
            if (this.jvmArgumentsProps != null) {
                args = new StringTokenizer(this.jvmArgumentsProps);
                while (args.hasMoreTokens()) {
                    this.jvmArguments.add(args.nextToken());
                }
            }
            if (this.argumentsProps != null) {
                args = new StringTokenizer(this.argumentsProps);
                while (args.hasMoreTokens()) {
                    this.arguments.add(args.nextToken());
                }
            }
            BootableJarCommandBuilder commandBuilder = BootableJarCommandBuilder.of((String)Utils.getBootableJarPath(this.jarFileName, project, this.goal())).addJavaOptions(this.jvmArguments).addServerArguments(this.arguments);
            try {
                Process process = Launcher.of((CommandBuilder)commandBuilder).launch();
                if (!this.checkStarted) break block19;
                try (ModelControllerClient client = this.createClient();){
                    ServerHelper.waitForStandalone((Process)process, (ModelControllerClient)client, (long)this.startupTimeout);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), e);
            }
        }
    }

    public String goal() {
        return "start";
    }
}

