/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.cli;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import org.wildfly.plugins.bootablejar.maven.cli.CLIExecutor;
import org.wildfly.plugins.bootablejar.maven.cli.CLIForkedBootConfigGenerator;
import org.wildfly.plugins.bootablejar.maven.cli.CLIForkedExecutor;
import org.wildfly.plugins.bootablejar.maven.cli.ForkedCLIUtil;
import org.wildfly.plugins.bootablejar.maven.goals.AbstractBuildBootableJarMojo;

public class RemoteCLIExecutor
implements CLIExecutor {
    private final Level level;
    private final AbstractBuildBootableJarMojo mojo;
    private final Path output;
    private final Path jbossHome;
    private final String[] cp;
    private final boolean resolveExpression;

    public RemoteCLIExecutor(Path jbossHome, List<Path> cliArtifacts, AbstractBuildBootableJarMojo mojo, boolean resolveExpression) throws Exception {
        this.jbossHome = jbossHome;
        this.mojo = mojo;
        this.resolveExpression = resolveExpression;
        this.level = mojo.disableLog();
        this.output = File.createTempFile("cli-script-output", null).toPath();
        Files.deleteIfExists(this.output);
        this.cp = new String[cliArtifacts.size()];
        int i = 0;
        for (Path p : cliArtifacts) {
            this.cp[i] = p.toString();
            ++i;
        }
    }

    @Override
    public void handle(String command) throws Exception {
        throw new UnsupportedOperationException("handle is unsupported, call execute instead.");
    }

    @Override
    public String getOutput() throws Exception {
        StringBuilder out = new StringBuilder();
        for (String s : Files.readAllLines(this.output)) {
            out.append(s).append("\n");
        }
        return out.toString();
    }

    @Override
    public void close() throws Exception {
        try {
            Files.deleteIfExists(this.output);
        }
        finally {
            this.mojo.enableLog(this.level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(List<String> commands) throws Exception {
        Path script = File.createTempFile("cli-script", null).toPath();
        Files.deleteIfExists(script);
        Files.deleteIfExists(this.output);
        StringBuilder cmds = new StringBuilder();
        for (String cmd : commands) {
            cmds.append(cmd).append(System.lineSeparator());
        }
        Files.write(script, cmds.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String[] args = new String[]{script.toString(), Boolean.toString(this.resolveExpression)};
        try {
            ForkedCLIUtil.fork(this.mojo.getLog(), this.cp, CLIForkedExecutor.class, this.jbossHome, this.output, args);
        }
        finally {
            Files.deleteIfExists(script);
        }
    }

    @Override
    public void generateBootLoggingConfig() throws Exception {
        ForkedCLIUtil.fork(this.mojo.getLog(), this.cp, CLIForkedBootConfigGenerator.class, this.jbossHome, this.output, new String[0]);
    }
}

