/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.cloud;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.plugins.bootablejar.maven.cloud.JGroupsUtil;
import org.wildfly.plugins.bootablejar.maven.goals.BuildBootableJarMojo;

public class CloudConfig {
    private static final String OPENSHIFT = "openshift";
    private static final String KUBERNETES = "kubernetes";
    private boolean enableJgroupsPassword = false;
    private static final String[] CLI_SCRIPTS = new String[]{"openshift-management-script.cli", "openshift-logging-script.cli", "openshift-interfaces-script.cli", "openshift-https-script.cli", "openshift-undertow-script.cli", "openshift-tx-script.cli", "openshift-clustering-script.cli", "openshift-infinispan-script.cli", "openshift-webservices-script.cli"};
    String type = "openshift";
    private boolean enabled = true;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getEnableJGroupsPassword() {
        return this.enableJgroupsPassword;
    }

    public void setEnableJGroupsPassword(boolean enableJgroupsPassword) {
        this.enableJgroupsPassword = enableJgroupsPassword;
    }

    public void validate() throws MojoExecutionException {
        if (this.type != null) {
            switch (this.type) {
                case "openshift": 
                case "kubernetes": {
                    return;
                }
            }
            throw new MojoExecutionException("Invalid cloud type " + this.type + ". Can be " + OPENSHIFT + " or " + KUBERNETES);
        }
        this.type = OPENSHIFT;
    }

    public void copyExtraContent(BuildBootableJarMojo mojo, Path wildflyDir, Path contentDir) throws IOException, PlexusConfigurationException, MojoExecutionException {
        try (InputStream stream = CloudConfig.class.getResourceAsStream("logging.properties");){
            Path target = wildflyDir.resolve("standalone").resolve("configuration").resolve("logging.properties");
            Files.copy(stream, target, StandardCopyOption.REPLACE_EXISTING);
        }
        if (mojo.isJarPackaging()) {
            Path marker = contentDir.resolve(this.type + ".properties");
            Properties props = new Properties();
            try (FileOutputStream s = new FileOutputStream(marker.toFile());){
                props.store(s, this.type + " properties");
            }
            Path extensionJar = mojo.resolveArtifact("org.wildfly.plugins", "wildfly-jar-cloud-extension", null, mojo.retrievePluginVersion());
            ZipUtils.unzip((Path)extensionJar, (Path)contentDir);
        }
    }

    public Set<String> getExtraLayers(BuildBootableJarMojo mojo) {
        HashSet<String> set = new HashSet<String>();
        set.add("microprofile-health");
        set.add("core-tools");
        return set;
    }

    public void addCLICommands(BuildBootableJarMojo mojo, List<String> commands) throws Exception {
        Path p = mojo.getJBossHome();
        Path config = p.resolve("standalone").resolve("configuration").resolve("standalone.xml");
        if (this.enableJgroupsPassword) {
            commands.addAll(JGroupsUtil.getAuthProtocolCommands(config));
        }
        for (String script : CLI_SCRIPTS) {
            CloudConfig.addCommands(script, commands);
        }
    }

    private static void addCommands(String script, List<String> commands) throws Exception {
        try (InputStream stream = CloudConfig.class.getResourceAsStream(script);){
            List lines = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
            commands.addAll(lines);
        }
    }
}

