/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.common;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class Utils {
    public static final String NO_COLOR_OPTION = "-Dorg.jboss.logmanager.nocolor=true";
    private static final Pattern WHITESPACE_IF_NOT_QUOTED = Pattern.compile("(\\S+\"[^\"]+\")|\\S+");

    public static String getBootableJarPath(String jarFileName, MavenProject project, String goal) throws MojoExecutionException {
        String path;
        String jarName = jarFileName;
        if (jarName == null) {
            String finalName = project.getBuild().getFinalName();
            jarName = finalName + "-" + "bootable" + "." + "jar";
        }
        if (!Files.exists(Paths.get(path = project.getBuild().getDirectory() + File.separator + jarName, new String[0]), new LinkOption[0])) {
            throw new MojoExecutionException("Cannot " + goal + " without a bootable jar; please `mvn wildfly-jar:package` prior to invoking wildfly-jar:run from the command-line");
        }
        return path;
    }

    public static String getWildFlyPath(String serverDir, MavenProject project, String goal) throws MojoExecutionException {
        Path path = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(serverDir);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MojoExecutionException("Cannot " + goal + " without a server; please `mvn wildfly-jar:package` prior to invoking wildfly-jar:run from the command-line");
        }
        return path.toString();
    }

    public static Path getWildFlyLauncherPath(String serverDir, MavenProject project, String launchScript, String goal) throws MojoExecutionException {
        Path path = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(serverDir).resolve("bin").resolve(launchScript);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MojoExecutionException("The provided server launch script " + path + " doesn't exist.");
        }
        return path;
    }

    public static List<String> splitArguments(CharSequence arguments) {
        ArrayList<String> args = new ArrayList<String>();
        Matcher m = WHITESPACE_IF_NOT_QUOTED.matcher(arguments);
        while (m.find()) {
            String value = m.group();
            if (value.isEmpty()) continue;
            args.add(value);
        }
        return args;
    }
}

