/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.wildfly.core.launcher.BootableJarCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugins.bootablejar.maven.common.Utils;
import org.wildfly.plugins.bootablejar.maven.goals.ServerModeConfig;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
public final class RunBootableJarMojo
extends AbstractMojo {
    @Parameter(property="wildfly.bootable.jvmArguments")
    public List<String> jvmArguments = new ArrayList<String>();
    @Parameter(property="wildfly.bootable.arguments")
    public List<String> arguments = new ArrayList<String>();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="wildfly.bootable.run.skip")
    private boolean skip;
    @Parameter(alias="jar-file-name", property="wildfly.bootable.run.jar.file.name")
    String jarFileName;
    @Parameter(alias="server")
    ServerModeConfig server;

    private boolean isJarPackaging() {
        return this.server == null || !this.server.isEnabled();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping run of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        try {
            Launcher launcher;
            if (this.isJarPackaging()) {
                BootableJarCommandBuilder builder = BootableJarCommandBuilder.of((String)Utils.getBootableJarPath(this.jarFileName, this.project, "run")).addJavaOptions(this.jvmArguments).addServerArguments(this.arguments);
                launcher = Launcher.of((CommandBuilder)builder);
            } else {
                launcher = this.server.createServerLauncher(this.project, this.jvmArguments, this.arguments, false, "run");
            }
            Process process = launcher.inherit().launch();
            process.waitFor();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), e);
        }
    }

    public void setJvmArguments(String jvmArguments) {
        this.jvmArguments = Utils.splitArguments(jvmArguments);
    }

    public void setArguments(String arguments) {
        this.arguments = Utils.splitArguments(arguments);
    }
}

