/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlWriter;
import org.wildfly.plugins.bootablejar.maven.cli.CLIExecutor;
import org.wildfly.plugins.bootablejar.maven.cli.LocalCLIExecutor;
import org.wildfly.plugins.bootablejar.maven.cli.RemoteCLIExecutor;
import org.wildfly.plugins.bootablejar.maven.common.ExternalDeploymentArtifact;
import org.wildfly.plugins.bootablejar.maven.common.FeaturePack;
import org.wildfly.plugins.bootablejar.maven.common.LegacyPatchCleaner;
import org.wildfly.plugins.bootablejar.maven.common.MavenRepositoriesEnricher;
import org.wildfly.plugins.bootablejar.maven.common.OverriddenArtifact;
import org.wildfly.plugins.bootablejar.maven.common.Utils;
import org.wildfly.plugins.bootablejar.maven.goals.BootLoggingConfiguration;
import org.wildfly.plugins.bootablejar.maven.goals.CliSession;
import org.wildfly.plugins.bootablejar.maven.goals.MavenProjectArtifactVersions;
import org.wildfly.plugins.bootablejar.maven.goals.MavenUpgrade;
import org.wildfly.plugins.bootablejar.maven.goals.ServerModeConfig;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractBuildBootableJarMojo
extends AbstractMojo {
    public static final String BOOTABLE_SUFFIX = "bootable";
    public static final String JAR = "jar";
    public static final String WAR = "war";
    private static final String MODULE_ID_JAR_RUNTIME = "org.wildfly.bootable-jar";
    private static final String BOOT_ARTIFACT_ID = "wildfly-jar-boot";
    private static final String STANDALONE = "standalone";
    private static final String STANDALONE_XML = "standalone.xml";
    private static final String STANDALONE_MICROPROFILE_XML = "standalone-microprofile.xml";
    private static final String SERVER_CONFIG = "--server-config";
    private static final String MAVEN_REPO_PLUGIN_OPTION = "jboss-maven-repo";
    private static final String JBOSS_MAVEN_DIST = "jboss-maven-dist";
    private static final String JBOSS_PROVISIONING_MAVEN_REPO = "jboss-maven-provisioning-repo";
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    private static final String PLUGIN_PROVISIONING_FILE = ".wildfly-jar-plugin-provisioning.xml";
    static final String WILDFLY_ARTIFACT_VERSIONS_RESOURCE_PATH = "wildfly/artifact-versions.properties";
    @Component
    RepositorySystem repoSystem;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Parameter(alias="plugin-options", required=false)
    Map<String, String> pluginOptions = Collections.emptyMap();
    @Parameter(alias="offline", defaultValue="false")
    boolean offline;
    @Parameter(alias="log-time", defaultValue="false")
    boolean logTime;
    @Parameter(alias="layers", required=false)
    List<String> layers = Collections.emptyList();
    @Parameter(alias="excluded-layers", required=false)
    List<String> excludedLayers = Collections.emptyList();
    @Parameter(alias="record-state", defaultValue="false")
    boolean recordState;
    @Parameter(defaultValue="${project.build.directory}")
    String projectBuildDir;
    @Parameter(alias="context-root", defaultValue="true", property="wildfly.bootable.context.root")
    boolean contextRoot;
    @Parameter(alias="feature-pack-location", required=false, property="wildfly.bootable.fpl")
    String featurePackLocation;
    @Parameter(alias="cli-sessions")
    List<CliSession> cliSessions = Collections.emptyList();
    @Parameter(alias="hollow-jar", property="wildfly.bootable.hollow")
    boolean hollowJar;
    @Parameter(defaultValue="false", property="wildfly.bootable.package.skip")
    boolean skip;
    @Parameter(alias="output-file-name", property="wildfly.bootable.package.output.file.name")
    String outputFileName;
    @Parameter(alias="feature-packs", required=false)
    List<FeaturePack> featurePacks = Collections.emptyList();
    @Parameter(alias="extra-server-content-dirs", property="wildfly.bootable.package.extra.server.content.dirs")
    List<String> extraServerContentDirs = Collections.emptyList();
    @Parameter(alias="provisioning-file", property="wildfly.bootable.provisioning.file", defaultValue="${project.basedir}/galleon/provisioning.xml")
    private File provisioningFile;
    @Parameter(alias="legacy-patch-cli-script")
    String legacyPatchCliScript;
    @Parameter(alias="legacy-patch-clean-up", defaultValue="false")
    boolean legacyPatchCleanUp;
    @Parameter(alias="display-cli-scripts-output")
    boolean displayCliScriptsOutput;
    @Parameter(alias="boot-logging-config", property="wildfly.bootable.logging.config")
    private File bootLoggingConfig;
    @Parameter(alias="bootable-jar-build-artifacts", property="wildfly.bootable.jar.build.artifacts", defaultValue="bootable-jar-build-artifacts")
    private String bootableJarBuildArtifacts;
    @Parameter(alias="overridden-server-artifacts")
    List<OverriddenArtifact> overriddenServerArtifacts = Collections.emptyList();
    @Parameter(alias="dump-original-artifacts", property="bootable.jar.dump.original.artifacts", defaultValue="false")
    boolean dumpOriginalArtifacts;
    @Parameter(alias="disable-warn-for-artifact-downgrade", property="bootable.jar.disable.warn.for.artifact.downgrade", defaultValue="false")
    boolean disableWarnForArtifactDowngrade;
    @Parameter(alias="server")
    ServerModeConfig server;
    @Parameter(alias="external-deployments")
    private List<ExternalDeploymentArtifact> externalDeployments = Collections.emptyList();
    MavenProjectArtifactVersions artifactVersions;
    @Inject
    private BootLoggingConfiguration bootLoggingConfiguration;
    private final Set<String> extraLayers = new HashSet<String>();
    private Path wildflyDir;
    private MavenRepoManager artifactResolver;
    private final Set<Artifact> cliArtifacts = new HashSet<Artifact>();
    private boolean forkCli;
    private Path provisioningMavenRepo;
    private String jakartaTransformSuffix;
    private Set<String> transformExcluded = new HashSet<String>();

    public Path getJBossHome() {
        return this.wildflyDir;
    }

    public boolean isJarPackaging() {
        return this.server == null || !this.server.isEnabled();
    }

    public String getServerDirectoryName() {
        return this.server == null ? null : this.server.getDirectoryName();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String originalLocalRepo;
        Path jarFile;
        block46: {
            Artifact bootArtifact;
            MavenRepositoriesEnricher.enrich(this.session, this.project, this.repositories);
            MavenArtifactRepositoryManager mavenArtifactRepositoryManager = this.artifactResolver = this.offline ? new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession) : new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
            if (this.outputFileName == null) {
                this.outputFileName = this.project.getBuild().getFinalName() + "-" + BOOTABLE_SUFFIX + "." + JAR;
            }
            this.artifactVersions = MavenProjectArtifactVersions.getInstance(this.project);
            this.validateProjectFile();
            if (this.isPackageDev()) {
                Path deployments = this.getDeploymentsDir();
                IoUtils.recursiveDelete((Path)deployments);
                try {
                    Files.createDirectory(deployments, new FileAttribute[0]);
                    this.copyProjectFile(deployments);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Fail creating deployments directory ", (Exception)ex);
                }
                return;
            }
            Path contentRoot = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.bootableJarBuildArtifacts);
            if (Files.exists(contentRoot, new LinkOption[0])) {
                AbstractBuildBootableJarMojo.deleteDir(contentRoot);
            }
            jarFile = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.outputFileName);
            IoUtils.recursiveDelete((Path)contentRoot);
            if (this.isJarPackaging()) {
                this.wildflyDir = contentRoot.resolve("wildfly");
            } else {
                this.getLog().info((CharSequence)"Server mode is enabled");
                this.wildflyDir = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.getServerDirectoryName());
            }
            IoUtils.recursiveDelete((Path)this.wildflyDir);
            Path contentDir = contentRoot.resolve("jar-content");
            try {
                Files.createDirectories(contentRoot, new FileAttribute[0]);
                Files.createDirectories(contentDir, new FileAttribute[0]);
                Files.deleteIfExists(jarFile);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Packaging wildfly failed", (Exception)ex);
            }
            try {
                bootArtifact = this.provisionServer(this.wildflyDir, contentDir.resolve("provisioning.xml"), contentRoot);
            }
            catch (IOException | XMLStreamException | ProvisioningException ex) {
                throw new MojoExecutionException("Provisioning failed", (Exception)ex);
            }
            originalLocalRepo = null;
            try {
                this.forkCli = Boolean.parseBoolean(this.pluginOptions.getOrDefault("jboss-fork-embedded", "false"));
                if (this.forkCli) {
                    this.getLog().info((CharSequence)"CLI executions are done in forked process");
                }
                String provisioningRepo = this.pluginOptions.get(JBOSS_PROVISIONING_MAVEN_REPO);
                String generatedRepo = this.pluginOptions.get(MAVEN_REPO_PLUGIN_OPTION);
                if (this.isThinServer()) {
                    if (generatedRepo != null) {
                        Path repo = Paths.get(generatedRepo, new String[0]);
                        originalLocalRepo = System.getProperty(MAVEN_REPO_LOCAL);
                        System.setProperty(MAVEN_REPO_LOCAL, repo.toAbsolutePath().toString());
                    } else if (provisioningRepo != null) {
                        this.provisioningMavenRepo = Paths.get(provisioningRepo, new String[0]);
                        originalLocalRepo = System.getProperty(MAVEN_REPO_LOCAL);
                        System.setProperty(MAVEN_REPO_LOCAL, this.provisioningMavenRepo.toAbsolutePath().toString());
                    }
                }
                this.legacyPatching();
                this.copyExtraContentInternal(this.wildflyDir, contentDir);
                this.copyExtraContent(this.wildflyDir);
                ArrayList<String> commands = new ArrayList<String>();
                this.deploy(commands);
                ArrayList<String> serverConfigCommands = new ArrayList<String>();
                this.configureCli(serverConfigCommands);
                commands.addAll(serverConfigCommands);
                if (!commands.isEmpty()) {
                    this.executeCliScript(this.wildflyDir, commands, null, false, "Server configuration", true);
                    if (!serverConfigCommands.isEmpty()) {
                        Path genCliScript = contentRoot.resolve("generated-cli-script.txt");
                        try (BufferedWriter writer = Files.newBufferedWriter(genCliScript, StandardCharsets.UTF_8, new OpenOption[0]);){
                            for (String str : serverConfigCommands) {
                                writer.write(str);
                                writer.newLine();
                            }
                        }
                        this.getLog().info((CharSequence)("Stored CLI script executed to update server configuration in " + genCliScript + " file."));
                    }
                }
                this.userScripts(this.wildflyDir, this.cliSessions, true);
                Path loggingFile = this.copyLoggingFile(contentRoot);
                if (this.bootLoggingConfig == null) {
                    if (this.isJarPackaging()) {
                        this.generateLoggingConfig(this.wildflyDir);
                    }
                } else {
                    Path loggingConfig = this.resolvePath(this.bootLoggingConfig.toPath());
                    if (Files.notExists(loggingConfig, new LinkOption[0])) {
                        throw new MojoExecutionException(String.format("The bootLoggingConfig %s does not exist.", loggingConfig));
                    }
                    Path target = this.getJBossHome().resolve(STANDALONE).resolve("configuration").resolve("logging.properties");
                    Files.copy(loggingConfig, target, StandardCopyOption.REPLACE_EXISTING);
                }
                this.cleanupServer(this.wildflyDir);
                if (this.isJarPackaging()) {
                    AbstractBuildBootableJarMojo.zipServer(this.wildflyDir, contentDir);
                    this.buildJar(contentDir, jarFile, bootArtifact);
                    this.restoreLoggingFile(loggingFile);
                    break block46;
                }
                IoUtils.recursiveDelete((Path)contentRoot);
            }
            catch (Exception ex) {
                try {
                    if (ex instanceof MojoExecutionException) {
                        throw (MojoExecutionException)ex;
                    }
                    if (ex instanceof MojoFailureException) {
                        throw (MojoFailureException)ex;
                    }
                    throw new MojoExecutionException("Packaging wildfly failed", ex);
                }
                catch (Throwable throwable) {
                    System.clearProperty("module.path");
                    if (originalLocalRepo != null) {
                        System.setProperty(MAVEN_REPO_LOCAL, originalLocalRepo);
                    }
                    throw throwable;
                }
            }
        }
        System.clearProperty("module.path");
        if (originalLocalRepo != null) {
            System.setProperty(MAVEN_REPO_LOCAL, originalLocalRepo);
        }
        if (this.isJarPackaging()) {
            this.attachJar(jarFile);
        }
    }

    protected boolean isPackageDev() {
        return System.getProperty("dev") != null;
    }

    private Path copyLoggingFile(Path contentRoot) throws IOException {
        Path configDir = this.getJBossHome().resolve(STANDALONE).resolve("configuration");
        Path loggingFile = configDir.resolve("logging.properties");
        Path originalLoggingFile = contentRoot.resolve("logging.properties");
        if (Files.exists(loggingFile, new LinkOption[0])) {
            Files.copy(loggingFile, originalLoggingFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return originalLoggingFile;
    }

    private void restoreLoggingFile(Path originalLoggingFile) throws IOException {
        if (Files.exists(originalLoggingFile, new LinkOption[0])) {
            Path configDir = this.getJBossHome().resolve(STANDALONE).resolve("configuration");
            Path bootableLoggingFile = configDir.resolve("wildfly-jar-generated-logging.properties");
            Path loggingFile = configDir.resolve("logging.properties");
            Files.copy(loggingFile, bootableLoggingFile, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(originalLoggingFile, loggingFile, StandardCopyOption.REPLACE_EXISTING);
            Files.delete(originalLoggingFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void legacyPatching() throws Exception {
        if (this.legacyPatchCliScript != null) {
            LegacyPatchCleaner patchCleaner = null;
            if (this.legacyPatchCleanUp) {
                patchCleaner = new LegacyPatchCleaner(this.wildflyDir, this.getLog());
            }
            String prop = "jboss.home.dir";
            System.setProperty(prop, this.wildflyDir.toAbsolutePath().toString());
            try {
                Path patchScript = this.resolvePath(Paths.get(this.legacyPatchCliScript, new String[0]));
                if (Files.notExists(patchScript, new LinkOption[0])) {
                    throw new Exception("Patch CLI script " + patchScript + " doesn't exist");
                }
                ArrayList<CliSession> cliPatchingSessions = new ArrayList<CliSession>();
                ArrayList<String> files = new ArrayList<String>();
                files.add(patchScript.toString());
                CliSession patchingSession = new CliSession();
                patchingSession.setResolveExpressions(true);
                patchingSession.setScriptFiles(files);
                cliPatchingSessions.add(patchingSession);
                this.getLog().info((CharSequence)("Patching server with " + patchScript + " CLI script."));
                this.userScripts(this.wildflyDir, cliPatchingSessions, false);
                if (patchCleaner != null) {
                    patchCleaner.clean();
                }
            }
            finally {
                System.clearProperty(prop);
            }
        }
    }

    private void copyExtraContent(Path wildflyDir) throws Exception {
        for (String path : this.extraServerContentDirs) {
            Path extraContent = Paths.get(path, new String[0]);
            if (Files.notExists(extraContent = this.resolvePath(extraContent), new LinkOption[0])) {
                throw new Exception("Extra content dir " + extraContent + " doesn't exist");
            }
            this.warnExtraConfig(extraContent);
            IoUtils.copy((Path)extraContent, (Path)wildflyDir);
        }
    }

    private void warnExtraConfig(Path extraContentDir) {
        Path config = extraContentDir.resolve(STANDALONE).resolve("configurations").resolve(STANDALONE_XML);
        if (Files.exists(config, new LinkOption[0])) {
            this.getLog().warn((CharSequence)("The file " + config + " overrides the Galleon generated configuration, un-expected behavior can occur when starting the bootable JAR"));
        }
    }

    protected void copyExtraContentInternal(Path wildflyDir, Path contentDir) throws Exception {
    }

    protected void addExtraLayer(String layer) {
        this.extraLayers.add(layer);
    }

    private void copyProjectFile(Path targetDir) throws IOException, MojoExecutionException {
        if (this.hollowJar) {
            this.getLog().info((CharSequence)"Hollow jar, No application deployment added to server.");
            return;
        }
        File f = this.validateProjectFile();
        String fileName = f.getName();
        if ((this.project.getPackaging().equals(WAR) || fileName.endsWith(WAR)) && this.contextRoot) {
            fileName = "ROOT.war";
        }
        Files.copy(f.toPath(), targetDir.resolve(fileName), new CopyOption[0]);
    }

    protected Path getDeploymentsDir() {
        return Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("deployments");
    }

    protected void configureCli(List<String> commands) {
    }

    private void cleanupServer(Path jbossHome) throws IOException {
        Path history = jbossHome.resolve(STANDALONE).resolve("configuration").resolve("standalone_xml_history");
        IoUtils.recursiveDelete((Path)history);
        Path tmp = jbossHome.resolve(STANDALONE).resolve("tmp");
        IoUtils.recursiveDelete((Path)tmp);
        Path log = jbossHome.resolve(STANDALONE).resolve("log");
        IoUtils.recursiveDelete((Path)log);
        Files.deleteIfExists(jbossHome.resolve("README.txt"));
    }

    protected File validateProjectFile() throws MojoExecutionException {
        File f = this.getProjectFile();
        if (f == null && !this.hollowJar && this.externalDeployments.isEmpty()) {
            throw new MojoExecutionException("Cannot package without a primary artifact; please `mvn package` prior to invoking wildfly-jar:package from the command-line");
        }
        return f;
    }

    private void userScripts(Path wildflyDir, List<CliSession> sessions, boolean startEmbedded) throws Exception {
        for (CliSession session : sessions) {
            ArrayList<String> commands = new ArrayList<String>();
            for (String path : session.getScriptFiles()) {
                File f = new File(path);
                Path filePath = this.resolvePath(f.toPath());
                if (Files.notExists(filePath, new LinkOption[0])) {
                    throw new RuntimeException("Cli script file " + filePath + " doesn't exist");
                }
                BufferedReader reader = new BufferedReader(new FileReader(filePath.toFile()));
                Throwable throwable = null;
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        commands.add(line.trim());
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            if (commands.isEmpty()) continue;
            this.executeCliScript(wildflyDir, commands, session.getPropertiesFile(), session.getResolveExpression(), session.toString(), startEmbedded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCliScript(Path jbossHome, List<String> commands, String propertiesFile, boolean resolveExpression, String message, boolean startEmbedded) throws Exception {
        this.getLog().info((CharSequence)("Executing CLI, " + message));
        Properties props = null;
        if (propertiesFile != null) {
            props = this.loadProperties(propertiesFile);
        }
        try {
            this.processCLI(jbossHome, commands, resolveExpression, startEmbedded);
        }
        finally {
            if (props != null) {
                for (String key : props.stringPropertyNames()) {
                    WildFlySecurityManager.clearPropertyPrivileged((String)key);
                }
            }
        }
    }

    private void generateLoggingConfig(Path wildflyDir) throws Exception {
        try (CLIExecutor cmdCtx = this.forkCli ? new RemoteCLIExecutor(wildflyDir, this.getCLIArtifacts(), this, false) : new LocalCLIExecutor(wildflyDir, this.getCLIArtifacts(), this, false, this.bootLoggingConfiguration);){
            try {
                cmdCtx.generateBootLoggingConfig();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Failed to generate logging configuration: " + cmdCtx.getOutput()));
                throw e;
            }
        }
    }

    private void processCLI(Path jbossHome, List<String> commands, boolean resolveExpression, boolean startEmbedded) throws Exception {
        ArrayList<String> allCommands = new ArrayList<String>();
        if (startEmbedded) {
            allCommands.add("embed-server --jboss-home=" + jbossHome + " --std-out=discard");
        }
        for (String line : commands) {
            allCommands.add(line.trim());
        }
        if (startEmbedded) {
            allCommands.add("stop-embedded-server");
        }
        try (CLIExecutor executor = this.forkCli ? new RemoteCLIExecutor(jbossHome, this.getCLIArtifacts(), this, resolveExpression) : new LocalCLIExecutor(jbossHome, this.getCLIArtifacts(), this, resolveExpression, this.bootLoggingConfiguration);){
            try {
                executor.execute(allCommands);
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)("Error executing CLI script " + ex.getLocalizedMessage()));
                this.getLog().error((CharSequence)executor.getOutput());
                throw ex;
            }
            if (this.displayCliScriptsOutput) {
                this.getLog().info((CharSequence)executor.getOutput());
            }
        }
        this.getLog().info((CharSequence)"CLI scripts execution done.");
    }

    private List<Path> getCLIArtifacts() throws MojoExecutionException {
        this.debug("CLI artifacts %s", this.cliArtifacts);
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.wildflyDir.resolve("jboss-modules.jar"));
        for (Artifact a : this.cliArtifacts) {
            paths.add(this.resolveArtifact(a));
        }
        return paths;
    }

    public Level disableLog() {
        Logger l = Logger.getLogger("");
        Level level = l.getLevel();
        if (!this.getLog().isDebugEnabled()) {
            l.setLevel(Level.OFF);
        }
        return level;
    }

    public void enableLog(Level level) {
        Logger l = Logger.getLogger("");
        l.setLevel(level);
    }

    private Path resolvePath(Path path) {
        if (!path.isAbsolute()) {
            path = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]).resolve(path);
        }
        return path;
    }

    private Properties loadProperties(String propertiesFile) throws Exception {
        File f = new File(propertiesFile);
        Path filePath = this.resolvePath(f.toPath());
        if (Files.notExists(filePath, new LinkOption[0])) {
            throw new RuntimeException("Cli properties file " + filePath + " doesn't exist");
        }
        Properties props = new Properties();
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(filePath.toFile()), StandardCharsets.UTF_8);){
            props.load(inputStreamReader);
        }
        catch (IOException e) {
            throw new Exception("Failed to load properties from " + propertiesFile + ": " + e.getLocalizedMessage());
        }
        for (String key : props.stringPropertyNames()) {
            WildFlySecurityManager.setPropertyPrivileged((String)key, (String)props.getProperty(key));
        }
        return props;
    }

    private File getProjectFile() {
        if (this.project.getArtifact().getFile() != null) {
            return this.project.getArtifact().getFile();
        }
        String finalName = this.project.getBuild().getFinalName();
        Path candidate = Paths.get(this.projectBuildDir, finalName + "." + this.project.getPackaging());
        if (Files.exists(candidate, new LinkOption[0])) {
            return candidate.toFile();
        }
        return null;
    }

    protected Path getProvisioningFile() {
        return this.resolvePath(this.provisioningFile.toPath());
    }

    protected boolean hasLayers() {
        return !this.layers.isEmpty();
    }

    protected List<String> getLayers() {
        return this.layers;
    }

    protected List<String> getExcludedLayers() {
        return this.excludedLayers;
    }

    private GalleonConfig buildFeaturePacksConfig(ProvisioningManager pm, boolean hasLayers) throws ProvisioningException, MojoExecutionException {
        ProvisioningConfig.Builder state = ProvisioningConfig.builder();
        ConfigId provisionedConfigId = null;
        for (FeaturePack fp : this.featurePacks) {
            FeaturePackLocation fpl;
            if (fp.getLocation() == null && (fp.getGroupId() == null || fp.getArtifactId() == null) && fp.getNormalizedPath() == null) {
                throw new MojoExecutionException("Feature-pack location, Maven GAV or feature pack path is missing");
            }
            if (fp.getNormalizedPath() != null) {
                fpl = pm.getLayoutFactory().addLocal(fp.getNormalizedPath(), false);
            } else if (fp.getGroupId() != null && fp.getArtifactId() != null) {
                String coords = fp.getMavenCoords();
                fpl = FeaturePackLocation.fromString((String)coords);
            } else {
                fpl = FeaturePackLocation.fromString((String)fp.getLocation());
            }
            FeaturePackConfig.Builder fpConfig = FeaturePackConfig.builder((FeaturePackLocation)fpl);
            fpConfig.setInheritConfigs(false);
            if (fp.isInheritPackages() != null) {
                fpConfig.setInheritPackages(fp.isInheritPackages().booleanValue());
            }
            if (fp.getIncludedDefaultConfig() != null) {
                ConfigId includedConfigId = new ConfigId(STANDALONE, fp.getIncludedDefaultConfig());
                fpConfig.includeDefaultConfig(includedConfigId);
                if (provisionedConfigId == null) {
                    provisionedConfigId = includedConfigId;
                } else if (!provisionedConfigId.getName().equals(fp.getIncludedDefaultConfig())) {
                    throw new ProvisioningException("Feature-packs are not including the same default config");
                }
            } else if (!hasLayers && provisionedConfigId == null) {
                provisionedConfigId = this.getDefaultConfig();
                fpConfig.includeDefaultConfig(provisionedConfigId);
            }
            if (!fp.getIncludedPackages().isEmpty()) {
                for (String includedPackage : fp.getIncludedPackages()) {
                    fpConfig.includePackage(includedPackage);
                }
            }
            if (!fp.getExcludedPackages().isEmpty()) {
                for (String excludedPackage : fp.getExcludedPackages()) {
                    fpConfig.excludePackage(excludedPackage);
                }
            }
            state.addFeaturePackDep(fpConfig.build());
        }
        if (hasLayers) {
            this.getLog().info((CharSequence)"Provisioning server configuration based on the set of configured layers");
        } else {
            this.getLog().info((CharSequence)("Provisioning server configuration based on the " + provisionedConfigId.getName() + " default configuration."));
        }
        return hasLayers ? new LayersFeaturePacksConfig(state) : new DefaultFeaturePacksConfig(provisionedConfigId, state);
    }

    private static ConfigModel.Builder buildDefaultConfigBuilder(ConfigId defaultConfigId) {
        Objects.requireNonNull(defaultConfigId);
        ConfigModel.Builder configBuilder = ConfigModel.builder((String)defaultConfigId.getModel(), (String)defaultConfigId.getName());
        configBuilder.setProperty(SERVER_CONFIG, STANDALONE_XML);
        return configBuilder;
    }

    private void normalizeFeaturePackList() throws MojoExecutionException {
        if (this.featurePackLocation != null && !this.featurePacks.isEmpty()) {
            throw new MojoExecutionException("feature-pack-location can't be used with a list of feature-packs");
        }
        if (this.featurePackLocation != null) {
            this.featurePackLocation = MavenUpgrade.locationWithVersion(this.featurePackLocation, this.artifactVersions);
            this.featurePacks = new ArrayList<FeaturePack>();
            FeaturePack fp = new FeaturePack();
            fp.setLocation(this.featurePackLocation);
            this.featurePacks.add(fp);
        } else {
            for (FeaturePack fp : this.featurePacks) {
                if (fp.getLocation() != null) {
                    fp.setLocation(MavenUpgrade.locationWithVersion(fp.getLocation(), this.artifactVersions));
                    continue;
                }
                if (fp.getGroupId() == null || fp.getArtifactId() == null) {
                    throw new MojoExecutionException("Invalid Maven coordinates for galleon feature-pack ");
                }
                if (fp.getVersion() != null) continue;
                Artifact fpArtifact = this.artifactVersions.getFeaturePackArtifact(fp.getGroupId(), fp.getArtifactId(), fp.getClassifier());
                if (fpArtifact == null) {
                    throw new MojoExecutionException("No version found for " + fp.getGAC());
                }
                fp.setVersion(fpArtifact.getVersion());
            }
        }
    }

    private GalleonConfig buildGalleonConfig(ProvisioningManager pm) throws ProvisioningException, MojoExecutionException {
        boolean isLayerBasedConfig = !this.layers.isEmpty();
        boolean hasFeaturePack = !this.featurePacks.isEmpty();
        boolean hasProvisioningFile = Files.exists(this.getProvisioningFile(), new LinkOption[0]);
        if (!hasFeaturePack && !hasProvisioningFile) {
            throw new ProvisioningException("No valid provisioning configuration, you must set a feature-pack-location, a list of feature-packs or use a provisioning.xml file");
        }
        if (hasFeaturePack && hasProvisioningFile) {
            this.getLog().warn((CharSequence)("Feature packs defined in pom.xml override provisioning file located in " + this.getProvisioningFile()));
        }
        if (isLayerBasedConfig) {
            if (!hasFeaturePack) {
                throw new ProvisioningException("No server feature-pack location to provision layers, you must set a feature-pack-location");
            }
            return this.buildFeaturePacksConfig(pm, true);
        }
        if (!this.featurePacks.isEmpty()) {
            this.getLog().info((CharSequence)"Provisioning server using feature-packs");
            return this.buildFeaturePacksConfig(pm, isLayerBasedConfig);
        }
        if (hasProvisioningFile) {
            this.getLog().info((CharSequence)("Provisioning server using " + this.getProvisioningFile()));
            return new ProvisioningFileConfig();
        }
        throw new ProvisioningException("Invalid Galleon configuration");
    }

    private void willProvision(List<FeaturePack> featurePacks, ProvisioningManager pm) throws MojoExecutionException, ProvisioningException, IOException {
        Utils.ProvisioningSpecifics specifics = Utils.getSpecifics(featurePacks, pm);
        this.willProvision(specifics);
    }

    protected abstract void willProvision(Utils.ProvisioningSpecifics var1) throws MojoExecutionException;

    private Artifact provisionServer(Path home, Path outputProvisioningFile, Path workDir) throws ProvisioningException, MojoExecutionException, IOException, XMLStreamException {
        try (ProvisioningManager pm = ((ProvisioningManager.Builder)ProvisioningManager.builder().addArtifactResolver((RepositoryArtifactResolver)this.artifactResolver)).setInstallationHome(home).setMessageWriter((MessageWriter)new MvnMessageWriter(this.getLog())).setLogTime(this.logTime).setRecordState(this.recordState).build();){
            this.normalizeFeaturePackList();
            this.willProvision(this.featurePacks, pm);
            ProvisioningConfig config = this.buildGalleonConfig(pm).buildConfig();
            IoUtils.recursiveDelete((Path)home);
            this.getLog().info((CharSequence)("Building server based on " + config.getFeaturePackDeps() + " galleon feature-packs"));
            MavenUpgrade mavenUpgrade = new MavenUpgrade(this, config, pm);
            if (this.dumpOriginalArtifacts) {
                Path file = workDir.resolve("bootable-jar-server-original-artifacts.xml");
                this.getLog().info((CharSequence)("Dumping original Maven artifacts in " + file));
                mavenUpgrade.dumpArtifacts(file);
            }
            config = mavenUpgrade.upgrade();
            try (FileWriter writer = new FileWriter(outputProvisioningFile.toFile());){
                ProvisioningXmlWriter.getInstance().write((Object)config, (Writer)writer);
            }
            ProvisioningRuntime rt = pm.getRuntime(config);
            Artifact bootArtifact = null;
            for (FeaturePackRuntime fprt : rt.getFeaturePacks()) {
                HashMap<String, String> propsMap;
                Path artifactProps;
                if (fprt.getPackage(MODULE_ID_JAR_RUNTIME) != null) {
                    artifactProps = fprt.getResource(new String[]{WILDFLY_ARTIFACT_VERSIONS_RESOURCE_PATH});
                    propsMap = new HashMap<String, String>();
                    try {
                        AbstractBuildBootableJarMojo.readProperties(artifactProps, propsMap);
                    }
                    catch (Exception ex) {
                        throw new MojoExecutionException("Error reading artifact versions", ex);
                    }
                    if (this.isJarPackaging()) {
                        for (Map.Entry entry : propsMap.entrySet()) {
                            String value = (String)entry.getValue();
                            Artifact a = AbstractBuildBootableJarMojo.getArtifact(value);
                            if (!BOOT_ARTIFACT_ID.equals(a.getArtifactId())) continue;
                            this.getLog().info((CharSequence)("Found boot artifact " + a + " in " + mavenUpgrade.getMavenFeaturePack(fprt.getFPID())));
                            bootArtifact = a;
                            break;
                        }
                    }
                }
                artifactProps = fprt.getResource(new String[]{WILDFLY_ARTIFACT_VERSIONS_RESOURCE_PATH});
                propsMap = new HashMap();
                try {
                    AbstractBuildBootableJarMojo.readProperties(artifactProps, propsMap);
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("Error reading artifact versions", ex);
                }
                Path tasksProps = fprt.getResource(new String[]{"wildfly/wildfly-tasks.properties"});
                HashMap<String, String> tasksMap = new HashMap<String, String>();
                try {
                    AbstractBuildBootableJarMojo.readProperties(tasksProps, tasksMap);
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("Error reading artifact versions", ex);
                }
                this.jakartaTransformSuffix = (String)tasksMap.get("jakarta.transform.artifacts.suffix");
                Path excludedArtifacts = fprt.getResource(new String[]{"wildfly-jakarta-transform-excludes.txt"});
                if (Files.exists(excludedArtifacts, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(excludedArtifacts, StandardCharsets.UTF_8);){
                        String line = reader.readLine();
                        while (line != null) {
                            this.transformExcluded = CollectionUtils.add(this.transformExcluded, (Object)line);
                            line = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        throw new ProvisioningException(Errors.readFile((Path)excludedArtifacts), (Throwable)e);
                    }
                }
                for (Map.Entry entry : propsMap.entrySet()) {
                    String value = (String)entry.getValue();
                    Artifact a = AbstractBuildBootableJarMojo.getArtifact(value);
                    if ("wildfly-cli".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        this.debug("Found cli artifact %s in %s", a, mavenUpgrade.getMavenFeaturePack(fprt.getFPID()));
                        this.cliArtifacts.add((Artifact)new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), "provided", JAR, "client", (ArtifactHandler)new DefaultArtifactHandler(JAR)));
                        continue;
                    }
                    if ("wildfly-patching".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        this.debug("Found patching artifact %s in %s", a, mavenUpgrade.getMavenFeaturePack(fprt.getFPID()));
                        this.cliArtifacts.add(a);
                        continue;
                    }
                    if ("wildfly-controller".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        this.debug("Found controller artifact %s in %s", a, mavenUpgrade.getMavenFeaturePack(fprt.getFPID()));
                        this.cliArtifacts.add(a);
                        continue;
                    }
                    if ("wildfly-version".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        this.debug("Found version artifact %s in %s", a, mavenUpgrade.getMavenFeaturePack(fprt.getFPID()));
                        this.cliArtifacts.add(a);
                    }
                    if (!"vdx-core".equals(a.getArtifactId()) || !"org.projectodd.vdx".equals(a.getGroupId())) continue;
                    this.debug("Found vdx-core artifact %s in %s", a, mavenUpgrade.getMavenFeaturePack(fprt.getFPID()));
                    this.cliArtifacts.add(a);
                }
            }
            if (this.isJarPackaging() && bootArtifact == null) {
                throw new ProvisioningException("Server doesn't support bootable jar packaging");
            }
            pm.provision(rt.getLayout());
            if (!this.recordState) {
                Path file = home.resolve(PLUGIN_PROVISIONING_FILE);
                try (FileWriter writer = new FileWriter(file.toFile());){
                    ProvisioningXmlWriter.getInstance().write((Object)config, (Writer)writer);
                }
            }
            Iterator iterator = bootArtifact;
            return iterator;
        }
    }

    protected ConfigId getDefaultConfig() {
        return new ConfigId(STANDALONE, STANDALONE_MICROPROFILE_XML);
    }

    static Artifact getArtifact(String str) {
        String[] parts = str.split(":");
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = parts[2];
        String classifier = parts[3];
        String extension = parts[4];
        return new DefaultArtifact(groupId, artifactId, version, "provided", extension, classifier, (ArtifactHandler)new DefaultArtifactHandler(extension));
    }

    static void readProperties(Path propsFile, Map<String, String> propsMap) throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(propsFile);){
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && line.charAt(0) != '#') {
                    int i = line.indexOf(61);
                    if (i < 0) {
                        throw new Exception("Failed to parse property " + line + " from " + propsFile);
                    }
                    propsMap.put(line.substring(0, i), line.substring(i + 1));
                }
                line = reader.readLine();
            }
        }
    }

    private void deploy(List<String> commands) throws MojoExecutionException {
        if (this.hollowJar) {
            this.getLog().info((CharSequence)"Hollow jar, No application deployment added to server.");
            return;
        }
        File f = this.validateProjectFile();
        if (f == null) {
            if (this.externalDeployments.isEmpty()) {
                throw new MojoExecutionException("No external deployment found");
            }
            if (this.externalDeployments.size() == 1) {
                this.deployExternalDeployment(this.externalDeployments.get(0), true, commands);
            } else {
                if (this.isJarPackaging()) {
                    throw new MojoExecutionException("Multiple deployments not allowed for bootable JAR packaging.");
                }
                for (ExternalDeploymentArtifact externalDeployment : this.externalDeployments) {
                    this.deployExternalDeployment(externalDeployment, false, commands);
                }
            }
        } else {
            String runtimeName = f.getName();
            if ((this.project.getPackaging().equals(WAR) || runtimeName.endsWith(WAR)) && this.contextRoot) {
                runtimeName = "ROOT.war";
            }
            commands.add("deploy " + f.getAbsolutePath() + " --name=" + f.getName() + " --runtime-name=" + runtimeName);
        }
    }

    private static void zipServer(Path home, Path contentDir) throws IOException {
        Path target = contentDir.resolve("wildfly.zip");
        AbstractBuildBootableJarMojo.zip(home, target);
    }

    private void buildJar(Path contentDir, Path jarFile, Artifact artifact) throws MojoExecutionException, IOException {
        Path rtJarFile = this.resolveArtifact(artifact);
        ZipUtils.unzip((Path)rtJarFile, (Path)contentDir);
        AbstractBuildBootableJarMojo.zip(contentDir, jarFile);
    }

    private static void zip(final Path contentDir, Path jarFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(jarFile.toFile());
             final ZipOutputStream zos = new ZipOutputStream(fos);){
            Files.walkFileTree(contentDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (!contentDir.equals(dir)) {
                        AbstractBuildBootableJarMojo.zip(dir.toFile(), dir.toFile().getName(), zos);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    AbstractBuildBootableJarMojo.zip(file.toFile(), file.toFile().getName(), zos);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void zip(File fileToZip, String fileName, ZipOutputStream zos) throws IOException {
        if (fileToZip.isDirectory()) {
            File[] children;
            fileName = fileName.endsWith(File.separator) ? fileName.substring(0, fileName.length() - 1) : fileName;
            fileName = fileName + "/";
            zos.putNextEntry(new ZipEntry(fileName));
            zos.closeEntry();
            for (File childFile : children = fileToZip.listFiles()) {
                AbstractBuildBootableJarMojo.zip(childFile, fileName + childFile.getName(), zos);
            }
        } else {
            try (FileInputStream fis = new FileInputStream(fileToZip);){
                int length;
                ZipEntry zipEntry = new ZipEntry(fileName);
                zos.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zos.write(bytes, 0, length);
                }
            }
        }
    }

    public String retrievePluginVersion() throws PlexusConfigurationException, MojoExecutionException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/plugin.xml");
        if (is == null) {
            throw new MojoExecutionException("Can't retrieve plugin descriptor");
        }
        PluginDescriptorBuilder builder = new PluginDescriptorBuilder();
        PluginDescriptor pluginDescriptor = builder.build((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        return pluginDescriptor.getVersion();
    }

    public Path resolveArtifact(String groupId, String artifactId, String classifier, String version) throws UnsupportedEncodingException, PlexusConfigurationException, MojoExecutionException {
        return this.resolveArtifact((Artifact)new DefaultArtifact(groupId, artifactId, version, "provided", JAR, classifier, (ArtifactHandler)new DefaultArtifactHandler(JAR)));
    }

    Path resolveArtifact(Artifact artifact) throws MojoExecutionException {
        MavenArtifact mavenArtifact = new MavenArtifact();
        mavenArtifact.setGroupId(artifact.getGroupId());
        mavenArtifact.setArtifactId(artifact.getArtifactId());
        mavenArtifact.setVersion(artifact.getVersion());
        mavenArtifact.setClassifier(artifact.getClassifier());
        mavenArtifact.setExtension(artifact.getType());
        try {
            this.resolve(mavenArtifact);
            return mavenArtifact.getPath();
        }
        catch (IOException | MavenUniverseException ex) {
            throw new MojoExecutionException(ex.toString(), (Exception)ex);
        }
    }

    private boolean isThinServer() throws ProvisioningException {
        if (!this.pluginOptions.containsKey(JBOSS_MAVEN_DIST)) {
            return false;
        }
        String value = this.pluginOptions.get(JBOSS_MAVEN_DIST);
        return value == null ? true : Boolean.parseBoolean(value);
    }

    private void resolve(MavenArtifact artifact) throws MavenUniverseException, IOException {
        if (this.provisioningMavenRepo == null) {
            this.artifactResolver.resolve(artifact);
        } else {
            String grpid = artifact.getGroupId().replaceAll("\\.", Matcher.quoteReplacement(File.separator));
            Path grpidPath = this.provisioningMavenRepo.resolve(grpid);
            Path artifactidPath = grpidPath.resolve(artifact.getArtifactId());
            String version = this.getTransformedVersion(artifact);
            Path versionPath = artifactidPath.resolve(version);
            String classifier = artifact.getClassifier() == null || artifact.getClassifier().isEmpty() ? null : artifact.getClassifier();
            Path localPath = versionPath.resolve(artifact.getArtifactId() + "-" + version + (classifier == null ? "" : "-" + classifier) + "." + artifact.getExtension());
            if (Files.exists(localPath, new LinkOption[0])) {
                artifact.setPath(localPath);
            } else {
                this.artifactResolver.resolve(artifact);
            }
        }
    }

    private String getTransformedVersion(MavenArtifact artifact) {
        boolean transformed = !this.isExcludedFromTransformation(artifact);
        return artifact.getVersion() + (transformed ? this.jakartaTransformSuffix : "");
    }

    private boolean isExcludedFromTransformation(MavenArtifact artifact) {
        return this.transformExcluded.contains(this.artifactToString(artifact));
    }

    private String artifactToString(MavenArtifact artifact) {
        StringBuilder buf = new StringBuilder();
        if (artifact.getGroupId() != null) {
            buf.append(artifact.getGroupId());
        }
        buf.append(':');
        if (artifact.getArtifactId() != null) {
            buf.append(artifact.getArtifactId());
        }
        if (artifact.getVersion() != null) {
            buf.append(':').append(artifact.getVersion());
        }
        return buf.toString();
    }

    private void attachJar(Path jarFile) {
        this.debug("Attaching bootable jar %s as a project artifact", jarFile);
        this.projectHelper.attachArtifact(this.project, JAR, BOOTABLE_SUFFIX, jarFile.toFile());
    }

    void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(msg, args));
        }
    }

    static void deleteDir(Path root) {
        if (root == null || Files.notExists(root, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e != null) {
                        throw e;
                    }
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Path resolveMaven(ArtifactCoordinate coordinate) throws MavenUniverseException {
        MavenArtifact artifact = new MavenArtifact().setGroupId(coordinate.getGroupId()).setArtifactId(coordinate.getArtifactId()).setVersion(coordinate.getVersion()).setExtension(coordinate.getExtension()).setClassifier(coordinate.getClassifier());
        this.artifactResolver.resolve(artifact);
        return artifact.getPath();
    }

    private String getDeploymentRuntimeName(ExternalDeploymentArtifact externalDeployment, Artifact a, File artifactFile) throws MojoExecutionException {
        String runtimeName = externalDeployment.getRuntimeName();
        if (runtimeName == null) {
            return null;
        }
        int index = artifactFile.getName().lastIndexOf(".");
        if (index != -1) {
            runtimeName = runtimeName + "." + artifactFile.getName().substring(index + 1);
        }
        return runtimeName;
    }

    private void deployExternalDeployment(ExternalDeploymentArtifact externalDeployment, boolean singleDeployment, List<String> commands) throws MojoExecutionException {
        String runtimeName;
        File f;
        Artifact a = this.artifactVersions.getDeployment(externalDeployment);
        String customRuntimeName = this.getDeploymentRuntimeName(externalDeployment, a, f = this.resolveArtifact(a).toFile());
        String string = runtimeName = customRuntimeName == null ? f.getName() : customRuntimeName;
        if (singleDeployment && a.getType().equalsIgnoreCase(WAR) && this.contextRoot) {
            runtimeName = "ROOT.war";
        }
        this.getLog().info((CharSequence)("Deploying artifact " + f.getAbsolutePath() + ", runtime name " + runtimeName));
        commands.add("deploy " + f.getAbsolutePath() + " --name=" + f.getName() + " --runtime-name=" + runtimeName);
    }

    private class DefaultFeaturePacksConfig
    extends AbstractDefaultConfig {
        private final ProvisioningConfig.Builder state;

        private DefaultFeaturePacksConfig(ConfigId defaultConfigId, ProvisioningConfig.Builder state) throws ProvisioningException {
            super(defaultConfigId);
            Objects.requireNonNull(state);
            this.state = state;
        }

        @Override
        protected ProvisioningConfig.Builder buildState() throws ProvisioningException {
            return this.state;
        }
    }

    private abstract class AbstractDefaultConfig
    extends AbstractGalleonConfig {
        private AbstractDefaultConfig(ConfigId defaultConfigId) throws ProvisioningException {
            super(AbstractBuildBootableJarMojo.buildDefaultConfigBuilder(defaultConfigId));
            for (String layer : AbstractBuildBootableJarMojo.this.excludedLayers) {
                this.configBuilder.excludeLayer(layer);
            }
            for (String layer : AbstractBuildBootableJarMojo.this.extraLayers) {
                this.configBuilder.includeLayer(layer);
            }
        }
    }

    private class LayersFeaturePacksConfig
    extends AbstractLayersConfig {
        private final ProvisioningConfig.Builder state;

        private LayersFeaturePacksConfig(ProvisioningConfig.Builder state) throws ProvisioningDescriptionException, ProvisioningException {
            this.state = state;
        }

        @Override
        public ProvisioningConfig.Builder buildState() throws ProvisioningException {
            return this.state;
        }
    }

    private abstract class AbstractLayersConfig
    extends AbstractGalleonConfig {
        public AbstractLayersConfig() throws ProvisioningDescriptionException, ProvisioningException {
            super(ConfigModel.builder((String)AbstractBuildBootableJarMojo.STANDALONE, (String)AbstractBuildBootableJarMojo.STANDALONE_XML));
            for (String layer : AbstractBuildBootableJarMojo.this.layers) {
                this.configBuilder.includeLayer(layer);
            }
            for (String layer : AbstractBuildBootableJarMojo.this.extraLayers) {
                if (AbstractBuildBootableJarMojo.this.layers.contains(layer)) continue;
                this.configBuilder.includeLayer(layer);
            }
            for (String layer : AbstractBuildBootableJarMojo.this.excludedLayers) {
                this.configBuilder.excludeLayer(layer);
            }
        }
    }

    private abstract class AbstractGalleonConfig
    implements GalleonConfig {
        protected final ConfigModel.Builder configBuilder;

        AbstractGalleonConfig(ConfigModel.Builder configBuilder) throws ProvisioningException {
            Objects.requireNonNull(configBuilder);
            this.configBuilder = configBuilder;
            this.setupPluginOptions();
        }

        private void setupPluginOptions() throws ProvisioningException {
            if (AbstractBuildBootableJarMojo.this.pluginOptions.isEmpty()) {
                AbstractBuildBootableJarMojo.this.pluginOptions = Collections.singletonMap("optional-packages", "passive+");
            } else {
                Path path;
                String val;
                if (!AbstractBuildBootableJarMojo.this.pluginOptions.containsKey("optional-packages")) {
                    AbstractBuildBootableJarMojo.this.pluginOptions.put("optional-packages", "passive+");
                }
                if (AbstractBuildBootableJarMojo.this.pluginOptions.containsKey(AbstractBuildBootableJarMojo.MAVEN_REPO_PLUGIN_OPTION) && (val = AbstractBuildBootableJarMojo.this.pluginOptions.get(AbstractBuildBootableJarMojo.MAVEN_REPO_PLUGIN_OPTION)) != null && !(path = Paths.get(val, new String[0])).isAbsolute()) {
                    path = AbstractBuildBootableJarMojo.this.project.getBasedir().toPath().resolve(path);
                    AbstractBuildBootableJarMojo.this.pluginOptions.put(AbstractBuildBootableJarMojo.MAVEN_REPO_PLUGIN_OPTION, path.toString());
                }
            }
        }

        protected abstract ProvisioningConfig.Builder buildState() throws ProvisioningException;

        @Override
        public ProvisioningConfig buildConfig() throws ProvisioningException {
            ProvisioningConfig.Builder state = this.buildState();
            state.addConfig(this.configBuilder.build());
            state.addOptions(AbstractBuildBootableJarMojo.this.pluginOptions);
            return state.build();
        }
    }

    private class ProvisioningFileConfig
    implements GalleonConfig {
        private ProvisioningFileConfig() {
        }

        @Override
        public ProvisioningConfig buildConfig() throws ProvisioningException {
            return ProvisioningXmlParser.parse((Path)AbstractBuildBootableJarMojo.this.getProvisioningFile());
        }
    }

    private static interface GalleonConfig {
        public ProvisioningConfig buildConfig() throws ProvisioningException;
    }
}

